/*
 * Decompiled with CFR 0.152.
 */
package com.sigge.filerunner.view.activity;

import com.google.gson.JsonArray;
import com.sigge.dbrunner.Database;
import com.sigge.filerunner.action.ActionUtils;
import com.sigge.filerunner.config.ConfigHandler;
import com.sigge.filerunner.sql.sqlserver.queryplan.QueryPlanGraph;
import com.sigge.filerunner.view.IconUtils;
import com.sigge.filerunner.view.JMemoryDialog;
import com.sigge.filerunner.view.JMemoryFrame;
import com.sigge.filerunner.view.SpinnerCellEditor;
import com.sigge.filerunner.view.activity.Activity;
import com.sigge.filerunner.view.activity.ActivityCleaner;
import com.sigge.filerunner.view.activity.ActivityHandler;
import com.sigge.filerunner.view.activity.ActivityProcess;
import com.sigge.filerunner.view.activity.ActivityRateRenderer;
import com.sigge.filerunner.view.activity.ActivityServerCellRenderer;
import com.sigge.filerunner.view.activity.ActivityTableModel;
import com.sigge.filerunner.view.activity.ActivityTableRenderer;
import com.sigge.filerunner.view.activity.MonitorPanel;
import com.sigge.filerunner.view.activity.ServerMonitor;
import com.sigge.filerunner.view.activity.ServerMonitorTableModel;
import com.sigge.filerunner.view.core.ComponentUtils;
import com.sigge.filerunner.view.core.ITableSerializer;
import com.sigge.filerunner.view.core.VTable;
import com.sigge.filerunner.view.results.QueryPlanPanel;
import com.sigge.filerunner.view.results.queryplan.IQueryPlan;
import com.sigge.filerunner.view.rsyntaxtextarea.TextPaneUtil;
import com.siggemannen.backgroundrunner.BackgroundRunner;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.Collectors;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.DefaultRowSorter;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.RowSorter;
import javax.swing.SpinnerModel;
import javax.swing.SwingUtilities;
import javax.swing.table.TableModel;
import org.fife.ui.rsyntaxtextarea.RSyntaxTextArea;
import org.fife.ui.rtextarea.RTextArea;
import org.fife.ui.rtextarea.RTextScrollPane;
import org.jdesktop.swingx.VerticalLayout;
import org.oxbow.swingbits.table.filter.TableRowFilterSupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ActivityPresenter
implements Closeable {
    static final String VIEW_CONFIG_ACTIVITY_MONITOR_REFRESH_RATE = "viewConfig.ActivityMonitor.refreshRate";
    static final String VIEW_CONFIG_ACTIVITY_MONITOR_DECAY_RATE = "viewConfig.ActivityMonitor.decayhRate";
    static final String VIEW_CONFIG_ACTIVITY_MONITOR_DATABASES = "viewConfig.ActivityMonitor.databases";
    static final String VIEW_CONFIG_ACTIVITY_STUDY_QUERY_PLAN = "viewConfig.ActivityMonitor.study_query_plan";
    private final JPanel COMP_LEFT = new JPanel();
    private final JPanel COMP_RIGHT = new JPanel();
    private final List<Database> databases;
    private RSyntaxTextArea queryTextArea;
    private MonitorPanel monitoringPanel;
    private ActivityHandler handler;
    private Activity prev = null;
    private Action stopAction;
    private Action toggleQueryPlan;
    private Action studyQueryPlan;
    private Action exportPlan;
    private final String ALL_DISABLED = "AD";
    private JMemoryFrame fr;
    private static Logger LOGGER = LoggerFactory.getLogger(ActivityPresenter.class);
    private AtomicLong ab = new AtomicLong(0L);
    private QueryPlanPanel lastPanel;
    private ITableSerializer serializer;
    private IQueryPlan<?> lastQP;
    private ActivityCleaner listenerRegistry = new ActivityCleaner();

    public ActivityPresenter(List<Database> basadates, ITableSerializer serializer) {
        this.databases = basadates;
        this.serializer = serializer;
    }

    public void present(JFrame mainFrame, final MonitorPanel monitoringPanel) {
        this.monitoringPanel = monitoringPanel;
        ServerMonitorTableModel db = new ServerMonitorTableModel();
        db.setColumns(Arrays.asList("Monitor", "Server", "Refresh rate"));
        List<String> enabledDbs = ConfigHandler.getConfig().getListValues(VIEW_CONFIG_ACTIVITY_MONITOR_DATABASES);
        if (enabledDbs.size() == 0) {
            db.setRows(this.databases.stream().map(ServerMonitor::new).collect(Collectors.toList()));
        } else {
            String allDisabled = enabledDbs.get(0);
            if (allDisabled.equals("AD")) {
                db.setRows(this.databases.stream().map(ServerMonitor::new).map(e -> {
                    e.setMonitor(false);
                    return e;
                }).collect(Collectors.toList()));
            } else {
                db.setRows(this.databases.stream().map(d -> new ServerMonitor((Database)d, enabledDbs.contains(d.getUniqueProviderName()))).collect(Collectors.toList()));
            }
        }
        final VTable serverList = monitoringPanel.getServerList();
        serverList.setModel((TableModel)((Object)db));
        serverList.getColumn(0).setPreferredWidth(10);
        serverList.getColumn(1).setPreferredWidth(300);
        serverList.getColumn(2).setPreferredWidth(50);
        serverList.getColumn(2).setCellEditor(new SpinnerCellEditor(0, 0));
        serverList.getColumn(1).setCellRenderer(new ActivityServerCellRenderer());
        serverList.getColumn(2).setCellRenderer(new ActivityRateRenderer());
        this.serializer.restoreSettings((JTable)((Object)serverList), "activityPresent.serverList");
        this.fr = new JMemoryFrame("Server activity", "serverActivityFrame");
        this.fr.setIconImages(Arrays.asList(IconUtils.getIcon("activity.png").getImage(), IconUtils.getSmallIcon("activity.png").getImage()));
        this.fr.setDefaultCloseOperation(0);
        this.fr.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                ActivityPresenter.this.serializer.saveSettings((JTable)((Object)serverList), "activityPresent.serverList");
                ActivityPresenter.this.serializer.saveSettings((JTable)((Object)monitoringPanel.getProcessTable()), "activityPresent.processTable");
                ActivityPresenter.this.fr.removeWindowListener(this);
                try {
                    ActivityPresenter.this.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        });
        this.fr.getContentPane().add(monitoringPanel);
        final ActivityTableModel at = new ActivityTableModel();
        List<String> columns = Arrays.asList("Server", "Id", "Blocked by", "Text", "Database", "Object", "User", "Application", "Duration", "Completed%", "Reads", "Writes", "Tran. count");
        at.setColumns(columns);
        final VTable processTable = monitoringPanel.getProcessTable();
        processTable.setModel((TableModel)((Object)at));
        RowSorter sorter = processTable.getRowSorter();
        if (sorter instanceof DefaultRowSorter) {
            DefaultRowSorter drs = (DefaultRowSorter)sorter;
            drs.setComparator(7, Comparator.naturalOrder());
        }
        int x = 0;
        while (x < processTable.getColumnCount()) {
            processTable.getColumn(x).setCellRenderer(new ActivityTableRenderer(x));
            ++x;
        }
        TableRowFilterSupport.forTable((JTable)((Object)monitoringPanel.processTable)).useTableRenderers(true).searchable(true).apply();
        this.serializer.restoreSettings((JTable)((Object)processTable), "activityPresent.processTable");
        int refreshRate = ConfigHandler.getConfig().getNumberConfigValue(VIEW_CONFIG_ACTIVITY_MONITOR_REFRESH_RATE, 1).intValue();
        SpinnerModel refreshRateModel = monitoringPanel.getRefreshRate().getModel();
        refreshRateModel.setValue(refreshRate);
        this.listenerRegistry.addChangeListener(monitoringPanel.getRefreshRate(), l -> this.changeRate());
        int decay = ConfigHandler.getConfig().getNumberConfigValue(VIEW_CONFIG_ACTIVITY_MONITOR_DECAY_RATE, 10).intValue();
        SpinnerModel decayModel = monitoringPanel.getDecayRate().getModel();
        decayModel.setValue(decay);
        this.listenerRegistry.addChangeListener(monitoringPanel.getDecayRate(), l -> this.changeDecay());
        this.handler = new ActivityHandler(at, db.getDataVector(), refreshRate * 1000, decay * 1000);
        this.queryTextArea = new RSyntaxTextArea();
        RTextScrollPane rs = new RTextScrollPane((RTextArea)this.queryTextArea);
        TextPaneUtil.configureSyntaxTextArea(this.queryTextArea);
        this.queryTextArea.setSyntaxEditingStyle("text/tsql");
        this.queryTextArea.setText("");
        this.queryTextArea.setCaretPosition(0);
        TextPaneUtil.configureSyntaxTextArea(this.queryTextArea);
        this.COMP_LEFT.setLayout(new BorderLayout());
        this.COMP_RIGHT.setLayout(new BorderLayout());
        this.COMP_LEFT.add((Component)rs, "Center");
        monitoringPanel.getDetailsPane().setLeftComponent(this.COMP_LEFT);
        monitoringPanel.getDetailsPane().setRightComponent(this.COMP_RIGHT);
        this.stopAction = new AbstractAction("Stop", IconUtils.getSmallIcon("stop.png")){

            @Override
            public void actionPerformed(ActionEvent e) {
                int[] ixs = processTable.getSelectedRows();
                ArrayList<Activity> activities = new ArrayList<Activity>();
                int[] nArray = ixs;
                int n = ixs.length;
                int n2 = 0;
                while (n2 < n) {
                    ActivityProcess ax;
                    int ix = nArray[n2];
                    if (ix > -1 && (ax = (ActivityProcess)at.getValueAt(processTable.convertRowIndexToModel(ix))) != null && !ax.isQuarantine()) {
                        Activity activity = ax.getActivity();
                        activities.add(activity);
                    }
                    ++n2;
                }
                if (activities.size() == 0) {
                    return;
                }
                if (JOptionPane.showConfirmDialog(ActivityPresenter.this.fr, "Do you want to stop " + (activities.size() > 1 ? "processes" : "process") + " " + String.join((CharSequence)",", activities.stream().map(Activity::getId).collect(Collectors.toList())) + " @ server(s): " + String.join((CharSequence)",", activities.stream().map(Activity::getServer).distinct().map(Database::getLabel).collect(Collectors.toList())), "Confirm stopping", 0) == 0) {
                    ActivityPresenter.this.handler.stopActivity(activities.toArray(new Activity[0]));
                }
            }
        };
        this.stopAction.setEnabled(false);
        this.listenerRegistry.addAction(monitoringPanel.getStopProcess(), this.stopAction);
        this.toggleQueryPlan = new AbstractAction("Query plan", IconUtils.getSmallIcon("up_down_question.png")){
            private boolean toggled;
            {
                this.toggled = true;
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    if (this.toggled) {
                        ComponentUtils.unwrapPanelsFromASplitPane(ActivityPresenter.this.COMP_LEFT);
                    } else {
                        ComponentUtils.wrapPanelsIntoASplitPane(ActivityPresenter.this.COMP_LEFT, ActivityPresenter.this.COMP_RIGHT, "qp", false, false);
                        ActivityPresenter.this.prev = null;
                        ActivityPresenter.this.processRowChanged("toggleQueryPlan");
                    }
                }
                catch (Throwable throwable) {
                    this.toggled = !this.toggled;
                    throw throwable;
                }
                this.toggled = !this.toggled;
            }
        };
        this.toggleQueryPlan.putValue("SwingSelectedKey", true);
        this.listenerRegistry.addAction(monitoringPanel.getQueryPlanToggle(), this.toggleQueryPlan);
        this.studyQueryPlan = ActionUtils.createAction("Study plan...", "up_down_question_up.png", true, () -> {
            List<QueryPlanPanel> res;
            if (this.lastQP != null && (res = this.lastQP.createQueryPlanPanels(false)) != null && res.size() > 0) {
                JScrollPane js = new JScrollPane();
                JPanel jp = new JPanel();
                jp.setLayout((LayoutManager)new VerticalLayout(0));
                js.setViewportView(jp);
                jp.add(res.get(0));
                JSplitPane jp2 = new JSplitPane(1);
                RSyntaxTextArea queryTextArea = new RSyntaxTextArea();
                RTextScrollPane rs2 = new RTextScrollPane((RTextArea)queryTextArea);
                TextPaneUtil.configureSyntaxTextArea(queryTextArea);
                queryTextArea.setSyntaxEditingStyle("text/tsql");
                queryTextArea.setText("");
                TextPaneUtil.configureSyntaxTextArea(queryTextArea);
                queryTextArea.setText(this.queryTextArea.getText());
                queryTextArea.setCaretPosition(0);
                jp2.setLeftComponent((Component)rs2);
                jp2.setRightComponent(js);
                jp2.setDividerLocation(0.3);
                jp2.setResizeWeight(0.5);
                jp2.revalidate();
                JMemoryDialog jm = new JMemoryDialog(this.fr, "Query plan", false, VIEW_CONFIG_ACTIVITY_STUDY_QUERY_PLAN);
                jm.getContentPane().add(jp2);
                if (jm.isSizeSetFromSettings()) {
                    jm.pack();
                }
                jp2.setDividerLocation(0.5);
                jm.centerOnCorrectScreen(this.fr);
                jm.setVisible(true);
            }
        }, null);
        this.listenerRegistry.addAction(monitoringPanel.getStudyPlanButton(), this.studyQueryPlan);
        this.studyQueryPlan.setEnabled(false);
        this.exportPlan = ActionUtils.createAction("Export plan", "export2.png", true, () -> {
            if (this.lastQP != null) {
                this.lastQP.export();
            }
        });
        this.listenerRegistry.addAction(monitoringPanel.getExportButton(), this.exportPlan);
        this.exportPlan.setEnabled(false);
        this.listenerRegistry.addTableSelectionListener((JTable)((Object)processTable), e -> {
            if (!e.getValueIsAdjusting()) {
                this.processRowChanged("addListSelectionListener");
            }
        });
        this.listenerRegistry.addTableListener((JTable)((Object)processTable), e -> {
            int minRow = Math.min(e.getFirstRow(), e.getLastRow());
            int maxRow = Math.max(e.getFirstRow(), e.getLastRow());
            int selectedRow = processTable.getSelectedRow();
            if (minRow > selectedRow) {
                return;
            }
            if (e.getType() < 1 && maxRow < selectedRow) {
                return;
            }
            if (selectedRow == minRow && selectedRow == maxRow && this.getFromType(e.getType()).equals("DELETE")) {
                return;
            }
            this.processRowChanged("addTableModelListener");
        });
        this.listenerRegistry.addTableListener((JTable)((Object)serverList), e -> this.refreshServers(db));
        if (!this.fr.isSizeSetFromSettings()) {
            this.fr.pack();
        }
        this.fr.setLocationRelativeTo(mainFrame == null ? new JFrame() : new JFrame(mainFrame.getGraphicsConfiguration()));
        this.fr.setVisible(true);
        monitoringPanel.getDetailsPane().setDividerLocation(0.5);
    }

    private String getFromType(int type) {
        switch (type) {
            case -1: {
                return "DELETE";
            }
            case 0: {
                return "UPDATE";
            }
            case 1: {
                return "INSERT";
            }
        }
        return "UNKNOWN";
    }

    private void saveNewValue(String config, int value) {
        ConfigHandler.getConfig().setConfigValue(config, value);
    }

    private void changeRate() {
        int newRate = (Integer)this.monitoringPanel.getRefreshRate().getModel().getValue();
        this.saveNewValue(VIEW_CONFIG_ACTIVITY_MONITOR_REFRESH_RATE, newRate);
        this.handler.setDefaultRate(newRate * 1000);
    }

    private void changeDecay() {
        int newRate = (Integer)this.monitoringPanel.getDecayRate().getModel().getValue();
        this.saveNewValue(VIEW_CONFIG_ACTIVITY_MONITOR_DECAY_RATE, newRate);
        this.handler.changeDecayRate(newRate * 1000);
    }

    private void cleanUpPanel() {
        QueryPlanGraph qg;
        if (this.lastQP != null) {
            try {
                this.lastQP.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (this.lastPanel != null && (qg = this.lastPanel.getGraph()) != null) {
            try {
                qg.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private void processRowChanged(String source) {
        int row = this.monitoringPanel.getProcessTable().getSelectedRow();
        if (row == -1) {
            this.stopAction.setEnabled(false);
        }
        if (row > -1) {
            row = this.monitoringPanel.getProcessTable().convertRowIndexToModel(row);
            try {
                ActivityProcess acp = null;
                if (row < this.monitoringPanel.getProcessTable().getModel().getRowCount()) {
                    acp = (ActivityProcess)((ActivityTableModel)((Object)this.monitoringPanel.getProcessTable().getModel())).getValueAt(row);
                }
                this.stopAction.setEnabled(acp != null && !acp.isQuarantine());
                if (acp == null) {
                    this.queryTextArea.setText("");
                    this.queryTextArea.discardAllEdits();
                    this.queryTextArea.setCaretPosition(0);
                    this.COMP_RIGHT.removeAll();
                    this.ab.incrementAndGet();
                    this.cleanUpPanel();
                    this.lastQP = null;
                    this.studyQueryPlan.setEnabled(false);
                    this.exportPlan.setEnabled(false);
                } else if (!(this.prev != null && this.prev.isContinuationOf(acp.getActivity()) && this.prev.getQuery().equals(acp.getActivity().getQuery()) && this.prev.getExtraFields().equals(acp.getActivity().getExtraFields()))) {
                    long counter = this.ab.incrementAndGet();
                    Activity ac = acp.getActivity();
                    String currentText = this.queryTextArea.getText();
                    if (!currentText.equals(ac.getQuery())) {
                        this.queryTextArea.setText(ac.getQuery());
                        this.queryTextArea.discardAllEdits();
                        this.queryTextArea.setCaretPosition(0);
                        this.COMP_RIGHT.removeAll();
                        this.cleanUpPanel();
                        this.lastPanel = null;
                        this.lastQP = null;
                        this.studyQueryPlan.setEnabled(false);
                        this.exportPlan.setEnabled(false);
                        if (this.COMP_LEFT.getParent() instanceof JSplitPane) {
                            JSplitPane jp = (JSplitPane)this.COMP_LEFT.getParent();
                            jp.setDividerLocation(jp.getDividerLocation());
                        }
                    }
                    if (((Boolean)this.toggleQueryPlan.getValue("SwingSelectedKey")).booleanValue()) {
                        IQueryPlan<?> ox = ac.getQueryPlan();
                        if (ox != null) {
                            if (this.lastQP != null && this.lastPanel != null && ac.getExtraFields().size() > 0 && currentText.equals(ac.getQuery()) && (this.prev == null || ac.isSameQueryForQueryPlan(this.prev))) {
                                this.lastQP.updateFrom(ac);
                                return;
                            }
                            new BackgroundRunner(() -> {
                                List<QueryPlanPanel> res = ox.getQueryPlanPanels();
                                JScrollPane js = new JScrollPane();
                                JPanel jp = new JPanel();
                                jp.setLayout((LayoutManager)new VerticalLayout(0));
                                js.setViewportView(jp);
                                if (this.ab.get() != counter) {
                                    return;
                                }
                                SwingUtilities.invokeLater(() -> {
                                    this.COMP_RIGHT.removeAll();
                                    this.COMP_RIGHT.add((Component)js, "Center");
                                    this.cleanUpPanel();
                                    for (QueryPlanPanel p : res) {
                                        p.setName("activityPresenter");
                                        jp.add(p);
                                    }
                                    if (res.size() == 1) {
                                        this.lastPanel = (QueryPlanPanel)res.get(0);
                                        this.lastQP = ox;
                                        this.studyQueryPlan.setEnabled(true);
                                        this.exportPlan.setEnabled(true);
                                    } else {
                                        this.lastPanel = null;
                                        this.lastQP = null;
                                        this.studyQueryPlan.setEnabled(false);
                                        this.exportPlan.setEnabled(false);
                                    }
                                    if (this.COMP_LEFT.getParent() instanceof JSplitPane) {
                                        JSplitPane jpx = (JSplitPane)this.COMP_LEFT.getParent();
                                        jpx.setDividerLocation(jpx.getDividerLocation());
                                    }
                                });
                            }).execute();
                        } else {
                            SwingUtilities.invokeLater(() -> {
                                this.COMP_RIGHT.removeAll();
                                this.cleanUpPanel();
                                this.lastPanel = null;
                                this.lastQP = null;
                                this.studyQueryPlan.setEnabled(false);
                                this.exportPlan.setEnabled(false);
                                if (this.COMP_LEFT.getParent() instanceof JSplitPane) {
                                    JSplitPane jpx = (JSplitPane)this.COMP_LEFT.getParent();
                                    jpx.setDividerLocation(jpx.getDividerLocation());
                                }
                            });
                        }
                    }
                    this.prev = ac;
                }
            }
            catch (Exception ex) {
                LOGGER.error("Error while refreshing row", (Throwable)ex);
            }
        }
    }

    private void refreshServers(ServerMonitorTableModel db) {
        List dataVector = db.getDataVector();
        JsonArray arr = new JsonArray();
        dataVector.stream().filter(ServerMonitor::isMonitor).forEach(sm -> arr.add(sm.getServer().getUniqueProviderName()));
        if (arr.size() == 0) {
            arr.add("AD");
        }
        ConfigHandler.getConfig().setConfigValue(VIEW_CONFIG_ACTIVITY_MONITOR_DATABASES, arr);
        ConfigHandler.saveInBackground();
        this.handler.setMonitorServers(dataVector);
    }

    @Override
    public void close() throws IOException {
        try {
            this.handler.close();
        }
        finally {
            this.listenerRegistry.close();
            this.fr.dispose();
            this.cleanUpPanel();
            this.fr = null;
            this.handler = null;
            this.lastQP = null;
            this.stopAction = null;
            this.lastPanel = null;
            this.studyQueryPlan = null;
            this.exportPlan = null;
            this.prev = null;
            this.toggleQueryPlan = null;
            this.monitoringPanel = null;
            this.listenerRegistry = null;
        }
    }
}

