/*
 * Decompiled with CFR 0.152.
 */
package com.sigge.filerunner.view;

import java.io.PrintWriter;
import java.io.StringWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SwingExceptionHandler
implements Thread.UncaughtExceptionHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(SwingExceptionHandler.class);

    @Override
    public void uncaughtException(Thread t, Throwable e) {
        String stackTrace = this.generateStackTrace(e);
        if (stackTrace != null) {
            LOGGER.error(stackTrace, e);
        }
    }

    private String generateStackTrace(Throwable e) {
        StringWriter writer = new StringWriter();
        Throwable throwable = null;
        Object var4_5 = null;
        try (PrintWriter pw = new PrintWriter(writer);){
            e.printStackTrace(pw);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        return writer.toString();
    }
}

