/*
 * Decompiled with CFR 0.152.
 */
package com.sigge.filerunner.view;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import com.google.inject.name.Named;
import com.sigge.filerunner.action.FileRunnerAction;
import com.sigge.filerunner.completion.DBCompletion;
import com.sigge.filerunner.completion.DBContextOperator;
import com.sigge.filerunner.completion.SQLAutoCompletion;
import com.sigge.filerunner.config.Config;
import com.sigge.filerunner.config.ConfigHandler;
import com.sigge.filerunner.core.StringUtils;
import com.sigge.filerunner.sql.DatabaseManager;
import com.sigge.filerunner.sql.SQLManager;
import com.sigge.filerunner.sql.ServerDatabase;
import com.sigge.filerunner.sql.ThreadedValidator;
import com.sigge.filerunner.sql.edit.IEditor;
import com.sigge.filerunner.view.IEditorManager;
import com.sigge.filerunner.view.IEditorResource;
import com.sigge.filerunner.view.RunnerModel;
import com.sigge.filerunner.view.RunnerView;
import com.sigge.filerunner.view.StatusUpdater;
import com.sigge.filerunner.view.core.CaretStateUpdate;
import com.sigge.filerunner.view.rsyntaxtextarea.DefaultLinkGenerator;
import com.sigge.filerunner.view.rsyntaxtextarea.RTATextTransferHandlerWithNewLines;
import com.sigge.filerunner.view.rsyntaxtextarea.TextPaneUtil;
import com.sigge.filerunner.view.rsyntaxtextarea.completion.IPopupHandler;
import com.sigge.filerunner.view.rsyntaxtextarea.csv.TextTransformer;
import com.sigge.filerunner.view.runners.IRunningState;
import com.sigge.filerunner.view.runners.SQLScriptState;
import com.sigge.filerunner.view.tabs.ITabEditor;
import com.sigge.filerunner.view.tabs.TabContent;
import com.sigge.filerunner.view.tabs.TabContentEditorListener;
import com.sigge.filerunner.view.tabs.TabListener;
import com.sigge.filerunner.view.tabs.TabManager;
import com.siggemannen.backgroundrunner.AccumulatedBackgroundRunner;
import com.siggemannen.binding.ADocumentAdapter;
import com.siggemannen.core.Tuple;
import com.siggemannen.view.DnDTabbedPane;
import java.awt.Color;
import java.awt.Component;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseMotionListener;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.TransferHandler;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.JTextComponent;
import org.fife.ui.autocomplete.AutoCompletion;
import org.fife.ui.autocomplete.Completion;
import org.fife.ui.autocomplete.CompletionProvider;
import org.fife.ui.autocomplete.DefaultCompletionProvider;
import org.fife.ui.rsyntaxtextarea.LinkGenerator;
import org.fife.ui.rsyntaxtextarea.RSyntaxTextArea;
import org.fife.ui.rsyntaxtextarea.RSyntaxUtilities;
import org.fife.ui.rsyntaxtextarea.Token;
import org.fife.ui.rsyntaxtextarea.parser.Parser;
import org.fife.ui.rsyntaxtextarea.parser.XmlParser;
import org.fife.ui.rtextarea.SearchContext;
import org.fife.ui.rtextarea.SearchEngine;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class EditorManager
implements TabContentEditorListener,
IEditorManager {
    private final RunnerView runnerView;
    private final TabManager manager;
    private final Parser xmlParser = new XmlParser();
    @Inject
    @Named(value="mainTab")
    DnDTabbedPane tabPane;
    private final CaretListener selectionListener;
    private final ADocumentAdapter documentListener;
    private final List<TabListener> listeners = new ArrayList<TabListener>();
    private final SQLManager sqlManager;
    @Inject
    private IPopupHandler popupHandler;
    private final DefaultCompletionProvider provider;
    @Inject
    TextTransformer transformer;
    @Inject
    IRunningState state;
    @Inject
    private Map<RSyntaxTextArea, Tuple<List<AutoCompletion>, DBCompletion>> completionMap;
    @Inject
    Set<IEditorResource> resources;
    @Inject
    IEditor parser;
    private final StatusUpdater updater;
    private boolean suspendSaving;
    private static Logger LOGGER = LoggerFactory.getLogger(EditorManager.class);
    private final JFrame mainFrame;
    private final RunnerModel model;
    private volatile boolean configured = false;
    private final List<File> leechers = new ArrayList<File>();
    private final FileRunnerAction paste;

    @Inject
    public EditorManager(@Named(value="mainFrame") JFrame mainFrame, RunnerView rv, SQLManager sqlManager, DefaultCompletionProvider provider, TabManager manager, StatusUpdater updater, RunnerModel model, @Named(value="PASTE") FileRunnerAction paste) {
        this.paste = paste;
        LOGGER.debug("Create editormanager");
        this.mainFrame = mainFrame;
        this.runnerView = rv;
        this.sqlManager = sqlManager;
        this.provider = provider;
        this.manager = manager;
        this.updater = updater;
        this.model = model;
        this.selectionListener = this::caretDelegate;
        manager.addContentEditorListener(this);
        this.documentListener = new ADocumentAdapter(){

            protected void setValueFromDocument(DocumentEvent e) {
                EditorManager.this.saveSettingsInternal();
            }
        };
    }

    @Override
    public void addContentEditorListener(TabContentEditorListener tl) {
        this.manager.addContentEditorListener(tl);
    }

    @Override
    public void addTabListener(TabListener tb) {
        this.listeners.add(tb);
    }

    public void removeTabListener(TabListener tb) {
        this.listeners.remove(tb);
    }

    @Override
    public TabContent currentTab() {
        return this.manager.currentTab();
    }

    @Override
    public void setRunning(TabContent tabContent, boolean running) {
        this.manager.setRunning(tabContent, running);
    }

    @Override
    public synchronized List<Tuple<File, String>> configure(Consumer<Runnable> doAfterAdding) {
        LOGGER.debug("Configuring editors");
        this.tabPane.setTabLayoutPolicy(1);
        List contents = (List)this.model.getContents().getValue();
        if (contents.isEmpty()) {
            contents.add(new TabContent("Untitled", ""));
        } else {
            Config config = ConfigHandler.getConfig();
            List<List<String>> lastDatabases = config.getLastDatabases();
            int i = 0;
            while (i < contents.size()) {
                List<String> dbs;
                TabContent tc = (TabContent)contents.get(i);
                if (lastDatabases.size() > i && (dbs = lastDatabases.get(i)) != null && dbs.size() > 0) {
                    String db = dbs.get(0);
                    ServerDatabase serverDatabase = DatabaseManager.findDb(db);
                }
                ++i;
            }
        }
        this.suspendSaving = true;
        this.parser.setOnInit(true);
        ArrayList<Tuple<File, String>> mess = new ArrayList();
        try {
            int newIndex = this.manager.create(contents, (Integer)this.model.getCurrentIndex().getValue());
            doAfterAdding.accept(() -> {
                if (newIndex >= 0) {
                    this.manager.setCurrent(newIndex);
                }
                if (this.model.getCurrentEditor().getValue() == null) {
                    this.model.getCurrentEditor().setValue((Object)this.manager.currentTextArea());
                }
            });
            mess = this.openFiles(this.leechers);
            this.leechers.clear();
        }
        finally {
            this.suspendSaving = false;
            this.configured = true;
        }
        this.parser.setOnInit(false);
        this.tabPane.setTabLayoutPolicy(1);
        LOGGER.debug("Finished configuring editors");
        this.saveSettingsInternal();
        return mess;
    }

    private void caretDelegate(CaretEvent e) {
        RSyntaxTextArea source = (RSyntaxTextArea)e.getSource();
        TabContent tc = this.manager.getContentFromArea(source);
        this.updater.caretStateUpdate(CaretStateUpdate.getFromTextArea(source, tc));
    }

    @Override
    public void editorAdded(TabContent tc, RSyntaxTextArea rx) {
        TextPaneUtil.configureSyntaxTextArea(rx);
        rx.getActionMap().put("cancelSearch", new AbstractAction("cancelSearch"){

            @Override
            public void actionPerformed(ActionEvent e) {
                SearchEngine.find((JTextArea)e.getSource(), new SearchContext(null));
                EditorManager.this.updater.removeMessage("searches");
            }
        });
        rx.getActionMap().put("paste-from-clipboard", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                EditorManager.this.paste.actionPerformed(e);
            }
        });
        rx.getInputMap().put(KeyStroke.getKeyStroke(27, 0), "cancelSearch");
        DBCompletion completions = new DBCompletion(rx, (CompletionProvider)this.provider, this.sqlManager, this.popupHandler, this.parser);
        DBContextOperator dbo = new DBContextOperator(completions);
        if (tc.getContentType() == null || tc.getContentType().equals("text/tsql")) {
            new ThreadedValidator(rx, this.parser);
            this.parser.register(rx, tc);
            rx.setCloseCurlyBraces(false);
        } else if (tc.getContentType().equals("text/xml")) {
            rx.addParser(this.xmlParser);
            rx.setCloseCurlyBraces(false);
        }
        SQLAutoCompletion ac = new SQLAutoCompletion(completions);
        ac.setAutoActivationDelay(400);
        ac.setShowDescWindow(true);
        DefaultLinkGenerator generator = new DefaultLinkGenerator(completions);
        final AutoCompletion ac2 = new AutoCompletion((CompletionProvider)dbo){

            protected void insertCompletion(Completion c, boolean typedParamListStartChar) {
                DBContextOperator.ActionCompletion actionCompletion = (DBContextOperator.ActionCompletion)c;
                this.hidePopupWindow();
                actionCompletion.getRunnable().run();
            }
        };
        ac2.setAutoActivationEnabled(false);
        ac2.setAutoCompleteSingleChoices(false);
        ac2.install((JTextComponent)rx);
        InputMap im = rx.getInputMap();
        im.put(KeyStroke.getKeyStroke(49, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()), "trigger_comp");
        ActionMap am = rx.getActionMap();
        am.put("trigger_comp", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ac2.doCompletion();
            }
        });
        rx.setLinkGenerator((LinkGenerator)generator);
        rx.addMouseMotionListener((MouseMotionListener)generator);
        rx.addKeyListener((KeyListener)generator);
        ac.setParameterAssistanceEnabled(true);
        ac.setAutoActivationEnabled(true);
        ac.setAutoCompleteSingleChoices(false);
        rx.setCodeFoldingEnabled(true);
        ac.install((JTextComponent)rx);
        ac.addCompletionListener(completions);
        this.completionMap.put(rx, (Tuple<List<AutoCompletion>, DBCompletion>)new Tuple(Arrays.asList(new AutoCompletion[]{ac, ac2}), (Object)completions));
        RTATextTransferHandlerWithNewLines newHandler = new RTATextTransferHandlerWithNewLines(this.transformer, this.manager::openFiles);
        rx.setTransferHandler((TransferHandler)newHandler);
        if (!this.suspendSaving) {
            this.saveSettingsInternal();
        }
        int i = this.listeners.size() - 1;
        while (i >= 0) {
            TabListener l = this.listeners.get(i);
            l.editorAdded(tc);
            --i;
        }
    }

    @Override
    public String getCurrentText() {
        return ((RSyntaxTextArea)this.model.getCurrentEditor().getValue()).getText();
    }

    @Override
    public void newActive(TabContent tc, ITabEditor editor) {
        Object comp;
        RSyntaxTextArea current = (RSyntaxTextArea)this.model.getCurrentEditor().getValue();
        if (current != null) {
            current.removeCaretListener(this.selectionListener);
            current.getDocument().removeDocumentListener((DocumentListener)this.documentListener);
        }
        if ((comp = editor.getEditorComponent()) == null) {
            LOGGER.error("rx is not supposed to be null");
        }
        RSyntaxTextArea rx = comp instanceof RSyntaxTextArea ? (RSyntaxTextArea)comp : null;
        this.model.getCurrentEditor().setValue((Object)rx);
        this.model.getSelectedScript().setValue((Object)(rx != null ? StringUtils.isBlank(rx.getSelectedText(), "") : ""));
        this.model.getCursorToken().setValue((Object)(rx == null ? "" : this.tokenAtCursor(rx)));
        if (rx != null) {
            rx.addCaretListener(this.selectionListener);
            rx.getDocument().addDocumentListener((DocumentListener)this.documentListener);
        }
        int i = this.listeners.size() - 1;
        while (i >= 0) {
            this.listeners.get(i).newActive(tc);
            --i;
        }
        SwingUtilities.invokeLater(() -> this.updater.caretStateUpdate(rx == null ? null : CaretStateUpdate.getFromTextArea(rx, tc)));
    }

    private String tokenAtCursor(RSyntaxTextArea rsta) {
        Token curToken = RSyntaxUtilities.getTokenAtOffset((RSyntaxTextArea)rsta, (int)rsta.getCaretPosition());
        if (curToken == null) {
            return "";
        }
        return curToken.getLexeme();
    }

    @Override
    public List<TabContent> getDirtyTabContents() {
        return this.manager.getDirtyTabContents();
    }

    @Override
    public synchronized List<Tuple<File, String>> openFiles(List<File> files) {
        if (!this.configured) {
            this.leechers.addAll(files);
            return Collections.EMPTY_LIST;
        }
        return this.manager.openFiles(files);
    }

    public TabContent newFile(String title, String content) {
        return this.manager.add(title, content);
    }

    @Override
    public TabContent newFile(String title, String content, String contentType) {
        return this.manager.add(title, content, contentType);
    }

    @Override
    public TabContent newFile(String title, String content, Map<String, Object> contextValue) {
        return this.manager.add(title, content, contextValue);
    }

    public void replaceCurrent(String title, String content) {
        boolean assignTitle = this.currentTab().getStateValue("ORIGINALTITLE") == null;
        TabContent tc = new TabContent(assignTitle ? title : this.currentTab().getTitle(), content, this.currentTab().getContentType());
        tc.assignId(this.currentTab().getId());
        tc.setStateValue("ORIGINALTITLE", this.currentTab().getTitle());
        this.manager.replaceTab(tc);
    }

    @Override
    public RSyntaxTextArea getCurrentTab() {
        return this.manager.currentTextArea();
    }

    @Override
    public RSyntaxTextArea getAreaForContent(TabContent tc) {
        return this.manager.getAreaForContent(tc);
    }

    public TabContent getContentForArea(RSyntaxTextArea tc) {
        return this.manager.getContentFromArea(tc);
    }

    @Override
    public void editorRemoved(TabContent tc, ITabEditor editor) {
        Object ex = editor.getEditorComponent();
        if (ex instanceof RSyntaxTextArea) {
            RSyntaxTextArea rx = (RSyntaxTextArea)ex;
            this.parser.unregister(rx);
            Tuple<List<AutoCompletion>, DBCompletion> db = this.completionMap.remove(rx);
            if (db != null) {
                ((List)db.first()).forEach(AutoCompletion::uninstall);
            }
            for (IEditorResource resource : this.resources) {
                resource.close(rx);
            }
            rx.clearParsers();
            try {
                if (db != null) {
                    ((DBCompletion)db.second()).close();
                }
            }
            catch (IOException e) {
                LOGGER.error("Error while closing " + db.second(), (Throwable)e);
            }
            rx.getDocument().removeDocumentListener((DocumentListener)this.documentListener);
            rx.removeCaretListener(this.selectionListener);
        }
        this.listeners.forEach(l -> l.editorRemoved(tc));
        if (!this.suspendSaving) {
            this.saveSettingsInternal();
        }
    }

    @Override
    public boolean previewEditorRemoval(TabContent tc, ITabEditor rx) {
        if (tc.isAFile() && this.manager.isDirty(tc)) {
            int res = JOptionPane.showOptionDialog((Component)((Object)this.runnerView), "This file is changed and the changes will be lost, do you want to save file before closing?", "There are unsaved changes", 1, 3, null, new String[]{"Save before closing", "Close without saving", "Don't close / abort"}, "Save before closing");
            if (res == 0) {
                this.manager.saveFile();
            }
            if (res == -1 || res == 2) {
                return false;
            }
        }
        return true;
    }

    private synchronized void saveSettingsInternal() {
        AccumulatedBackgroundRunner.schedule((String)"saveSettings", () -> this.saveSettings(), (int)15000, (TimeUnit)TimeUnit.MILLISECONDS);
    }

    @Override
    public void saveSettings() {
        List<TabContent> dumpContents = this.manager.dumpContents();
        Config config = ConfigHandler.getConfig();
        config.setContents(dumpContents);
        config.setFrozenContents(config.getFrozenContents().stream().map(tc -> new TabContent(tc.getTitle(), tc.getFileName(), tc.isAFile() ? "" : tc.getContent(), tc.getEncoding(), tc.getContentType())).collect(Collectors.toList()));
        config.setLastContentIndex(this.manager.currentTabIndex());
        config.setConfigValue("viewConfig.maximizedState", (this.mainFrame.getExtendedState() & 6) > 0);
        if (this.sqlManager.getCurrents().size() > 0) {
            config.setLastSelectedDatabases(this.sqlManager.getCurrents().stream().map(ServerDatabase::getId).collect(Collectors.toList()));
        }
        ArrayList<List<String>> database = new ArrayList<List<String>>();
        for (TabContent tab : dumpContents) {
            SQLScriptState tcState = this.state.getCurrentState(tab);
            if (tcState == null) continue;
            List<ServerDatabase> currs = tcState.getCurrentDatabases();
            if (currs == null || currs.size() == 0) {
                database.add(new ArrayList());
                continue;
            }
            database.add(currs.stream().map(ServerDatabase::getId).collect(Collectors.toList()));
        }
        config.setLastDatabases(database);
        ConfigHandler.saveAndIgnoreErrors();
    }

    @Override
    public JPanel getContentPanelForContent(TabContent tc) {
        return this.manager.getContent(tc);
    }

    @Override
    public void setTabColor(TabContent tabContent, Color color) {
        this.manager.setColor(tabContent, color);
    }

    @Override
    public JTabbedPane getTab() {
        return this.tabPane;
    }
}

