/*
 * Decompiled with CFR 0.152.
 */
package com.sigge.filerunner.sql.transform.select.source;

import com.sigge.filerunner.sql.transform.expression.BaseExpression;
import com.sigge.filerunner.sql.transform.expression.BaseExpressionVisitor;
import com.sigge.filerunner.sql.transform.expression.Expression;
import com.sigge.filerunner.sql.transform.expression.ExpressionVisitor;
import com.sigge.filerunner.sql.transform.expression.SQLName;
import com.sigge.filerunner.sql.transform.expression.scalars.ChangesArguments;
import com.sigge.filerunner.sql.transform.expression.scalars.FunctionCall;
import com.sigge.filerunner.sql.transform.expression.scalars.VariableExpression;
import com.sigge.filerunner.sql.transform.expression.scalars.VersionArguments;
import com.sigge.filerunner.sql.transform.expression.scalars.xml.XMLNodesExpression;
import com.sigge.filerunner.sql.transform.select.source.Alias;
import com.sigge.filerunner.sql.transform.select.source.ColumnAlias;
import com.sigge.filerunner.sql.transform.select.source.DerivedTable;
import com.sigge.filerunner.sql.transform.select.source.GenericSource;
import com.sigge.filerunner.sql.transform.select.source.Hint;
import com.sigge.filerunner.sql.transform.select.source.OpenQuery;
import com.sigge.filerunner.sql.transform.select.source.SourceType;
import com.sigge.filerunner.sql.transform.select.source.Table;
import com.sigge.filerunner.sql.transform.select.source.TableSource;
import com.sigge.filerunner.sql.transform.select.source.TableVariable;
import com.siggemannen.sql.antler.TSqlParser;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.antlr.v4.runtime.ParserRuleContext;
import org.antlr.v4.runtime.Token;
import org.antlr.v4.runtime.tree.ParseTree;
import org.antlr.v4.runtime.tree.ParseTreeVisitor;

public class Source
extends BaseExpression {
    private Expression source;
    private Alias alias;
    private final List<Hint> hints = new ArrayList<Hint>();
    private List<ColumnAlias> columnAliases = new ArrayList<ColumnAlias>();
    private SourceType sourceType;

    public Source(TSqlParser.Table_source_itemContext pt) {
        super((ParseTree)pt);
        TSqlParser.Function_callContext oldstyle;
        TSqlParser.Old_function_sourceContext oldFunctionSource;
        TSqlParser.Nodes_methodContext nodes;
        Token locIdCall;
        Token localId;
        TSqlParser.Function_callContext fCall;
        TSqlParser.Change_tableContext change_table;
        TSqlParser.Derived_tableContext derived;
        TSqlParser.Derived_table_sourceContext derivedSource;
        TSqlParser.Rowset_functionContext rowset;
        TSqlParser.Full_table_nameContext fullname;
        TSqlParser.Table_name_with_hintContext tableName;
        TSqlParser.Simple_table_name_sourceContext simple = pt.simple_table_name_source();
        if (simple != null && (tableName = simple.table_name_with_hint()) != null) {
            this.tableNameWithHint(tableName);
            this.parseAlias(simple.as_table_alias());
            this.sourceType = SourceType.TABLE;
            return;
        }
        TSqlParser.Full_table_name_sourceContext fullTable = pt.full_table_name_source();
        if (fullTable != null && (fullname = fullTable.full_table_name()) != null) {
            this.source = new Table(fullname);
            this.sourceType = SourceType.TABLE;
            this.parseAlias(fullTable.as_table_alias());
            return;
        }
        TSqlParser.Rowset_function_sourceContext rowsetSource = pt.rowset_function_source();
        if (rowsetSource != null && (rowset = rowsetSource.rowset_function()) != null) {
            this.sourceType = SourceType.ROWSET;
            this.parseAlias(rowsetSource.as_table_alias());
        }
        if ((derivedSource = pt.derived_table_source()) != null && (derived = derivedSource.derived_table()) != null) {
            this.source = new DerivedTable(derived);
            this.parseAliasWithoutHints(derivedSource.as_table_alias_without_hints());
            this.sourceType = SourceType.DERIVED;
            this.parseColumnListAlias(derivedSource.column_alias_list());
            return;
        }
        TSqlParser.Change_table_sourceContext changeTableSource = pt.change_table_source();
        if (changeTableSource != null && (change_table = changeTableSource.change_table()) != null) {
            FunctionCall fc = new FunctionCall(change_table);
            this.source = fc;
            TSqlParser.Change_table_changesContext changes = change_table.change_table_changes();
            TSqlParser.Change_table_versionContext versions = change_table.change_table_version();
            if (changes != null) {
                fc.setArgs(Arrays.asList(new ChangesArguments(changes)));
                this.sourceType = SourceType.CHANGE_TABLE;
            } else if (versions != null) {
                fc.setArgs(Arrays.asList(new VersionArguments(versions)));
                this.sourceType = SourceType.CHANGE_TABLE;
            }
            this.parseAlias(changeTableSource.as_table_alias());
            return;
        }
        TSqlParser.Function_call_sourceContext fcallSource = pt.function_call_source();
        if (fcallSource != null && (fCall = fcallSource.function_call()) != null) {
            this.source = (Expression)fCall.accept((ParseTreeVisitor)new ExpressionVisitor());
            this.sourceType = SourceType.FUNCTION;
            this.parseAliasWithoutHints(fcallSource.as_table_alias_without_hints());
            return;
        }
        TSqlParser.Table_variable_sourceContext localSource = pt.table_variable_source();
        if (localSource != null && (localId = localSource.loc_id) != null) {
            this.source = new TableVariable(localId);
            this.sourceType = SourceType.VARIABLE;
            this.parseAlias(localSource.as_table_alias());
            return;
        }
        TSqlParser.Variable_function_sourceContext variableCallSource = pt.variable_function_source();
        if (variableCallSource != null && (locIdCall = variableCallSource.loc_id_call) != null) {
            Token t = variableCallSource.loc_id_call;
            TSqlParser.Function_callContext locFcall = variableCallSource.loc_fcall;
            this.source = new FunctionCall(locFcall);
            this.sourceType = SourceType.VARIABLE_METHOD;
            this.parseAlias(variableCallSource.as_table_alias());
            this.parseColumnListAlias(variableCallSource.column_alias_list());
            return;
        }
        TSqlParser.Open_jsonContext oj = pt.open_json();
        if (oj != null) {
            this.sourceType = SourceType.OPEN_JSON;
            this.source = new FunctionCall(oj.start);
            ((FunctionCall)this.source).setArgs(BaseExpressionVisitor.expressionList(oj.expression()));
            this.parseAliasWithoutHints(oj.as_table_alias_without_hints());
            TSqlParser.Json_declarationContext js = oj.json_declaration();
            if (js != null) {
                for (TSqlParser.Json_column_declarationContext cx : js.json_col) {
                    List id;
                    TSqlParser.Column_declarationContext cd = cx.column_declaration();
                    if (cd == null || (id = cd.id()) == null || id.size() <= 0) continue;
                    this.columnAliases.add(new ColumnAlias((TSqlParser.IdContext)id.get(0)));
                }
            }
            return;
        }
        TSqlParser.Open_xmlContext openXml = pt.open_xml();
        if (openXml != null) {
            this.sourceType = SourceType.OPEN_XML;
            this.source = new GenericSource((ParseTree)openXml);
            this.parseAlias(openXml.as_table_alias());
            TSqlParser.Schema_declarationContext schema_declaration = openXml.schema_declaration();
            if (schema_declaration != null) {
                for (TSqlParser.Column_declarationContext col : schema_declaration.xml_col) {
                    List id;
                    if (col == null || (id = col.id()) == null || id.size() <= 0) continue;
                    this.columnAliases.add(new ColumnAlias((TSqlParser.IdContext)id.get(0)));
                }
            }
            return;
        }
        TSqlParser.Xml_nodes_sourceContext nodesSource = pt.xml_nodes_source();
        if (nodesSource != null && (nodes = nodesSource.nodes_method()) != null) {
            this.source = this.visitNodes_method(nodes);
            this.sourceType = SourceType.XML_NODES;
            this.parseAliasWithoutHints(nodesSource.as_table_alias_without_hints());
            this.parseColumnListAlias(nodesSource.column_alias_list());
        }
        if ((oldFunctionSource = pt.old_function_source()) != null && (oldstyle = oldFunctionSource.oldstyle_fcall) != null) {
            this.source = (Expression)oldstyle.accept((ParseTreeVisitor)new ExpressionVisitor());
            this.sourceType = SourceType.FUNCTION_OLD;
            this.parseAliasWithoutHints(oldFunctionSource.as_table_alias_without_hints());
            return;
        }
        TSqlParser.Openquery_sourceContext openQuery = pt.openquery_source();
        if (openQuery != null) {
            this.source = new OpenQuery(openQuery);
            this.sourceType = SourceType.OPENQUERY;
            this.parseAlias(openQuery.as_table_alias());
            return;
        }
    }

    public Expression visitNodes_method(TSqlParser.Nodes_methodContext ctx) {
        Expression exp = null;
        if (ctx.loc_id != null) {
            exp = new VariableExpression(ctx.loc_id);
        } else if (ctx.value_id != null) {
            exp = new SQLName(ctx.value_id);
        }
        return new XMLNodesExpression(ctx, exp, ctx.xquery);
    }

    public Source(TSqlParser.PivotContext pivot, TableSource parent) {
        super((ParseTree)pivot);
        this.source = new BaseExpression((ParseTree)pivot);
        this.sourceType = SourceType.PIVOT;
        this.columnAliases = ColumnAlias.parse(pivot.pivot_clause().column_alias_list());
        this.parseAlias(pivot.as_table_alias());
    }

    public Source(DerivedTable dt) {
        super(dt.getTree());
        this.source = dt;
        this.sourceType = SourceType.DERIVED;
    }

    public Source(Table table) {
        super(table.getTree());
        this.source = table;
        this.sourceType = SourceType.TABLE;
    }

    public Source(Table table, Alias alias) {
        super(table.getTree());
        this.source = table;
        this.sourceType = SourceType.TABLE;
        this.alias = alias;
    }

    public Source(TSqlParser.UnpivotContext unpivot, TableSource parent) {
        super((ParseTree)unpivot);
        TSqlParser.Unpivot_clauseContext unpivot_clause;
        this.source = new BaseExpression((ParseTree)unpivot);
        this.sourceType = SourceType.UNPIVOT;
        if (unpivot != null && (unpivot_clause = unpivot.unpivot_clause()) != null) {
            if (unpivot_clause.unpivot_value != null) {
                this.columnAliases.add(new ColumnAlias(unpivot_clause.unpivot_value));
            }
            if (unpivot_clause.unpivot_column != null) {
                this.columnAliases.add(new ColumnAlias(unpivot_clause.unpivot_column));
            }
        }
        this.parseAlias(unpivot.as_table_alias());
    }

    public Source(TableVariable tableVariable, Alias alias) {
        super(tableVariable.getTree());
        this.source = tableVariable;
        this.sourceType = SourceType.VARIABLE;
        this.alias = alias;
    }

    public Source() {
        super(null);
        this.sourceType = SourceType.EMPTY;
    }

    private void parseColumnListAlias(TSqlParser.Column_alias_listContext column_alias_list) {
        this.columnAliases = ColumnAlias.parse(column_alias_list);
    }

    private void tableNameWithHint(TSqlParser.Table_name_with_hintContext ctx) {
        TSqlParser.Table_nameContext name = ctx.table_name();
        if (name != null) {
            this.source = new Table(name);
        } else {
            TSqlParser.Unfinished_aliasContext al = ctx.unfinished_alias();
            if (al != null) {
                this.source = new Table(al);
            }
        }
        List hintsAndCols = ctx.getRuleContexts(TSqlParser.With_table_hintsContext.class);
        this.hints.addAll(Hint.parseHints(hintsAndCols.size() > 0 ? (TSqlParser.With_table_hintsContext)hintsAndCols.get(0) : null));
        if (hintsAndCols.size() > 1) {
            TSqlParser.With_table_hintsContext hintsAsAliases = (TSqlParser.With_table_hintsContext)hintsAndCols.get(1);
            for (TSqlParser.Table_hintContext h : hintsAsAliases.hint) {
                this.columnAliases.add(new ColumnAlias((ParserRuleContext)h));
            }
        }
    }

    private void parseAliasWithoutHints(TSqlParser.As_table_alias_without_hintsContext pt) {
        if (pt == null) {
            return;
        }
        TSqlParser.IdContext id = pt.id();
        if (id != null) {
            this.alias = new Alias(id);
        }
    }

    private void parseAlias(TSqlParser.As_table_aliasContext pt) {
        if (pt == null || pt.getChildCount() == 0 || pt.start.getType() == -1) {
            return;
        }
        this.alias = new Alias(pt);
        if (this.getAlias().getHints().size() > 0) {
            if (this.hints.size() == 0) {
                this.hints.addAll(this.getAlias().getHints());
            } else {
                for (Hint h : this.getAlias().getHints()) {
                    this.columnAliases.add(new ColumnAlias((ParserRuleContext)((TSqlParser.Table_hintContext)h.getTree())));
                }
            }
        }
    }

    @Override
    public String toString() {
        return "" + this.source + (this.getAlias() != null ? this.getAlias() : "") + (this.hints.size() > 0 ? this.hints : "") + (this.columnAliases.size() > 0 ? "(" + this.columnAliases + ")" : "");
    }

    public Expression getSource() {
        return this.source;
    }

    public Alias getAlias() {
        return this.alias;
    }

    public List<ColumnAlias> getColumnAliases() {
        return this.columnAliases;
    }

    public SourceType getSourceType() {
        return this.sourceType;
    }
}

