/*
 * Decompiled with CFR 0.152.
 */
package com.sigge.filerunner.sql.transform.expression;

import com.sigge.filerunner.sql.transform.expression.Expression;
import com.sigge.filerunner.sql.transform.expression.RootExpression;
import com.siggemannen.sql.antler.TSqlParser;
import java.util.Optional;
import org.antlr.v4.runtime.ParserRuleContext;
import org.antlr.v4.runtime.Token;
import org.antlr.v4.runtime.tree.ParseTree;
import org.antlr.v4.runtime.tree.TerminalNode;
import org.antlr.v4.runtime.tree.TerminalNodeImpl;

public class SQLName
extends Expression {
    private ParseTree tokenSource;
    private String serverName;
    private String databaseName;
    private String schemaName;
    private String name;

    public SQLName(String name) {
        this.name = name;
    }

    public SQLName(ParseTree source) {
        this.tokenSource = source;
        this.name = this.tokenSource.getText();
    }

    public SQLName(TSqlParser.Full_table_nameContext tableName) {
        this.tokenSource = tableName;
        this.serverName = tableName.server != null ? tableName.server.getText() : null;
        this.databaseName = tableName.database != null ? tableName.database.getText() : null;
        this.name = tableName.table != null ? tableName.table.getText() : null;
        this.schemaName = tableName.schema != null ? tableName.schema.getText() : null;
    }

    public SQLName(TSqlParser.Table_nameContext ctx) {
        this.tokenSource = ctx;
        this.databaseName = RootExpression.getValue(ctx.database);
        this.schemaName = RootExpression.getValue(ctx.schema);
        this.name = RootExpression.getValue(ctx.table);
    }

    public SQLName(TSqlParser.IdContext id) {
        this.tokenSource = id;
        this.name = id != null ? id.getText() : null;
    }

    public SQLName(String name, ParserRuleContext context) {
        this.tokenSource = context;
        this.name = name;
    }

    public SQLName(Token token) {
        this.tokenSource = new TerminalNodeImpl(token);
        this.name = token != null ? token.getText() : null;
    }

    public SQLName(TerminalNode name, ParserRuleContext context) {
        this.tokenSource = context != null ? context : name;
        this.name = name != null ? name.getText() : null;
    }

    public SQLName(TSqlParser.Func_proc_name_schemaContext ctx) {
        this.tokenSource = ctx;
        this.schemaName = RootExpression.getValue(ctx.schema);
        this.name = RootExpression.getValue(ctx.procedure);
    }

    public SQLName(TSqlParser.Simple_nameContext simple_name) {
        this.tokenSource = simple_name;
        this.name = RootExpression.getValue(simple_name.name);
        this.schemaName = RootExpression.getValue(simple_name.schema);
    }

    public SQLName(TSqlParser.Unfinished_aliasContext ctx) {
        this.tokenSource = ctx;
        this.schemaName = RootExpression.getValue(ctx.tablename);
        this.name = "";
    }

    public SQLName(TSqlParser.Func_proc_name_server_database_schemaContext ctx) {
        this.tokenSource = ctx;
        this.name = RootExpression.getValue(ctx.procedure);
        if (this.name == null) {
            TSqlParser.Func_proc_name_database_schemaContext funcSchema = ctx.func_proc_name_database_schema();
            if (funcSchema != null) {
                TSqlParser.Func_proc_name_schemaContext func_proc_name_schema;
                this.databaseName = RootExpression.getValue(funcSchema.database);
                this.schemaName = RootExpression.getValue(funcSchema.schema);
                this.name = RootExpression.getValue(funcSchema.procedure);
                if (this.name == null && (func_proc_name_schema = funcSchema.func_proc_name_schema()) != null) {
                    this.schemaName = RootExpression.getValue(func_proc_name_schema.schema);
                    this.name = RootExpression.getValue(func_proc_name_schema.procedure);
                }
            }
        } else {
            this.serverName = RootExpression.getValue(ctx.server);
            this.databaseName = RootExpression.getValue(ctx.database);
            this.schemaName = RootExpression.getValue(ctx.schema);
        }
    }

    @Override
    public Optional<Token> getStartToken() {
        if (this.tokenSource != null) {
            Object payload = this.tokenSource.getPayload();
            if (payload instanceof Token) {
                return Optional.of((Token)payload);
            }
            if (payload instanceof ParserRuleContext) {
                return Optional.ofNullable(((ParserRuleContext)payload).getStart());
            }
        }
        return super.getStartToken();
    }

    public ParseTree getTokenSource() {
        return this.tokenSource;
    }

    public final void setTokenSource(ParseTree tokenSource) {
        this.tokenSource = tokenSource;
    }

    public final String getServerName() {
        return this.serverName;
    }

    public final void setServerName(String serverName) {
        this.serverName = serverName;
    }

    public final String getDatabaseName() {
        return this.databaseName;
    }

    public final void setDatabaseName(String databaseName) {
        this.databaseName = databaseName;
    }

    public final String getSchemaName() {
        return this.schemaName;
    }

    public void setSchemaName(String schemaName) {
        this.schemaName = schemaName;
    }

    public final String getName() {
        return this.name;
    }

    public final void setName(String name) {
        this.name = name;
    }

    public String fullName() {
        StringBuilder sb = new StringBuilder();
        if (this.serverName != null) {
            sb.append(this.serverName).append(".");
        }
        if (this.databaseName != null) {
            sb.append(this.databaseName);
        }
        if (sb.length() > 0) {
            sb.append(".");
        }
        if (this.schemaName != null) {
            sb.append(this.schemaName);
        }
        if (sb.length() > 0) {
            sb.append(".");
        }
        if (this.name != null) {
            sb.append(this.name);
        }
        return sb.toString();
    }

    @Override
    public String toString() {
        return this.tokenSource != null ? this.tokenSource.getText() : this.serverName + "." + this.databaseName + "." + this.schemaName + "." + this.name;
    }
}

