/*
 * Decompiled with CFR 0.152.
 */
package com.sigge.filerunner.sql.sqlserver.run;

import com.sigge.filerunner.sql.run.IFrame;
import com.sigge.filerunner.sql.sqlserver.run.Frame;
import com.sigge.filerunner.sql.sqlserver.run.SQLServerClauseTransformer;
import com.sigge.filerunner.sql.transform.Clause;
import com.sigge.filerunner.sql.transform.SQLFile;
import com.sigge.filerunner.sql.transform.Scope;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Stack;

public class StackFrame {
    private final SQLFile file;
    private final Stack<ScopeClauses> scopes = new Stack();

    public StackFrame(SQLFile file) {
        this.file = file;
        this.scopes.push(this.createScope(file));
    }

    public boolean nextStatement() {
        ScopeClauses sc = null;
        while (true) {
            if (this.scopes.size() == 0) {
                return true;
            }
            sc = this.scopes.peek();
            sc.clausePosition++;
            if (sc.clausePosition < sc.clauses.size()) break;
            this.scopes.pop();
        }
        Clause c = (Clause)sc.clauses.get(sc.clausePosition);
        if (c instanceof Scope) {
            ScopeClauses scope = this.createScope((Scope)c);
            this.scopes.push(scope);
            scope.clausePosition++;
        }
        return false;
    }

    public ScopeClauses getCurrent() {
        return this.scopes.peek();
    }

    private ScopeClauses createScope(Scope scope) {
        ScopeClauses cl = new ScopeClauses();
        cl.scope = scope;
        cl.clauses = scope.getClauses();
        cl.clausePosition = -1;
        cl.frame = new Frame(scope, (Clause)scope, Collections.EMPTY_LIST);
        return cl;
    }

    class ScopeClauses {
        private Scope scope;
        private List<Clause> clauses;
        private int clausePosition;
        private Clause clause;
        private IFrame frame;
        private SQLServerClauseTransformer transformer;

        ScopeClauses() {
        }

        public Scope getScope() {
            return this.scope;
        }

        public List<Clause> getClauses() {
            return this.clauses;
        }

        public int getClausePosition() {
            return this.clausePosition;
        }

        public Optional<Clause> getClause() {
            if (this.clauses.size() == 0 || this.clausePosition >= this.clauses.size()) {
                return Optional.empty();
            }
            return Optional.of(this.clauses.get(this.clausePosition));
        }

        public IFrame getFrame() {
            return this.frame;
        }

        public void setFrame(IFrame frame) {
            this.frame = frame;
        }

        public SQLServerClauseTransformer getTransformer() {
            return this.transformer;
        }

        public void setTransformer(SQLServerClauseTransformer transformer) {
            this.transformer = transformer;
        }
    }
}

