/*
 * Decompiled with CFR 0.152.
 */
package com.sigge.filerunner.sql.sqlserver.run;

import com.google.common.collect.Streams;
import com.sigge.dbrunner.IProgressReporter;
import com.sigge.dbrunner.IScriptRunner;
import com.sigge.dbrunner.SQLOptions;
import com.sigge.filerunner.core.DoubleIndexedList;
import com.sigge.filerunner.core.ProgressReportedAdaptor;
import com.sigge.filerunner.sql.run.IClauseDebugTransformer;
import com.sigge.filerunner.sql.run.IDebugVariable;
import com.sigge.filerunner.sql.run.IDebuggingContext;
import com.sigge.filerunner.sql.run.IFrame;
import com.sigge.filerunner.sql.sqlserver.ClauseUtility;
import com.sigge.filerunner.sql.sqlserver.run.DebugVariable;
import com.sigge.filerunner.sql.sqlserver.run.Frame;
import com.sigge.filerunner.sql.transform.Clause;
import com.sigge.filerunner.sql.transform.declare.Declare;
import com.sigge.filerunner.sql.transform.declare.DeclareBlock;
import com.sigge.filerunner.sql.transform.declare.DeclareType;
import com.sigge.filerunner.view.results.ResultSetTableModel;
import java.io.StringReader;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.UUID;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.antlr.v4.runtime.tree.ParseTree;

public class SQLServerClauseTransformer
implements IClauseDebugTransformer {
    private final String tableName = "#t_" + UUID.randomUUID().toString().replace("-", "_");
    private final IScriptRunner runner;
    private boolean inited = false;
    private final IDebuggingContext debugContext;

    public SQLServerClauseTransformer(IScriptRunner runner, IDebuggingContext debugContext) {
        this.runner = runner;
        this.debugContext = debugContext;
    }

    private void init() throws Exception {
        if (this.inited) {
            return;
        }
        StringBuilder sb = new StringBuilder("CREATE TABLE ").append(this.tableName).append(" (ID INT NULL, NO_COUNT INT); INSERT INTO ").append(this.tableName).append("(ID, NO_COUNT) SELECT 1, CASE WHEN 512 & @@OPTIONS = 512 THEN 1 ELSE 0 END");
        this.runner.runScript(new StringReader(sb.toString()), new ArrayList<IProgressReporter>(), new SQLOptions());
        this.inited = true;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public IFrame evaluate(Clause clause, IFrame frame) throws Exception {
        List<? extends IDebugVariable> variables;
        int i;
        this.init();
        String text = ClauseUtility.getExpressionTree((ParseTree)clause.getContext()).toString();
        StringBuilder sb = new StringBuilder();
        StringBuilder output = new StringBuilder();
        final List<? extends IDebugVariable> extraVars = this.appendVariables(clause, frame);
        SQLOptions options = new SQLOptions();
        if (extraVars.size() > 0) {
            StringBuilder extras = new StringBuilder("ALTER TABLE ").append(this.tableName).append(" ADD ");
            for (i = 0; i < extraVars.size(); ++i) {
                if (i > 0) {
                    extras.append(",");
                }
                IDebugVariable iDebugVariable = extraVars.get(i);
                extras.append("[").append(iDebugVariable.getName()).append("]").append(" ").append(iDebugVariable.getType()).append(" NULL");
            }
            extras.append(";");
            this.runner.runScript(new StringReader(extras.toString()), new ArrayList<IProgressReporter>(), options);
        }
        if ((variables = frame.getVariables()).size() > 0) {
            for (IDebugVariable iDebugVariable : variables) {
                sb.append("DECLARE ").append(iDebugVariable.getName()).append(" ").append(iDebugVariable.getType()).append(";").append(System.lineSeparator());
            }
            sb.append("SELECT ");
            for (i = 0; i < variables.size(); ++i) {
                IDebugVariable iDebugVariable = variables.get(i);
                if (i > 0) {
                    sb.append(",");
                }
                sb.append(iDebugVariable.getName()).append(" = ").append("[").append(iDebugVariable.getName()).append("]");
            }
            sb.append(" FROM ").append(this.tableName).append(";").append(System.lineSeparator());
        }
        sb.append(text);
        if (variables.size() + extraVars.size() > 0) {
            sb.append(";").append("UPDATE ").append(this.tableName).append(" SET ");
            output.append("SELECT ");
            for (i = 0; i < variables.size() + extraVars.size(); ++i) {
                void var10_20;
                if (i >= variables.size()) {
                    IDebugVariable iDebugVariable = extraVars.get(i - variables.size());
                } else {
                    IDebugVariable iDebugVariable = variables.get(i);
                }
                if (i > 0) {
                    output.append(",");
                    sb.append(",");
                }
                output.append("[").append(var10_20.getName()).append("]");
                sb.append("[").append(var10_20.getName()).append("] = ").append(var10_20.getName());
            }
            output.append(" FROM ").append(this.tableName).append(";").append(System.lineSeparator());
        }
        final SQLOptions options2 = new SQLOptions();
        this.runner.runScript(new StringReader(sb.toString()), this.debugContext.getSQLReporters(), options2);
        if (output.length() > 0) {
            this.runner.runScript(new StringReader(output.toString()), Arrays.asList(new ProgressReportedAdaptor(){

                /*
                 * Loose catch block
                 */
                @Override
                public void reportScriptFinished(String command, Statement s, boolean result) {
                    int loopcount = 0;
                    block13: while (true) {
                        while (true) {
                            if (loopcount > 0) {
                                result = s.getMoreResults();
                            }
                            ++loopcount;
                            if (result) {
                                ResultSet rs = s.getResultSet();
                                try {
                                    ResultSetTableModel rstm = new ResultSetTableModel(rs, options2);
                                    Throwable throwable = null;
                                    try {
                                        rstm.process(rs, options2, c -> {});
                                        DoubleIndexedList<IDebugVariable> dl = new DoubleIndexedList<IDebugVariable>(Streams.concat((Stream[])new Stream[]{variables.stream(), extraVars.stream()}).collect(Collectors.toList()), f -> f.getName(), false);
                                        int i = 0;
                                        while (true) {
                                            if (i >= rstm.getColumnCount()) continue block13;
                                            String column = rstm.getColumnName(i);
                                            dl.get(column).setValue(rstm.getValueAt(0, i));
                                            ++i;
                                        }
                                    }
                                    catch (Throwable throwable2) {
                                        throwable = throwable2;
                                        throw throwable2;
                                    }
                                    finally {
                                        if (rstm == null) continue block13;
                                        if (throwable != null) {
                                            try {
                                                rstm.close();
                                            }
                                            catch (Throwable throwable3) {
                                                throwable.addSuppressed(throwable3);
                                            }
                                            continue block13;
                                        }
                                        rstm.close();
                                        continue block13;
                                    }
                                }
                                catch (Exception ex) {
                                    ex.printStackTrace();
                                    continue;
                                }
                            }
                            int updateCount = s.getUpdateCount();
                            if (updateCount != -1) {
                                s.clearWarnings();
                                continue;
                            }
                            break;
                        }
                        break;
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }

                @Override
                public void reportScriptFailure(String command, Statement s, Exception e, boolean result) {
                }
            }), options);
        }
        Frame frame2 = new Frame(frame.getScope(), clause, frame);
        frame2.vars.addAll(variables);
        frame2.vars.addAll(extraVars);
        return frame2;
    }

    private List<? extends IDebugVariable> appendVariables(Clause clause, IFrame frame) {
        ArrayList<DebugVariable> variables = new ArrayList<DebugVariable>();
        if (clause instanceof Declare) {
            Declare dec = (Declare)clause;
            for (DeclareBlock d : dec.block) {
                if (d.variableToken == null || d.type == null || d.declareType == DeclareType.TABLE) continue;
                DebugVariable db = new DebugVariable(d.getVariable(), d.type);
                variables.add(db);
            }
        }
        return variables;
    }
}

