/*
 * Decompiled with CFR 0.152.
 */
package com.sigge.filerunner.sql.sqlserver.queryplan;

import com.sigge.filerunner.sql.sqlserver.queryplan.Attribute;
import com.sigge.filerunner.sql.sqlserver.queryplan.Node;
import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.converters.Converter;
import com.thoughtworks.xstream.converters.MarshallingContext;
import com.thoughtworks.xstream.converters.UnmarshallingContext;
import com.thoughtworks.xstream.io.HierarchicalStreamDriver;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import com.thoughtworks.xstream.io.xml.JDom2Driver;
import java.util.ArrayList;

public class XmlParser {
    public Node parse(String xml, String mainRoot) {
        XStream xs = new XStream((HierarchicalStreamDriver)new JDom2Driver());
        xs.registerConverter((Converter)new NodeConverter());
        xs.allowTypesByWildcard(new String[]{"com.sigge.filerunner.**", "com.siggemannen.**"});
        xs.alias(mainRoot, Node.class);
        Node n = (Node)xs.fromXML(xml);
        return n;
    }

    public class NodeConverter
    implements Converter {
        public boolean canConvert(Class type) {
            return Node.class.isAssignableFrom(type);
        }

        public void marshal(Object source, HierarchicalStreamWriter writer, MarshallingContext context) {
            throw new UnsupportedOperationException("Marshalling not supported");
        }

        public Object unmarshal(HierarchicalStreamReader reader, UnmarshallingContext context) {
            Node node = new Node();
            this.xmlToNode(reader, node);
            return node;
        }

        private Node xmlToNode(HierarchicalStreamReader reader, Node map) {
            ArrayList<Node> list = new ArrayList<Node>();
            map.setName(reader.getNodeName());
            int i = 0;
            while (i < reader.getAttributeCount()) {
                map.addAttribute(new Attribute(reader.getAttributeName(i), reader.getAttribute(reader.getAttributeName(i))));
                ++i;
            }
            if (!reader.hasMoreChildren()) {
                reader.moveDown();
                Node n = new Node(reader.getNodeName());
                list.add(this.xmlToNode(reader, n));
                reader.moveUp();
            }
            while (reader.hasMoreChildren()) {
                reader.moveDown();
                Node n = new Node(reader.getNodeName());
                if (reader.hasMoreChildren()) {
                    list.add(this.xmlToNode(reader, n));
                } else {
                    n.setValue(reader.getValue());
                    int i2 = 0;
                    while (i2 < reader.getAttributeCount()) {
                        n.addAttribute(new Attribute(reader.getAttributeName(i2), reader.getAttribute(reader.getAttributeName(i2))));
                        ++i2;
                    }
                    list.add(n);
                }
                reader.moveUp();
            }
            map.addNodes(list);
            return map;
        }
    }
}

