/*
 * Decompiled with CFR 0.152.
 */
package com.sigge.filerunner.sql.sqlserver.queryplan;

import com.mxgraph.model.mxCell;
import com.mxgraph.model.mxGraphModel;
import com.sigge.filerunner.export.ExportResult;
import com.sigge.filerunner.export.raw.RawExportAction;
import com.sigge.filerunner.export.raw.RawSetting;
import com.sigge.filerunner.sql.sqlserver.queryplan.Node;
import com.sigge.filerunner.sql.sqlserver.queryplan.QueryPlanBuilder;
import com.sigge.filerunner.sql.sqlserver.queryplan.QueryPlanStatHandler;
import com.sigge.filerunner.sql.sqlserver.queryplan.QueryPlanStats;
import com.sigge.filerunner.sql.sqlserver.queryplan.XmlParser;
import com.sigge.filerunner.view.activity.DefaultActivity;
import com.sigge.filerunner.view.results.IResultSetTable;
import com.sigge.filerunner.view.results.QueryPlanPanel;
import com.sigge.filerunner.view.results.ResultTableHandler;
import com.sigge.filerunner.view.results.queryplan.IQueryPlan;
import com.siggemannen.core.Tuple;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.swing.filechooser.FileNameExtensionFilter;

public class SQLServerQueryPlan
implements IQueryPlan<String> {
    private String plan;
    private boolean addStatementText;
    private boolean lazyload;
    private List<QueryPlanPanel> queryPanels;
    private Map<String, Object> extra;
    private boolean constructed = false;
    private int counter;

    public SQLServerQueryPlan(String plan, boolean addStatementText, boolean lazyload, Map<String, Object> extra) {
        this.plan = plan;
        this.addStatementText = addStatementText;
        this.lazyload = lazyload;
        this.extra = extra;
        if (!lazyload) {
            this.queryPanels = new QueryPlanBuilder().buildGraph(plan, addStatementText, extra);
            this.constructed = true;
        }
    }

    @Override
    public void close() throws IOException {
        if (this.queryPanels != null) {
            for (QueryPlanPanel panel : this.queryPanels) {
                panel.getGraph().close();
            }
        }
        if (this.extra != null) {
            this.extra.clear();
        }
        this.queryPanels = Collections.EMPTY_LIST;
    }

    @Override
    public String getQueryPlanObject() {
        return this.plan;
    }

    @Override
    public List<QueryPlanPanel> getQueryPlanPanels() {
        if (this.constructed) {
            return this.queryPanels;
        }
        this.queryPanels = new QueryPlanBuilder().buildGraph(this.plan, this.addStatementText, this.extra);
        return this.queryPanels;
    }

    @Override
    public <X> void updateFrom(X ac) {
        if (this.queryPanels == null || this.queryPanels.size() == 0) {
            return;
        }
        if (ac instanceof DefaultActivity) {
            Map<String, Object> extraFields = ((DefaultActivity)ac).getExtraFields();
            this.extra = new HashMap<String, Object>(extraFields);
            String xmlStats = (String)extraFields.get("PROGRESS_XML");
            ArrayList<QueryPlanStats> qps = new ArrayList<QueryPlanStats>();
            if (xmlStats != null) {
                for (Node nx : new XmlParser().parse(xmlStats, "progress").getNodes()) {
                    qps.add(new QueryPlanStats(nx));
                }
            }
            QueryPlanStatHandler handler = new QueryPlanStatHandler(qps);
            mxGraphModel model = (mxGraphModel)this.queryPanels.get(0).getGraph().getModel();
            for (QueryPlanStats q : qps) {
                mxCell xcell;
                Object cell = model.getCell("NodeId" + q.getNodeId());
                if (!(cell instanceof mxCell) || !((xcell = (mxCell)cell).getValue() instanceof Tuple)) continue;
                Tuple nodeTuple = (Tuple)xcell.getValue();
                String statsFromId = handler.getStatsFromId(q.getNodeId());
                if (Objects.equals(statsFromId, ((QueryPlanBuilder.NodeItem)nodeTuple.second()).getExtra())) continue;
                ((QueryPlanBuilder.NodeItem)nodeTuple.second()).setExtra(statsFromId);
                this.queryPanels.get(0).getGraph().cellLabelChanged(xcell, xcell.getValue(), true);
            }
        }
    }

    @Override
    public Optional<ExportResult> export() {
        return ResultTableHandler.exportData(Collections.EMPTY_LIST, false, new RawExportAction("Export", null){

            @Override
            public RawSetting getPreferences(List<IResultSetTable> model, boolean selectionOnly) {
                String string = SQLServerQueryPlan.this.plan;
                StringBuilder stringBuilder = new StringBuilder("queryplan");
                SQLServerQueryPlan sQLServerQueryPlan = SQLServerQueryPlan.this;
                int n = sQLServerQueryPlan.counter;
                sQLServerQueryPlan.counter = n + 1;
                return new RawSetting(string, stringBuilder.append(n == 0 ? "" + SQLServerQueryPlan.this.counter : "").append(".sqlplan").toString(), new FileNameExtensionFilter("SQL plans (*.sqlplan)", "sqlplan"), new FileNameExtensionFilter("XML (*.xml)", "xml"));
            }
        });
    }

    @Override
    public String getStringRepresentation() {
        return this.plan;
    }

    @Override
    public List<QueryPlanPanel> createQueryPlanPanels(boolean addStatementText) {
        return new QueryPlanBuilder().buildGraph(this.plan, addStatementText, this.extra);
    }
}

