/*
 * Decompiled with CFR 0.152.
 */
package com.sigge.filerunner.sql.sqlserver.queryplan;

import com.sigge.filerunner.core.StringUtils;
import com.sigge.filerunner.sql.sqlserver.queryplan.Attribute;
import com.sigge.filerunner.sql.sqlserver.queryplan.Node;
import com.sigge.filerunner.sql.sqlserver.queryplan.NodePropertyView;
import com.sigge.filerunner.view.JMemoryDialog;
import com.sigge.filerunner.view.core.OKCancelPanel;
import com.sigge.filerunner.view.core.VTreeTable;
import com.siggemannen.core.Tuple;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.util.Arrays;
import java.util.List;
import javax.swing.JLabel;
import javax.swing.JTree;
import javax.swing.tree.DefaultTreeCellRenderer;
import org.jdesktop.swingx.treetable.AbstractMutableTreeTableNode;
import org.jdesktop.swingx.treetable.DefaultMutableTreeTableNode;
import org.jdesktop.swingx.treetable.DefaultTreeTableModel;
import org.jdesktop.swingx.treetable.MutableTreeTableNode;
import org.jdesktop.swingx.treetable.TreeTableModel;
import org.jdesktop.swingx.treetable.TreeTableNode;

public class NodeViewer {
    private static final List<String> COLUMNS = Arrays.asList("Node", "Value");

    public void display(Object cellNode) {
        Node n = null;
        if (cellNode instanceof Node) {
            n = (Node)cellNode;
        }
        if (cellNode instanceof Tuple) {
            Tuple nodeTuple = (Tuple)cellNode;
            n = (Node)nodeTuple.first();
        }
        if (n == null) {
            return;
        }
        JMemoryDialog mj = new JMemoryDialog(null, String.valueOf(n.getName()) + " - " + StringUtils.isBlank(this.getNodeValue(n), "") + " properties", false, "nodeviewer");
        if (!mj.isSizeSetFromSettings()) {
            mj.setSize(640, 480);
            mj.setPreferredSize(new Dimension(640, 480));
        }
        NodePropertyView nv = new NodePropertyView();
        OKCancelPanel buttons = mj.setContent(nv, true);
        buttons.getCancelButton().setVisible(false);
        mj.centerOnCorrectScreen(null);
        VTreeTable vt = nv.nodeTable;
        vt.setRootVisible(false);
        vt.setGridColor(new Color(223, 220, 214));
        vt.setShowGrid(true, true);
        NodeNode root = new NodeNode(n, true);
        DefaultTreeTableModel model = new DefaultTreeTableModel((TreeTableNode)root, COLUMNS);
        this.addRecords(root, n, null, true);
        vt.setTreeTableModel((TreeTableModel)model);
        DefaultTreeCellRenderer cellRenderer = new DefaultTreeCellRenderer(){

            @Override
            public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
                JLabel cx = (JLabel)super.getTreeCellRendererComponent(tree, value, sel, expanded, leaf, row, hasFocus);
                if (value instanceof NodeNode) {
                    if (((NodeNode)((Object)value)).isThisRoot()) {
                        cx.setFont(this.getFont().deriveFont(1));
                    }
                } else {
                    cx.setFont(cx.getFont().deriveFont(0));
                }
                return cx;
            }
        };
        vt.setTreeCellRenderer(cellRenderer);
        cellRenderer.setLeafIcon(null);
        cellRenderer.setClosedIcon(null);
        cellRenderer.setOpenIcon(null);
        mj.setVisible(true);
    }

    private void addRecords(NodeNode root, Node n, DefaultMutableTreeTableNode theRealRoot, boolean isRoot) {
        for (Attribute a : n.getAttributes()) {
            root.add((MutableTreeTableNode)new AttributeNode(a));
        }
        for (Node sub : isRoot ? n.getTransientNodes() : n.getNodes()) {
            NodeNode child = new NodeNode(sub);
            root.add((MutableTreeTableNode)child);
            this.addRecords(child, sub, theRealRoot, false);
        }
    }

    String getNodeValue(Node value) {
        return value.getValue() != null ? value.getValue() : value.getAttributeValue("LogicalOp");
    }

    private class AttributeNode
    extends AbstractMutableTreeTableNode {
        private Attribute attribute;

        public AttributeNode(Attribute attribute) {
            this.attribute = attribute;
        }

        public Object getValueAt(int column) {
            switch (column) {
                case 0: {
                    return this.attribute.getName();
                }
                case 1: {
                    return this.attribute.getValue();
                }
            }
            return null;
        }

        public int getColumnCount() {
            return COLUMNS.size();
        }

        public String toString() {
            return this.attribute.getName();
        }
    }

    private class NodeNode
    extends AbstractMutableTreeTableNode {
        private Node value;
        private boolean root;

        public NodeNode(Node value) {
            this(value, false);
        }

        public NodeNode(Node value, boolean root) {
            this.value = value;
            this.root = root;
        }

        public boolean isThisRoot() {
            return this.root;
        }

        public Object getValueAt(int column) {
            switch (column) {
                case 0: {
                    return this;
                }
                case 1: {
                    return NodeViewer.this.getNodeValue(this.value);
                }
            }
            return null;
        }

        public String toString() {
            return this.value.getName();
        }

        public int getColumnCount() {
            return COLUMNS.size();
        }
    }
}

