/*
 * Decompiled with CFR 0.152.
 */
package com.sigge.filerunner.sql.sqlserver.jobs.steps;

import com.sigge.filerunner.view.core.ILabel;
import java.util.Objects;

public class StepAction
implements ILabel {
    private ActionType type;
    private int stepTo;
    public static final StepAction GO_TO_NEXT_STEP = new StepAction(ActionType.GO_TO_NEXT_STEP);
    public static final StepAction QUIT_WITH_FAILURE = new StepAction(ActionType.QUIT_WITH_FAILURE);
    public static final StepAction QUIT_WITH_SUCCESS = new StepAction(ActionType.QUIT_WITH_SUCCESS);

    public StepAction() {
        this(ActionType.GO_TO_NEXT_STEP);
    }

    public StepAction(ActionType type) {
        this.type = type;
    }

    public StepAction(int stepTo) {
        this.type = ActionType.GO_TO_STEP_X;
        this.stepTo = stepTo;
    }

    public StepAction(int stepType, int stepTo) {
        this.type = ActionType.getActionByType(stepType);
        this.stepTo = stepTo;
    }

    public ActionType getType() {
        return this.type;
    }

    public void setType(ActionType type) {
        this.type = type;
    }

    public int getStepTo() {
        return this.stepTo;
    }

    public void setStepTo(int stepTo) {
        this.stepTo = stepTo;
    }

    @Override
    public String getLabel() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.type.message);
        if (this.type == ActionType.GO_TO_STEP_X) {
            sb.append(this.stepTo);
        }
        return sb.toString();
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.stepTo, this.type});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        StepAction other = (StepAction)obj;
        return this.stepTo == other.stepTo && this.type == other.type;
    }

    public static enum ActionType {
        QUIT_WITH_SUCCESS(1, "Quit with success"),
        QUIT_WITH_FAILURE(2, "Quit with failure"),
        GO_TO_NEXT_STEP(3, "Go to next step"),
        GO_TO_STEP_X(4, "Go to step: ");

        private final int type;
        private final String message;

        private ActionType(int type, String message) {
            this.type = type;
            this.message = message;
        }

        public int getType() {
            return this.type;
        }

        public String getMessage() {
            return this.message;
        }

        public static ActionType getActionByType(int type) {
            switch (type) {
                case 1: {
                    return QUIT_WITH_SUCCESS;
                }
                case 2: {
                    return QUIT_WITH_FAILURE;
                }
                case 3: {
                    return GO_TO_NEXT_STEP;
                }
                case 4: {
                    return GO_TO_STEP_X;
                }
            }
            return null;
        }
    }
}

