/*
 * Decompiled with CFR 0.152.
 */
package com.sigge.filerunner.sql.sqlserver.jobs.steps;

import com.sigge.filerunner.config.ConfigHandler;
import com.sigge.filerunner.core.IFeedback;
import com.sigge.filerunner.core.StringUtils;
import com.sigge.filerunner.core.executors.RecurringExecutionContext;
import com.sigge.filerunner.sql.sqlserver.jobs.SQLServerAgentJobServer;
import com.sigge.filerunner.sql.sqlserver.jobs.SQLServerJob;
import com.sigge.filerunner.sql.sqlserver.jobs.steps.DatabaseUserLookupEditor;
import com.sigge.filerunner.sql.sqlserver.jobs.steps.JobStepAdvancedPanel;
import com.sigge.filerunner.sql.sqlserver.jobs.steps.JobStepEditView;
import com.sigge.filerunner.sql.sqlserver.jobs.steps.JobStepSQLPanel;
import com.sigge.filerunner.sql.sqlserver.jobs.steps.SQLServerAgentProxy;
import com.sigge.filerunner.sql.sqlserver.jobs.steps.SQLServerJobStep;
import com.sigge.filerunner.sql.sqlserver.jobs.steps.StepAction;
import com.sigge.filerunner.sql.sqlserver.jobs.steps.Subsystem;
import com.sigge.filerunner.view.JMemoryDialog;
import com.sigge.filerunner.view.core.LabelledCellRenderer;
import com.sigge.filerunner.view.core.TextListItem;
import com.sigge.filerunner.view.editors.ALookupEditor;
import com.sigge.filerunner.view.rsyntaxtextarea.TextPaneUtil;
import com.siggemannen.binding.AModel;
import com.siggemannen.binding.APresenter;
import com.siggemannen.binding.IProperty;
import com.siggemannen.core.Tuple;
import com.siggemannen.functional.throwing.ThrowingConsumer;
import java.awt.Component;
import java.awt.Container;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.JComboBox;
import javax.swing.text.JTextComponent;

public class JobStepEdit {
    private static final String VIEW_SQLSERVER_JOBS_STEPS_VIEW_ADVANCED = "view.sqlserver.jobs.steps.view.advanced";

    public void jobStepEdit(SQLServerJob job, SQLServerJobStep step, IFeedback feedback) {
        this.jobEditInternal(job, step, (SQLServerAgentJobServer)job.getJobServer(), feedback);
    }

    public void jobStepAdd(SQLServerJob job, IFeedback feedback) {
        SQLServerJobStep step = new SQLServerJobStep();
        step.setSubsystem(Subsystem.TSQL_SUBSYSTEM);
        this.jobEditInternal(job, step, (SQLServerAgentJobServer)job.getJobServer(), feedback);
    }

    private void jobEditInternal(final SQLServerJob job, final SQLServerJobStep step, final SQLServerAgentJobServer server, IFeedback feedback) {
        final List<Subsystem> subs = server.getSubSystems();
        JMemoryDialog jd = new JMemoryDialog(null, "Add/edit job step", true, "sql-server-step-add");
        JobStepEditView view = new JobStepEditView();
        jd.getContentPane().add(view);
        jd.pack();
        jd.centerOnCorrectScreen(null);
        final JobStepAdvancedPanel panel = new JobStepAdvancedPanel();
        APresenter<SQLServerJobStep, SQLServerJobStepModel, JobStepEditView> presenter = new APresenter<SQLServerJobStep, SQLServerJobStepModel, JobStepEditView>(new SQLServerJobStepModel(), view){

            protected void initBindings() {
                this.bind(((JobStepEditView)this.view).stepNameText).to(((SQLServerJobStepModel)this.model).stepName);
                this.bind(((JobStepEditView)this.view).stepCommandType).to(subs, ((SQLServerJobStepModel)this.model).subsystem);
                this.bind(panel.retryCountSpinner).to(((SQLServerJobStepModel)this.model).retryAttempts, null, Integer.valueOf(0), Integer.valueOf(1));
                this.bind(panel.retryInterval).to(((SQLServerJobStepModel)this.model).retryInterval, null, Integer.valueOf(0), Integer.valueOf(1));
                this.bind(panel.filePath).to(((SQLServerJobStepModel)this.model).outputFileName);
                this.bind(panel.failureCombo).to(job.getActionsForStep(step), ((SQLServerJobStepModel)this.model).onFailure);
                this.bind(panel.successCombo).to(job.getActionsForStep(step), ((SQLServerJobStepModel)this.model).onSuccess);
                this.bind(panel.logToFile).to(new ArrayList<TextListItem<Integer>>(SQLServerJobStep.FILE_LOG_LIST), ((SQLServerJobStepModel)this.model).fileLog);
                this.bind(panel.logToTable).to(new ArrayList<TextListItem<Integer>>(SQLServerJobStep.TABLE_LOG_LIST), ((SQLServerJobStepModel)this.model).historyLog);
                this.bind(panel.stepLogTable).to(new ArrayList<TextListItem<Integer>>(SQLServerJobStep.STEP_LOG_LIST), ((SQLServerJobStepModel)this.model).stepHistoryLog);
                this.bind(((JobStepEditView)this.view).runAsProxy).to(JobStepEdit.this.getSupportedProxiesForJob(server, step != null ? step.getSubsystem() : Subsystem.TSQL_SUBSYSTEM), ((SQLServerJobStepModel)this.model).proxy);
            }
        };
        JobStepSQLPanel commandPanel = this.bindCommand(server, presenter);
        panel.logToFile.addActionListener(al -> this.enableFilePanel(step, panel));
        presenter.setObject((Object)step);
        view.stepCommandType.adjustDropDownMenuWidth(f -> ((Subsystem)f).getLabel());
        view.stepCommandType.setRenderer(new LabelledCellRenderer(true));
        LabelledCellRenderer defaultRenderer = new LabelledCellRenderer();
        panel.failureCombo.setRenderer(defaultRenderer);
        panel.successCombo.setRenderer(defaultRenderer);
        panel.logToFile.setRenderer(defaultRenderer);
        panel.logToTable.setRenderer(defaultRenderer);
        panel.stepLogTable.setRenderer(defaultRenderer);
        view.runAsProxy.setRenderer(defaultRenderer);
        this.enableFilePanel(step, panel);
        view.advancedSettingButton.addActionListener(al -> this.handleAdvanceButton(view, panel));
        view.advancedSettingButton.setSelected(ConfigHandler.getConfig().getBooleanConfigValue(VIEW_SQLSERVER_JOBS_STEPS_VIEW_ADVANCED, false));
        this.handleAdvanceButton(view, panel);
        view.stepCommandType.addActionListener(arg_0 -> this.lambda$3(server, step, (APresenter)presenter, commandPanel, panel, arg_0));
        this.setCommandType(server, step, presenter, commandPanel, panel);
        commandPanel.browseUsersButton.addActionListener(arg_0 -> this.lambda$4(server, step, (APresenter)presenter, arg_0));
        view.saveStepButton.addActionListener(al -> {
            Tuple<String, Boolean> validation = this.validateStep(step);
            if (!((Boolean)validation.second()).booleanValue()) {
                feedback.showMessage(view, "Step isn't valid: " + (String)validation.first());
                return;
            }
            job.addStep(step);
            jd.setVisible(false);
            jd.dispose();
        });
        view.cancelButton.addActionListener(al -> {
            jd.setVisible(false);
            jd.dispose();
        });
        jd.setVisible(true);
    }

    private void enableFilePanel(SQLServerJobStep step, JobStepAdvancedPanel panel) {
        panel.filePath.setEnabled(step.getFileLog().getValue() != null && !step.getFileLog().getValue().equals(0));
    }

    private Tuple<String, Boolean> validateStep(SQLServerJobStep step) {
        ArrayList<String> errors = new ArrayList<String>();
        if (StringUtils.isEmpty(step.getStepName())) {
            errors.add("Step name must be entered");
        }
        if (errors.size() > 0) {
            return Tuple.of((Object)String.join((CharSequence)",", errors), (Object)false);
        }
        return Tuple.of((Object)"", (Object)true);
    }

    private void handleAdvanceButton(JobStepEditView view, JobStepAdvancedPanel panel) {
        if (view.advancedSettingButton.isSelected()) {
            view.advancedPanel.removeAll();
            view.advancedPanel.setVisible(true);
            view.advancedPanel.add((Component)panel, "Center");
            view.advancedPanel.revalidate();
            view.advancedPanel.getParent().revalidate();
        } else {
            view.advancedPanel.removeAll();
            view.advancedPanel.revalidate();
            view.advancedPanel.setVisible(false);
            view.advancedPanel.getParent().revalidate();
        }
        ConfigHandler.getConfig().setConfigValue(VIEW_SQLSERVER_JOBS_STEPS_VIEW_ADVANCED, view.advancedSettingButton.isSelected());
        this.packView(view);
    }

    private void packView(JobStepEditView view) {
        Container c = view.getTopLevelAncestor();
        if (c instanceof Window) {
            ((Window)c).pack();
        }
    }

    private JobStepSQLPanel bindCommand(SQLServerAgentJobServer server, APresenter<SQLServerJobStep, SQLServerJobStepModel, JobStepEditView> presenter) {
        JobStepEditView view = (JobStepEditView)presenter.getView();
        view.stepContentPanel.removeAll();
        List<Object> dbs = new ArrayList();
        try {
            dbs = server.getServerDatabase().getDatabases();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        dbs.sort(Comparator.comparing(String::toLowerCase));
        JobStepSQLPanel stepSQLPanel = new JobStepSQLPanel();
        view.stepContentPanel.add((Component)stepSQLPanel, "Center");
        presenter.bind((JTextComponent)((Object)stepSQLPanel.sqlTextArea)).to(((SQLServerJobStepModel)presenter.getModel()).command);
        presenter.bind((JComboBox)stepSQLPanel.jobStepSQLDatabase).to(dbs, ((SQLServerJobStepModel)presenter.getModel()).database);
        presenter.bind((JTextComponent)stepSQLPanel.processExitCodeText).toNumber(((SQLServerJobStepModel)presenter.getModel()).cmdexec_success_code);
        presenter.bind(stepSQLPanel.userCombo).asEditable().to(Arrays.asList(new Object[0]), ((SQLServerJobStepModel)presenter.getModel()).userName);
        view.stepContentPanel.revalidate();
        return stepSQLPanel;
    }

    private void setCommandType(SQLServerAgentJobServer server, SQLServerJobStep step, APresenter<SQLServerJobStep, SQLServerJobStepModel, JobStepEditView> presenter, JobStepSQLPanel commandPanel, JobStepAdvancedPanel panel) {
        JobStepEditView view = (JobStepEditView)presenter.getView();
        List<SQLServerAgentProxy> applicable = this.getSupportedProxiesForJob(server, step);
        presenter.bind(view.runAsProxy).to(applicable, ((SQLServerJobStepModel)presenter.getModel()).proxy, true);
        String syntaxStyle = "text/plain";
        boolean serverAvailable = false;
        boolean cmd_return = false;
        boolean database_visible = false;
        boolean proxy_visible = true;
        boolean runAsUserName = false;
        List<TextListItem<Integer>> logList = SQLServerJobStep.TABLE_LOG_LIST_NON_TSQL;
        switch (step.getSubsystem().getName()) {
            case "TSQL": {
                syntaxStyle = "text/tsql";
                database_visible = true;
                proxy_visible = false;
                runAsUserName = true;
                logList = SQLServerJobStep.TABLE_LOG_LIST;
                break;
            }
            case "ANALYSISQUERY": {
                serverAvailable = true;
                syntaxStyle = "text/tsql";
                database_visible = true;
                break;
            }
            case "QueueReader": {
                database_visible = true;
                serverAvailable = true;
                break;
            }
            case "ANALYSISCOMMAND": {
                serverAvailable = true;
                syntaxStyle = "text/xml";
                break;
            }
            case "CmdExec": {
                syntaxStyle = "text/bat";
                cmd_return = true;
                break;
            }
        }
        presenter.bind(panel.logToTable).to(logList, ((SQLServerJobStepModel)presenter.getModel()).historyLog, true);
        if (!logList.contains(((SQLServerJobStepModel)presenter.getModel()).historyLog.getValue())) {
            ((SQLServerJobStepModel)presenter.getModel()).historyLog.setValue(logList.get(0));
        }
        commandPanel.serverLabel.setVisible(serverAvailable);
        commandPanel.serverField.setVisible(serverAvailable);
        commandPanel.processExitCodeText.setVisible(cmd_return);
        commandPanel.processExitLabel.setVisible(cmd_return);
        commandPanel.sqlTextArea.setSyntaxEditingStyle(syntaxStyle);
        commandPanel.jobStepSQLDatabase.setVisible(database_visible);
        commandPanel.databaseLabel.setVisible(database_visible);
        view.runAsProxy.setVisible(proxy_visible);
        commandPanel.runAsLabel.setVisible(runAsUserName);
        commandPanel.userCombo.setVisible(runAsUserName);
        commandPanel.browseUsersButton.setVisible(runAsUserName);
        view.runAsProxyLabel.setVisible(proxy_visible);
        TextPaneUtil.configureSyntaxTextArea(commandPanel.sqlTextArea);
        this.packView(view);
    }

    private List<SQLServerAgentProxy> getSupportedProxiesForJob(SQLServerAgentJobServer server, Subsystem step) {
        List<SQLServerAgentProxy> proxies = server.getProxies();
        Map<Integer, Set<Integer>> proxysubs = server.getProxySubsystems();
        Set<Integer> proxset = proxysubs.get(step.getSubsystem_id());
        if (proxset == null) {
            proxset = new HashSet<Integer>();
        }
        ArrayList<SQLServerAgentProxy> applicable = new ArrayList<SQLServerAgentProxy>();
        for (SQLServerAgentProxy prox : proxies) {
            if (prox.getProxy_id() != null && !proxset.contains(prox.getProxy_id())) continue;
            applicable.add(prox);
        }
        return applicable;
    }

    private List<SQLServerAgentProxy> getSupportedProxiesForJob(SQLServerAgentJobServer server, SQLServerJobStep step) {
        return this.getSupportedProxiesForJob(server, step.getSubsystem());
    }

    private /* synthetic */ void lambda$3(SQLServerAgentJobServer sQLServerAgentJobServer, SQLServerJobStep sQLServerJobStep, APresenter aPresenter, JobStepSQLPanel jobStepSQLPanel, JobStepAdvancedPanel jobStepAdvancedPanel, ActionEvent e) {
        this.setCommandType(sQLServerAgentJobServer, sQLServerJobStep, (APresenter<SQLServerJobStep, SQLServerJobStepModel, JobStepEditView>)aPresenter, jobStepSQLPanel, jobStepAdvancedPanel);
    }

    private /* synthetic */ void lambda$4(final SQLServerAgentJobServer sQLServerAgentJobServer, SQLServerJobStep sQLServerJobStep, APresenter aPresenter, ActionEvent al) {
        final HashMap cache = new HashMap();
        final String database = sQLServerJobStep.getDatabase();
        if (database != null) {
            final RecurringExecutionContext context = new RecurringExecutionContext();
            new DatabaseUserLookupEditor((ThrowingConsumer<String>)((ThrowingConsumer)user -> {
                if (user != null) {
                    ((SQLServerJobStepModel)aPresenter.getModel()).userName.setValue(user);
                }
            }), null, "Browse database users", new ALookupEditor.CallbackLookup<List<String>>(){

                public Boolean apply0(ThrowingConsumer<List<String>> arg0) throws Throwable {
                    if (cache.containsKey(database)) {
                        arg0.accept((Object)((List)cache.get(database)));
                        return true;
                    }
                    context.execute(() -> cache.computeIfAbsent(database, d -> sQLServerAgentJobServer.getUsers(database)), arg0);
                    return false;
                }
            }).present("");
        }
    }

    static class SQLServerJobStepModel
    extends AModel<SQLServerJobStep> {
        IProperty<String> jobId = this.getProperty("jobId");
        IProperty<String> stepId = this.getProperty("stepId");
        IProperty<Integer> stepNumber = this.getProperty("stepNumber");
        IProperty<String> stepName = this.getProperty("stepName");
        IProperty<Subsystem> subsystem = this.getProperty("subsystem");
        IProperty<String> command = this.getProperty("command");
        IProperty<StepAction> onSuccess = this.getProperty("onSuccess");
        IProperty<StepAction> onFailure = this.getProperty("onFailure");
        IProperty<String> database = this.getProperty("database");
        IProperty<String> userName = this.getProperty("userName");
        IProperty<Integer> retryAttempts = this.getProperty("retryAttempts");
        IProperty<Integer> retryInterval = this.getProperty("retryInterval");
        IProperty<String> outputFileName = this.getProperty("outputFileName");
        IProperty<Boolean> includeInStepHistory = this.getProperty("includeInStepHistory");
        IProperty<Boolean> overwriteToTable = this.getProperty("overwriteToTable");
        IProperty<Integer> cmdexec_success_code = this.getProperty("cmdexec_success_code");
        IProperty<TextListItem<Integer>> fileLog = this.getProperty("fileLog");
        IProperty<TextListItem<Integer>> historyLog = this.getProperty("historyLog");
        IProperty<TextListItem<Integer>> stepHistoryLog = this.getProperty("stepHistoryLog");
        IProperty<SQLServerAgentProxy> proxy = this.getProperty("proxy");

        SQLServerJobStepModel() {
        }
    }
}

