/*
 * Decompiled with CFR 0.152.
 */
package com.sigge.filerunner.sql.sqlserver.jobs.schedule.view;

import com.sigge.filerunner.sql.sqlserver.jobs.schedule.DailyRecurringTimeSchedule;
import com.sigge.filerunner.sql.sqlserver.jobs.schedule.IScheduleBinder;
import com.sigge.filerunner.sql.sqlserver.jobs.schedule.RecurringSchedule;
import com.sigge.filerunner.sql.sqlserver.jobs.schedule.SQLServerSchedule;
import com.sigge.filerunner.sql.sqlserver.jobs.schedule.TimePeriod;
import com.siggemannen.binding.Binder;
import com.siggemannen.binding.ValueHolder;
import java.time.LocalTime;
import java.util.Arrays;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;

public class DailyRecurringPanel
extends JPanel
implements IScheduleBinder {
    private SQLServerSchedule schedule;
    private Binder.Presenter<Integer> dailyRecPres;
    private Binder.Presenter<TimePeriod> dailyXpresenter;
    private Binder.Presenter<LocalTime> startingPres;
    private Binder.Presenter<LocalTime> finishingPres;

    public DailyRecurringPanel() {
        JLabel occurs = new JLabel("Occurs every: ");
        this.add(occurs);
        JSpinner dailyEveryX = new JSpinner();
        this.dailyRecPres = Binder.genericBind((Object)dailyEveryX, (ap, prop) -> ap.bind(dailyEveryX).to(prop, null, Integer.valueOf(1), Integer.valueOf(1)), (Object)1).addValueChangedListener(v -> {
            if (this.schedule != null) {
                this.schedule.getRecurringSchedule().getDailyRecurringTimeSchedule().setEveryNth((int)v);
            }
        }, true);
        JComboBox dailyEveryXFreq = new JComboBox();
        this.dailyXpresenter = Binder.bindToCombo(dailyEveryXFreq, Arrays.asList(TimePeriod.HOUR, TimePeriod.MINUTE, TimePeriod.SECOND)).addValueChangedListener(v -> {
            if (this.schedule != null) {
                this.schedule.getRecurringSchedule().getDailyRecurringTimeSchedule().setEveryNthType((TimePeriod)((Object)v));
            }
        }, true);
        this.add(dailyEveryX);
        this.add(dailyEveryXFreq);
        JSpinner startingAt = new JSpinner();
        JSpinner finishingAt = new JSpinner();
        this.startingPres = Binder.genericBind((Object)startingAt, (p, prop) -> p.bind(startingAt).to(prop), (Object)LocalTime.now()).addValueChangedListener(v -> {
            if (this.schedule != null) {
                this.schedule.getRecurringSchedule().getDailyRecurringTimeSchedule().setStart((LocalTime)v);
            }
        }, true);
        this.finishingPres = Binder.genericBind((Object)finishingAt, (p, prop) -> p.bind(finishingAt).to(prop), (Object)LocalTime.now()).addValueChangedListener(v -> {
            if (this.schedule != null) {
                this.schedule.getRecurringSchedule().getDailyRecurringTimeSchedule().setEnd((LocalTime)v);
            }
        }, true);
        JLabel between = new JLabel("run between: ");
        this.add(between);
        this.add(startingAt);
        this.add(new JLabel("and"));
        this.add(finishingAt);
    }

    @Override
    public void bind(SQLServerSchedule initial) {
        this.schedule = initial;
        if (this.schedule == null) {
            return;
        }
        RecurringSchedule recurringSchedule = initial.getRecurringSchedule();
        DailyRecurringTimeSchedule dailyRecurringTimeSchedule = recurringSchedule.getDailyRecurringTimeSchedule();
        if (dailyRecurringTimeSchedule == null) {
            dailyRecurringTimeSchedule = new DailyRecurringTimeSchedule();
            recurringSchedule.setDailyRecurringTimeSchedule(dailyRecurringTimeSchedule);
        }
        this.dailyRecPres.setObject((Object)new ValueHolder((Object)dailyRecurringTimeSchedule.getEveryNth()));
        this.dailyXpresenter.setObject((Object)new ValueHolder((Object)dailyRecurringTimeSchedule.getEveryNthType()));
        this.startingPres.setObject((Object)new ValueHolder((Object)dailyRecurringTimeSchedule.getStart()));
        this.finishingPres.setObject((Object)new ValueHolder((Object)dailyRecurringTimeSchedule.getEnd()));
    }
}

