/*
 * Decompiled with CFR 0.152.
 */
package com.sigge.filerunner.sql.sqlserver.jobs.commands;

import com.sigge.dbrunner.Database;
import com.sigge.filerunner.sql.ServerDatabase;
import com.sigge.filerunner.sql.sqlserver.jobs.CommandResult;
import com.sigge.filerunner.sql.sqlserver.jobs.ICommandResult;
import com.sigge.filerunner.sql.sqlserver.jobs.SQLServerJob;
import com.sigge.filerunner.sql.sqlserver.jobs.SQLServerRunner;
import com.sigge.filerunner.sql.sqlserver.jobs.commands.AJobCommand;
import com.sigge.filerunner.sql.sqlserver.jobs.schedule.DailyOneTimeSchedule;
import com.sigge.filerunner.sql.sqlserver.jobs.schedule.DailyRecurringTimeSchedule;
import com.sigge.filerunner.sql.sqlserver.jobs.schedule.DailySchedule;
import com.sigge.filerunner.sql.sqlserver.jobs.schedule.FrequencyType;
import com.sigge.filerunner.sql.sqlserver.jobs.schedule.MonthlySchedule;
import com.sigge.filerunner.sql.sqlserver.jobs.schedule.OneTimeSchedule;
import com.sigge.filerunner.sql.sqlserver.jobs.schedule.RecurringSchedule;
import com.sigge.filerunner.sql.sqlserver.jobs.schedule.RelativeFrequency;
import com.sigge.filerunner.sql.sqlserver.jobs.schedule.SQLServerSchedule;
import com.sigge.filerunner.sql.sqlserver.jobs.schedule.ScheduleType;
import com.sigge.filerunner.sql.sqlserver.jobs.schedule.TimePeriod;
import com.sigge.filerunner.sql.sqlserver.jobs.schedule.WeeklySchedule;
import com.sigge.filerunner.sql.sqlserver.jobs.steps.SQLServerJobStep;
import com.sigge.filerunner.sql.sqlserver.jobs.steps.StepAction;
import com.sigge.filerunner.sql.sqlserver.jobs.steps.Subsystem;
import com.sigge.filerunner.view.jobs.IJobObject;
import com.sigge.filerunner.view.jobs.IJobSchedule;
import com.sigge.filerunner.view.jobs.IJobStep;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;

public class LoadJobDetailsCommand
extends AJobCommand {
    public static final int NO_END_DATE = 99991231;
    public static final int MAX_END_TIME = 235959;
    public static final int FREQ_ONE_TIME = 1;
    public static final int FREQ_DAILY = 4;
    public static final int FREQ_WEEKLY = 8;
    public static final int FREQ_MONTHLY = 16;
    public static final int FREQ_MONTHLY2 = 32;
    public static final int FREQ_ON_START = 64;
    public static final int FREQ_ON_IDLE = 128;
    public static final int AT_SPECIFIC_TIME = 1;
    public static final int EVERY_X_SECOND = 2;
    public static final int EVERY_X_MINUTE = 4;
    public static final int EVERY_X_HOUR = 8;

    public ICommandResult<IJobObject> execute(Database serverDatabase, SQLServerJob job, List<Subsystem> subsystems) {
        CommandResult result = new CommandResult();
        try (SQLServerRunner runner = new SQLServerRunner(new ServerDatabase(serverDatabase, "msdb"), "declare @retval int\nexec @retval = sp_help_jobstep @job_id = '" + job.getNativeId() + "'\nselect @retval AS [retval]\nexec @retval = sp_help_jobschedule @job_id = '" + job.getNativeId() + "',  @include_description = 1\n");){
            ArrayList jobSteps = new ArrayList();
            ArrayList jobSchedules = new ArrayList();
            runner.runQuery((rs, count) -> {
                try {
                    switch (count) {
                        case 1: {
                            this.getSteps(job, rs, jobSteps, subsystems);
                            job.getSteps().clear();
                            job.getSteps().addAll(jobSteps);
                            break;
                        }
                        case 2: {
                            if (this.checkReturn(rs, job, result)) break;
                            return;
                        }
                        case 3: {
                            this.getSchedule(job, rs, jobSchedules);
                            job.getSchedules().clear();
                            job.getSchedules().addAll(jobSchedules);
                            break;
                        }
                        case 4: {
                            if (this.checkReturn(rs, job, result)) break;
                            return;
                        }
                    }
                    while (rs.next()) {
                        int returnValue = rs.getInt("retval");
                        if (rs.wasNull()) {
                            result.addFailureResult(job, "Retval null, something wrong when fetching result", null);
                            continue;
                        }
                        if (returnValue != 0) {
                            result.addFailureResult(job, "Job delete failed with error code:" + returnValue, null);
                            continue;
                        }
                        result.addOkResult(job);
                    }
                }
                catch (Exception ex) {
                    result.addFailureResult(job, "Failed while fetching job deleted status", ex);
                }
            }, ex -> result.addFailureResult(job, "Failed while executing job stop", (Exception)ex));
        }
        catch (Exception ex2) {
            result.addFailureResult(job, "Failed while setting up job runner", ex2);
        }
        return result;
    }

    private void getSchedule(SQLServerJob job, ResultSet rs, List<IJobSchedule> jobSchedules) throws SQLException {
        while (rs.next()) {
            SQLServerSchedule schedule = new SQLServerSchedule();
            schedule.setScheduleId(rs.getInt("schedule_id"));
            schedule.setScheduleName(rs.getString("schedule_name"));
            schedule.setEnabled(rs.getBoolean("enabled"));
            int freq_type = rs.getInt("freq_type");
            int freq_interval = rs.getInt("freq_interval");
            int freq_subday_type = rs.getInt("freq_subday_type");
            int freq_subday_interval = rs.getInt("freq_subday_interval");
            int freq_relative_interval = rs.getInt("freq_relative_interval");
            int freq_recurrence_factor = rs.getInt("freq_recurrence_factor");
            Integer active_start_date = rs.getInt("active_start_date");
            if (rs.wasNull()) {
                active_start_date = null;
            }
            Integer active_end_date = rs.getInt("active_end_date");
            if (rs.wasNull()) {
                active_end_date = null;
            }
            Integer active_start_time = rs.getInt("active_start_time");
            if (rs.wasNull()) {
                active_start_time = null;
            }
            Integer active_end_time = rs.getInt("active_end_time");
            if (rs.wasNull()) {
                active_end_time = null;
            }
            Timestamp date_created = rs.getTimestamp("date_created");
            String schedule_description = rs.getString("schedule_description");
            Integer next_run_date = rs.getInt("next_run_date");
            if (rs.wasNull()) {
                next_run_date = null;
            }
            Integer next_run_time = rs.getInt("next_run_time");
            if (rs.wasNull()) {
                next_run_time = null;
            }
            String schedule_uid = rs.getString("schedule_uid");
            int job_count = rs.getInt("job_count");
            schedule.setScheduleGUID(schedule_uid);
            RecurringSchedule recurringSchedule = new RecurringSchedule();
            MonthlySchedule monthySchedule = new MonthlySchedule();
            DailyRecurringTimeSchedule dailyRecurringTimeSchedule = new DailyRecurringTimeSchedule();
            dailyRecurringTimeSchedule.setEveryNth(freq_subday_interval);
            dailyRecurringTimeSchedule.setEveryNthType(TimePeriod.SECOND);
            dailyRecurringTimeSchedule.setStart(active_start_time != null ? SQLServerSchedule.getTimeFromInt(active_start_time) : null);
            dailyRecurringTimeSchedule.setEnd(active_end_time != null ? SQLServerSchedule.getTimeFromInt(active_end_time) : null);
            recurringSchedule.setStartDate(active_start_date != null ? SQLServerSchedule.getDateFromInt(active_start_date) : null);
            recurringSchedule.setEndDate(active_end_date != null ? SQLServerSchedule.getDateFromInt(active_end_date) : null);
            recurringSchedule.setEnding(active_end_date != null && active_end_date < 99991231);
            switch (freq_type) {
                case 1: {
                    schedule.setScheduleType(ScheduleType.ONE_TIME);
                    OneTimeSchedule oneTimeSchedule = new OneTimeSchedule();
                    schedule.setOneTimeSchedule(oneTimeSchedule);
                    oneTimeSchedule.setDate(active_start_date != null ? SQLServerSchedule.getDateFromInt(active_start_date) : null);
                    oneTimeSchedule.setTime(active_start_time != null ? SQLServerSchedule.getTimeFromInt(active_start_time) : null);
                    break;
                }
                case 4: {
                    schedule.setRecurringSchedule(recurringSchedule);
                    DailySchedule dailySchedule = new DailySchedule();
                    recurringSchedule.setScheduleType(ScheduleType.DAY);
                    recurringSchedule.setDailySchedule(dailySchedule);
                    schedule.setScheduleType(ScheduleType.FLUENT);
                    recurringSchedule.setEveryNth(freq_interval);
                    break;
                }
                case 8: {
                    schedule.setRecurringSchedule(recurringSchedule);
                    schedule.setScheduleType(ScheduleType.FLUENT);
                    WeeklySchedule weeklySchedule = new WeeklySchedule();
                    recurringSchedule.setScheduleType(ScheduleType.WEEK);
                    recurringSchedule.setWeeklySchedule(weeklySchedule);
                    weeklySchedule.setFromFreq_interval(freq_interval);
                    recurringSchedule.setEveryNth(freq_recurrence_factor);
                    break;
                }
                case 16: {
                    schedule.setRecurringSchedule(recurringSchedule);
                    schedule.setScheduleType(ScheduleType.FLUENT);
                    recurringSchedule.setScheduleType(ScheduleType.MONTH);
                    recurringSchedule.setMonthySchedule(monthySchedule);
                    recurringSchedule.setEveryNth(freq_recurrence_factor);
                    monthySchedule.setRecurrencyType(freq_interval);
                    monthySchedule.setTimeOfMonth(TimePeriod.DAY);
                    break;
                }
                case 32: {
                    schedule.setRecurringSchedule(recurringSchedule);
                    schedule.setScheduleType(ScheduleType.FLUENT);
                    recurringSchedule.setScheduleType(ScheduleType.MONTH);
                    recurringSchedule.setMonthySchedule(monthySchedule);
                    recurringSchedule.setEveryNth(freq_recurrence_factor);
                    monthySchedule.setRecurrencyType((Object)RelativeFrequency.getRelativeFrequency(freq_relative_interval));
                    TimePeriod p = null;
                    switch (freq_interval) {
                        case 1: {
                            p = TimePeriod.SUNDAY;
                            break;
                        }
                        case 2: {
                            p = TimePeriod.MONDAY;
                            break;
                        }
                        case 3: {
                            p = TimePeriod.TUESDAY;
                            break;
                        }
                        case 4: {
                            p = TimePeriod.WEDNESDAY;
                            break;
                        }
                        case 5: {
                            p = TimePeriod.THURSDAY;
                            break;
                        }
                        case 6: {
                            p = TimePeriod.FRIDAY;
                            break;
                        }
                        case 7: {
                            p = TimePeriod.SATURDAY;
                            break;
                        }
                        case 8: {
                            p = TimePeriod.DAY;
                            break;
                        }
                        case 9: {
                            p = TimePeriod.WEEK_DAY;
                            break;
                        }
                        case 10: {
                            p = TimePeriod.WEEKEND_DAY;
                        }
                    }
                    monthySchedule.setTimeOfMonth(p);
                    break;
                }
                case 64: {
                    schedule.setScheduleType(ScheduleType.ON_START);
                    break;
                }
                case 128: {
                    schedule.setScheduleType(ScheduleType.ON_IDLE);
                    break;
                }
            }
            switch (freq_subday_type) {
                case 1: {
                    recurringSchedule.setDailySubType(FrequencyType.ONE_TIME);
                    DailyOneTimeSchedule dailyOneTimeSchedule = new DailyOneTimeSchedule();
                    recurringSchedule.setDailyOneTimeSchedule(dailyOneTimeSchedule);
                    dailyOneTimeSchedule.setTime(active_start_time != null ? SQLServerSchedule.getTimeFromInt(active_start_time) : null);
                    break;
                }
                case 2: {
                    recurringSchedule.setDailySubType(FrequencyType.EVERY_NTH);
                    recurringSchedule.setDailyRecurringTimeSchedule(dailyRecurringTimeSchedule);
                    dailyRecurringTimeSchedule.setEveryNthType(TimePeriod.SECOND);
                    break;
                }
                case 4: {
                    recurringSchedule.setDailySubType(FrequencyType.EVERY_NTH);
                    recurringSchedule.setDailyRecurringTimeSchedule(dailyRecurringTimeSchedule);
                    dailyRecurringTimeSchedule.setEveryNthType(TimePeriod.MINUTE);
                    break;
                }
                case 8: {
                    recurringSchedule.setDailySubType(FrequencyType.EVERY_NTH);
                    recurringSchedule.setDailyRecurringTimeSchedule(dailyRecurringTimeSchedule);
                    dailyRecurringTimeSchedule.setEveryNthType(TimePeriod.HOUR);
                    break;
                }
            }
            jobSchedules.add(schedule);
        }
    }

    private void getSteps(SQLServerJob job, ResultSet rs, List<IJobStep> jobSteps, List<Subsystem> subsystems) throws SQLException {
        while (rs.next()) {
            SQLServerJobStep ss = new SQLServerJobStep();
            jobSteps.add(ss);
            int stepNumber = rs.getInt("step_id");
            ss.setStepNumber(stepNumber);
            ss.setStepNumberOriginal(stepNumber);
            ss.setJobId(job.getNativeId());
            ss.setStepId("fromdb");
            String stepName = rs.getString("step_name");
            ss.setStepName(stepName);
            ss.setStepNameOriginal(stepName);
            String subsystem = rs.getString("subsystem");
            ss.setSubsystem(subsystems.stream().filter(f -> f.getName().equals(subsystem)).findAny().orElse(new Subsystem(subsystem, "")));
            ss.setCommand(rs.getString("command"));
            ss.setFlags(rs.getInt("flags"));
            ss.setOnSuccess(new StepAction(rs.getInt("on_success_action"), rs.getInt("on_success_step_id")));
            ss.setOnFailure(new StepAction(rs.getInt("on_fail_action"), rs.getInt("on_fail_step_id")));
            ss.setDatabase(rs.getString("database_name"));
            ss.setUserName(rs.getString("database_user_name"));
            ss.setRetryAttempts(rs.getInt("retry_attempts"));
            ss.setRetryInterval(rs.getInt("retry_interval"));
            ss.setOutputFileName(rs.getString("output_file_name"));
        }
    }

    private boolean checkReturn(ResultSet rs, SQLServerJob job, CommandResult result) throws SQLException {
        if (!rs.next()) {
            result.addFailureResult(job, "Cannot fetch retval", null);
            return false;
        }
        int returnValue = rs.getInt("retval");
        if (rs.wasNull()) {
            result.addFailureResult(job, "Retval null, something wrong when fetching result", null);
            return false;
        }
        if (returnValue != 0) {
            result.addFailureResult(job, "Job delete failed with error code:" + returnValue, null);
            return false;
        }
        return true;
    }
}

