/*
 * Decompiled with CFR 0.152.
 */
package com.sigge.filerunner.sql.sqlserver.jobs.commands;

import com.sigge.dbrunner.Database;
import com.sigge.filerunner.sql.ServerDatabase;
import com.sigge.filerunner.sql.sqlserver.jobs.CommandResult;
import com.sigge.filerunner.sql.sqlserver.jobs.ICommandResult;
import com.sigge.filerunner.sql.sqlserver.jobs.SQLServerJob;
import com.sigge.filerunner.sql.sqlserver.jobs.SQLServerRunner;
import com.sigge.filerunner.view.jobs.IJobObject;
import java.util.List;

public class DeleteCommand {
    public ICommandResult<IJobObject> execute(Database serverDatabase, List<IJobObject> objects, boolean removeHistory) {
        CommandResult result = new CommandResult();
        for (IJobObject job : objects) {
            try {
                SQLServerRunner runner = new SQLServerRunner(new ServerDatabase(serverDatabase, "msdb"), "declare @retval int\nexec @retval = sp_delete_job @job_id = '" + ((SQLServerJob)job).getNativeId() + "', @delete_history = " + (removeHistory ? 1 : 0) + "\n, @delete_unused_schedule = 0\nselect @retval AS [retval]");
                Throwable throwable = null;
                try {
                    runner.runQuery((rs, count) -> {
                        try {
                            while (rs.next()) {
                                int returnValue = rs.getInt("retval");
                                if (rs.wasNull()) {
                                    result.addFailureResult(job, "Retval null, something wrong when fetching result", null);
                                    continue;
                                }
                                if (returnValue != 0) {
                                    result.addFailureResult(job, "Job delete failed with error code:" + returnValue, null);
                                    continue;
                                }
                                result.addOkResult(job);
                            }
                        }
                        catch (Exception ex) {
                            result.addFailureResult(job, "Failed while fetching job deleted status", ex);
                        }
                    }, ex -> result.addFailureResult(job, "Failed while executing job stop", (Exception)ex));
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (runner == null) continue;
                    if (throwable != null) {
                        try {
                            runner.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    runner.close();
                }
            }
            catch (Exception ex2) {
                result.addFailureResult(job, "Failed while setting up job runner", ex2);
            }
        }
        return result;
    }
}

