/*
 * Decompiled with CFR 0.152.
 */
package com.sigge.filerunner.sql.sqlserver.jobs;

import com.sigge.dbrunner.Database;
import com.sigge.filerunner.completion.ADBCompletionProvider;
import com.sigge.filerunner.core.Feedbacker;
import com.sigge.filerunner.core.IFeedback;
import com.sigge.filerunner.core.StringUtils;
import com.sigge.filerunner.sql.ServerDatabase;
import com.sigge.filerunner.sql.sqlserver.jobs.CommandResult;
import com.sigge.filerunner.sql.sqlserver.jobs.ICommandResult;
import com.sigge.filerunner.sql.sqlserver.jobs.SQLServerJob;
import com.sigge.filerunner.sql.sqlserver.jobs.SQLServerJobManager;
import com.sigge.filerunner.sql.sqlserver.jobs.SQLServerRunner;
import com.sigge.filerunner.sql.sqlserver.jobs.commands.AJobCommand;
import com.sigge.filerunner.sql.sqlserver.jobs.commands.DeleteCommand;
import com.sigge.filerunner.sql.sqlserver.jobs.commands.HistoryCommand;
import com.sigge.filerunner.sql.sqlserver.jobs.commands.LoadCommand;
import com.sigge.filerunner.sql.sqlserver.jobs.commands.LoadJobDetailsCommand;
import com.sigge.filerunner.sql.sqlserver.jobs.commands.RunCommand;
import com.sigge.filerunner.sql.sqlserver.jobs.commands.SaveCommand;
import com.sigge.filerunner.sql.sqlserver.jobs.commands.StopCommand;
import com.sigge.filerunner.sql.sqlserver.jobs.schedule.JobScheduleModel;
import com.sigge.filerunner.sql.sqlserver.jobs.schedule.SQLServerSchedule;
import com.sigge.filerunner.sql.sqlserver.jobs.schedule.ScheduleEdit;
import com.sigge.filerunner.sql.sqlserver.jobs.steps.JobStepEdit;
import com.sigge.filerunner.sql.sqlserver.jobs.steps.JobStepTableModel;
import com.sigge.filerunner.sql.sqlserver.jobs.steps.SQLServerAgentProxy;
import com.sigge.filerunner.sql.sqlserver.jobs.steps.SQLServerJobStep;
import com.sigge.filerunner.sql.sqlserver.jobs.steps.StepAction;
import com.sigge.filerunner.sql.sqlserver.jobs.steps.Subsystem;
import com.sigge.filerunner.view.JMemoryDialog;
import com.sigge.filerunner.view.core.DatabaseUtils;
import com.sigge.filerunner.view.core.LabelledCellRenderer;
import com.sigge.filerunner.view.core.LabelledColumnCellRenderer;
import com.sigge.filerunner.view.core.VTable;
import com.sigge.filerunner.view.jobs.ICommand;
import com.sigge.filerunner.view.jobs.IJob;
import com.sigge.filerunner.view.jobs.IJobObject;
import com.sigge.filerunner.view.jobs.IJobServer;
import com.sigge.filerunner.view.jobs.IJobServerManager;
import com.sigge.filerunner.view.jobs.IJobStep;
import com.sigge.filerunner.view.jobs.JobEditView;
import com.sigge.filerunner.view.jobs.JobHistoryParams;
import com.sigge.filerunner.view.jobs.StandardJobCommand;
import com.siggemannen.binding.AModel;
import com.siggemannen.binding.APresenter;
import com.siggemannen.binding.IProperty;
import com.siggemannen.core.ListUtils;
import com.siggemannen.functional.throwing.ThrowingSupplier;
import com.siggemannen.view.UIBackgroundRunner;
import com.siggemannen.view.UIOptionBuilderSupplier;
import com.siggemannen.view.UIOptionSupplier;
import com.siggemannen.view.multiple.MultipleUIBackgroundRunner;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Point;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.logging.Level;
import java.util.stream.Collectors;
import javax.swing.DefaultCellEditor;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.RootPaneContainer;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableModel;
import org.jdesktop.swingx.JXErrorPane;
import org.jdesktop.swingx.error.ErrorInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SQLServerAgentJobServer
implements IJobServer {
    private static final String ERROR_IN_VALIDATION = "Error in validation";
    private Database serverDatabase;
    private String name;
    private String id;
    private boolean enabled = true;
    private final transient SQLServerJobManager manager;
    private final transient IFeedback feedback;
    private List<Subsystem> subsystems;
    private List<SQLServerAgentProxy> proxies;
    private Map<Integer, Set<Integer>> proxySystems;
    private LoadCommand loadCommand;
    private volatile boolean shuttingDown = false;
    private static final Logger LOGGER = LoggerFactory.getLogger(SQLServerAgentJobServer.class);

    public SQLServerAgentJobServer(SQLServerJobManager manager, IFeedback feedback) {
        this.manager = manager;
        this.feedback = feedback;
    }

    @Override
    public IJobServer createCopy() {
        SQLServerAgentJobServer copy = new SQLServerAgentJobServer(this.manager, this.feedback);
        copy.serverDatabase = this.serverDatabase;
        copy.name = this.name;
        copy.id = this.id;
        copy.enabled = this.enabled;
        copy.subsystems = this.subsystems != null ? new ArrayList<Subsystem>(this.subsystems) : this.subsystems;
        copy.proxies = this.proxies != null ? new ArrayList<SQLServerAgentProxy>(this.proxies) : this.proxies;
        copy.proxySystems = this.proxySystems != null ? new HashMap<Integer, Set<Integer>>(this.proxySystems) : this.proxySystems;
        copy.loadCommand = this.loadCommand;
        return copy;
    }

    @Override
    public IJobServerManager getJobServerManager() {
        return this.manager;
    }

    @Override
    public String getLabel() {
        if (StringUtils.isNotEmpty(this.name)) {
            return this.name;
        }
        if (this.serverDatabase != null) {
            return this.serverDatabase.getLabel();
        }
        return null;
    }

    @Override
    public Color getColor() {
        return DatabaseUtils.getColor(this.serverDatabase);
    }

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    @Override
    public void execute(ICommand command) {
    }

    @Override
    public boolean supports(ICommand command) {
        return false;
    }

    public List<Subsystem> getSubSystems() {
        if (this.subsystems == null) {
            try {
                Throwable throwable = null;
                Object var2_4 = null;
                try (SQLServerRunner runner = new SQLServerRunner(new ServerDatabase(this.serverDatabase, "msdb"), "exec sp_enum_sqlagent_subsystems_internal");){
                    runner.runQuery((rs, count) -> {
                        ArrayList<Subsystem> subsystems = new ArrayList<Subsystem>();
                        while (rs.next()) {
                            Subsystem s = new Subsystem();
                            s.setName(rs.getString("subsystem"));
                            s.setDescription(rs.getString("description"));
                            s.setSubsystem_id(rs.getInt("subsystem_id"));
                            subsystems.add(s);
                        }
                        this.subsystems = subsystems;
                    }, onError -> {
                        ArrayList<Subsystem> subs = new ArrayList<Subsystem>();
                        subs.add(Subsystem.TSQL_SUBSYSTEM);
                        this.subsystems = subs;
                    });
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return this.subsystems != null ? new ArrayList<Subsystem>(this.subsystems) : new ArrayList();
    }

    public List<SQLServerAgentProxy> getProxies() {
        ArrayList<SQLServerAgentProxy> ret;
        if (this.proxies == null) {
            try {
                Throwable throwable = null;
                Object var2_4 = null;
                try (SQLServerRunner runner = new SQLServerRunner(new ServerDatabase(this.serverDatabase, "msdb"), "exec sp_help_proxy");){
                    runner.runQuery((rs, count) -> {
                        ArrayList<SQLServerAgentProxy> proxies = new ArrayList<SQLServerAgentProxy>();
                        proxies.add(SQLServerAgentProxy.DEFAULT_PROXY);
                        while (rs.next()) {
                            SQLServerAgentProxy s = new SQLServerAgentProxy();
                            s.setProxy_id(rs.getInt("proxy_id"));
                            s.setName(rs.getString("name"));
                            s.setEnabled(rs.getBoolean("enabled"));
                            proxies.add(s);
                        }
                        this.proxies = proxies;
                    }, onError -> {
                        ArrayList<SQLServerAgentProxy> subs = new ArrayList<SQLServerAgentProxy>();
                        subs.add(SQLServerAgentProxy.DEFAULT_PROXY);
                        this.proxies = subs;
                    });
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        ArrayList<SQLServerAgentProxy> arrayList = ret = this.proxies != null ? new ArrayList<SQLServerAgentProxy>(this.proxies) : new ArrayList();
        if (ret.size() == 1) {
            this.proxySystems = new HashMap<Integer, Set<Integer>>();
        }
        return ret;
    }

    public Map<Integer, Set<Integer>> getProxySubsystems() {
        if (this.proxySystems == null) {
            try {
                Throwable throwable = null;
                Object var2_4 = null;
                try (SQLServerRunner runner = new SQLServerRunner(new ServerDatabase(this.serverDatabase, "msdb"), "exec sp_enum_proxy_for_subsystem");){
                    runner.runQuery((rs, count) -> {
                        HashMap<Integer, Set<Integer>> proxies = new HashMap<Integer, Set<Integer>>();
                        while (rs.next()) {
                            int subsystem = rs.getInt("subsystem_id");
                            int proxy = rs.getInt("proxy_id");
                            proxies.computeIfAbsent(subsystem, k -> new HashSet()).add(proxy);
                        }
                        this.proxySystems = proxies;
                    }, onError -> {});
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return this.proxySystems != null ? new HashMap<Integer, Set<Integer>>(this.proxySystems) : new HashMap();
    }

    public List<String> getUsers(String database) {
        ArrayList<String> users = new ArrayList<String>();
        try {
            Throwable throwable = null;
            Object var4_6 = null;
            try (SQLServerRunner runner = new SQLServerRunner(new ServerDatabase(this.serverDatabase, database), AJobCommand.readQueryString("sqlserver_job_users.sql"));){
                runner.runQuery((rs, count) -> {
                    while (rs.next()) {
                        String name = rs.getString("name");
                        if (name == null) continue;
                        users.add(name);
                    }
                }, onError -> {});
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return users;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void getJobs(Consumer<List<IJob>> jobsConsumer) {
        if (this.shuttingDown) {
            return;
        }
        SQLServerAgentJobServer sQLServerAgentJobServer = this;
        synchronized (sQLServerAgentJobServer) {
            if (this.loadCommand == null) {
                this.createLoadCommand();
            }
            if (this.loadCommand.isExecuting()) {
                return;
            }
        }
        this.loadCommand.execute(jobsConsumer);
    }

    private void createLoadCommand() {
        this.loadCommand = new LoadCommand(this, this.serverDatabase);
    }

    private SQLServerJob getJob(List<IJobObject> jobObjects) {
        return (SQLServerJob)jobObjects.get(0);
    }

    @Override
    public <E> ICommandResult<IJobObject> execute(ICommand command, E parameters, List<IJobObject> jobObjects, MultipleUIBackgroundRunner runner) {
        if (command == StandardJobCommand.RUN) {
            return (ICommandResult)this.wrap((ThrowingSupplier<ICommandResult<IJobObject>>)((ThrowingSupplier)() -> new RunCommand().execute(this.serverDatabase, jobObjects)), runner).get();
        }
        if (command == StandardJobCommand.STOP) {
            return (ICommandResult)this.wrap((ThrowingSupplier<ICommandResult<IJobObject>>)((ThrowingSupplier)() -> new StopCommand().execute(this.serverDatabase, jobObjects)), runner).get();
        }
        if (command == StandardJobCommand.DELETE) {
            IFeedback.IFeedbackResult result = this.feedback.showMessage(new Feedbacker("Do you want to delete job history?").buttons("Delete history", "Keep history", "Cancel delete"));
            if (result == IFeedback.IFeedbackResult.CLOSED || result == IFeedback.IFeedbackResult.THIRD) {
                return CommandResult.cancelled();
            }
            return (ICommandResult)this.wrap((ThrowingSupplier<ICommandResult<IJobObject>>)((ThrowingSupplier)() -> new DeleteCommand().execute(this.serverDatabase, jobObjects, result == IFeedback.IFeedbackResult.FIRST)), runner).get();
        }
        if (command == StandardJobCommand.ENABLE || command == StandardJobCommand.DISABLE) {
            for (IJobObject object : jobObjects) {
                if (object instanceof SQLServerJob) {
                    ((SQLServerJob)object).setEnabled(command == StandardJobCommand.ENABLE);
                    continue;
                }
                return new CommandResult(jobObjects, "Cannot enable object type");
            }
            return (ICommandResult)this.wrap((ThrowingSupplier<ICommandResult<IJobObject>>)((ThrowingSupplier)() -> new SaveCommand().execute(this.serverDatabase, jobObjects)), runner).get();
        }
        if (command == StandardJobCommand.SAVE) {
            return (ICommandResult)this.wrap((ThrowingSupplier<ICommandResult<IJobObject>>)((ThrowingSupplier)() -> new SaveCommand().execute(this.serverDatabase, jobObjects)), runner).get();
        }
        if (command == StandardJobCommand.HISTORY) {
            new HistoryCommand().execute(this.serverDatabase, jobObjects, (JobHistoryParams)parameters);
        } else {
            if (command == StandardJobCommand.VALIDATE) {
                SQLServerJob job = this.getJob(jobObjects);
                boolean check = this.precheckJob(job);
                return check ? new CommandResult() : new CommandResult(jobObjects, "Validation failed");
            }
            if (command == StandardJobCommand.EDIT) {
                final SQLServerJob job = this.getJob(jobObjects);
                JobEditView jobEdit = new JobEditView();
                JMemoryDialog jm = new JMemoryDialog(null, "Edit job", true, "sql-server-edit-job"){

                    protected void doClose(int retStatus) {
                        if (retStatus != 1 || SQLServerAgentJobServer.this.precheckJob(job)) {
                            super.doClose(retStatus);
                        }
                    }
                };
                jm.setContent(jobEdit, true);
                jm.pack();
                jm.centerOnCorrectScreen(null);
                UIBackgroundRunner.execute((UIOptionSupplier)((UIOptionSupplier)((UIOptionBuilderSupplier)((UIOptionBuilderSupplier)new UIOptionBuilderSupplier(() -> this.loadFullJob(job), f -> {
                    if (f.isOK()) {
                        this.setJobInView(jobEdit, job);
                    } else {
                        System.out.println(f);
                    }
                }).title("Loading job", "Busy loading job", "Cancel loading")).mainPanel((RootPaneContainer)((Object)jm))).build()));
                jm.setVisible(true);
                if (jm.getReturnStatus() == 1) {
                    UIBackgroundRunner.execute((UIOptionSupplier)((UIOptionSupplier)((UIOptionBuilderSupplier)new UIOptionBuilderSupplier(() -> new SaveCommand().execute(this.serverDatabase, job), cb -> {
                        if (!cb.isOK()) {
                            cb.getDetails().get(0).getException().ifPresent(ex -> JXErrorPane.showDialog(null, (ErrorInfo)new ErrorInfo("Error saving command", "Error while saving", null, null, (Throwable)ex, Level.SEVERE, null)));
                        }
                    }).title("Saving job", "Saving job:" + job.getName(), "Cancel")).build()));
                }
                return jm.getReturnStatus() == 1 ? new CommandResult() : CommandResult.cancelled();
            }
        }
        return new CommandResult(jobObjects, "Unsupported command:" + command);
    }

    private boolean precheckJob(SQLServerJob job) {
        boolean failureLeadsToVoid;
        if (job.getSteps().size() == 0) {
            this.showErrorMessage("Job doesn't have any steps, at least one step is needed", ERROR_IN_VALIDATION);
            return false;
        }
        if (job.getName() == null || job.getName().length() == 0) {
            this.showErrorMessage("Job doesn't have a name", ERROR_IN_VALIDATION);
            return false;
        }
        HashMap<Integer, Object> steps = new HashMap<Integer, Object>();
        HashSet<Integer> targetSteps = new HashSet<Integer>();
        HashSet<ADBCompletionProvider.Wrapee> stepNames = new HashSet<ADBCompletionProvider.Wrapee>();
        int i = 0;
        while (i < job.getSteps().size()) {
            SQLServerJobStep step = (SQLServerJobStep)job.getSteps().get(i);
            if (step.getOnFailure().getType() == StepAction.ActionType.GO_TO_STEP_X) {
                targetSteps.add(step.getOnFailure().getStepTo());
            }
            if (step.getOnSuccess().getType() == StepAction.ActionType.GO_TO_STEP_X) {
                targetSteps.add(step.getOnSuccess().getStepTo());
            }
            if (targetSteps.contains(step.getStepNumber())) {
                this.showErrorMessage("Step cannot go to itself", ERROR_IN_VALIDATION);
                return false;
            }
            if (steps.put(step.getNumber(), step) != null) {
                this.showErrorMessage("Duplicate step number:" + step.getNumber(), ERROR_IN_VALIDATION);
                return false;
            }
            if (!stepNames.add(new ADBCompletionProvider.Wrapee(step.getStepName()))) {
                this.showErrorMessage("Duplicate step names:" + step.getNumber() + " (" + step.getStepName() + ",", ERROR_IN_VALIDATION);
                return false;
            }
            ++i;
        }
        if (!steps.containsKey(job.getStartStepId())) {
            this.showErrorMessage("Job start step doesn't exist: " + job.getStartStepId(), ERROR_IN_VALIDATION);
            return false;
        }
        for (Integer i2 : targetSteps) {
            if (steps.containsKey(i2)) continue;
            this.showErrorMessage("Job to step doesn't exist: " + i2, ERROR_IN_VALIDATION);
            return false;
        }
        SQLServerJobStep s = (SQLServerJobStep)job.getSteps().get(job.getSteps().size() - 1);
        boolean successLeadsToVoid = s.getOnSuccess().getType() == StepAction.ActionType.GO_TO_NEXT_STEP;
        boolean bl = failureLeadsToVoid = s.getOnFailure().getType() == StepAction.ActionType.GO_TO_NEXT_STEP;
        if (successLeadsToVoid != failureLeadsToVoid) {
            String changeString = "Change to: " + (successLeadsToVoid ? "\"quit with success\"" : "\"quit with failure\"");
            String keepString = "Keep as is";
            String cancelString = "Cancel saving";
            Object result = JOptionPane.showInputDialog(null, String.valueOf(successLeadsToVoid ? "On success" : "On failure") + " of last step point to next step. Do you want to change " + "the target to: " + (successLeadsToVoid ? "\"quit with success\"" : "\"quit with failure\""), "Change last step", 3, null, new Object[]{changeString, keepString, cancelString}, changeString);
            if (result == null) {
                return false;
            }
            if (result.equals(changeString)) {
                if (successLeadsToVoid) {
                    s.setOnSuccess(StepAction.QUIT_WITH_SUCCESS);
                } else {
                    s.setOnFailure(StepAction.QUIT_WITH_FAILURE);
                }
                return true;
            }
            return result.equals(keepString);
        }
        if (successLeadsToVoid) {
            String changeString = "Change to \"quit with success/failure\"";
            String keepString = "Keep as is";
            String cancelString = "Cancel saving";
            Object result = JOptionPane.showInputDialog(null, "Last step on success/failure point to next step. Do you want to change the target to: quit with appropriate result?", "Change last step", 3, null, new Object[]{changeString, keepString, cancelString}, changeString);
            if (result == null) {
                return false;
            }
            if (result.equals(changeString)) {
                s.setOnSuccess(StepAction.QUIT_WITH_SUCCESS);
                s.setOnFailure(StepAction.QUIT_WITH_FAILURE);
                return true;
            }
            return result.equals(keepString);
        }
        return true;
    }

    private void showErrorMessage(String message, String title) {
        JOptionPane.showMessageDialog(null, message, title, 1);
    }

    private ICommandResult<IJobObject> loadFullJob(SQLServerJob job) {
        return new LoadJobDetailsCommand().execute(this.serverDatabase, job, this.getSubSystems());
    }

    @Override
    public boolean needsParameters(ICommand command) {
        return ListUtils.in((Object)command, (Object[])new ICommand[]{StandardJobCommand.DELETE, StandardJobCommand.EDIT});
    }

    private ThrowingSupplier<ICommandResult<IJobObject>> wrap(ThrowingSupplier<ICommandResult<IJobObject>> runnable, MultipleUIBackgroundRunner runner) {
        if (runner == null) {
            return runnable;
        }
        return () -> {
            runner.attachJob((UIOptionSupplier)new UIOptionBuilderSupplier(runnable, e -> {}).build());
            return new CommandResult();
        };
    }

    @Override
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public Database getServerDatabase() {
        return this.serverDatabase;
    }

    public void setServerDatabase(Database serverDatabase) {
        this.serverDatabase = serverDatabase;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.id == null ? 0 : this.id.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SQLServerAgentJobServer other = (SQLServerAgentJobServer)obj;
        return !(this.id == null ? other.id != null : !this.id.equals(other.id));
    }

    @Override
    public IJob addJob(JPanel mainContainer) {
        JobEditView jobEdit = new JobEditView();
        mainContainer.removeAll();
        mainContainer.add(jobEdit);
        mainContainer.revalidate();
        Container c = mainContainer.getTopLevelAncestor();
        if (c instanceof Window) {
            ((Window)c).pack();
        }
        SQLServerJob job = new SQLServerJob(this);
        job.setEnabled(true);
        this.setJobInView(jobEdit, job);
        return job;
    }

    private void setJobInView(JobEditView jobEdit, final SQLServerJob job) {
        jobEdit.getAdvancedButton().setEnabled(false);
        SQLServerJobModel model = new SQLServerJobModel();
        APresenter<SQLServerJob, SQLServerJobModel, JobEditView> presenter = new APresenter<SQLServerJob, SQLServerJobModel, JobEditView>(model, jobEdit){

            protected void initBindings() {
                this.bind(((JobEditView)this.view).getJobNameText()).to(((SQLServerJobModel)this.model).name);
                this.bind(((JobEditView)this.view).getEnableCheckbox()).to(((SQLServerJobModel)this.model).enabled);
                this.bind(((JobEditView)this.view).getStartAtStep()).to(SQLServerAgentJobServer.this.getSteps(job), ((SQLServerJobModel)this.model).startStepId);
            }
        };
        JobStepTableModel stepModel = new JobStepTableModel();
        stepModel.setDataVector(job.getSteps(), Arrays.asList("ID", "Name", "Command", "On success", "On failure"));
        VTable stepTable = jobEdit.getStepTable();
        stepTable.setModel((TableModel)((Object)stepModel));
        stepTable.getColumn(4).setCellRenderer(new LabelledColumnCellRenderer());
        stepTable.getColumn(3).setCellRenderer(new LabelledColumnCellRenderer());
        stepTable.getColumnExt(2).setVisible(false);
        stepTable.getColumnExt(0).setPreferredWidth(30);
        this.assignEditorsForTable(stepTable, job);
        final JobScheduleModel scheduleModel = new JobScheduleModel();
        scheduleModel.setDataVector(job.getSchedules(), Arrays.asList("Enabled", "Name", "Description"));
        final VTable scheduleTable = jobEdit.getScheduleTable();
        scheduleTable.setModel((TableModel)((Object)scheduleModel));
        scheduleTable.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                Point point = mouseEvent.getPoint();
                int row = scheduleTable.rowAtPoint(point);
                if (mouseEvent.getClickCount() >= 2 && scheduleTable.getSelectedRow() != -1) {
                    SQLServerAgentJobServer.this.editScheduleRow(scheduleModel, scheduleTable, row);
                }
            }
        });
        jobEdit.getMoveUpButton().addActionListener(al -> {
            int[] selectedRows = stepTable.getSelectedRows();
            if (selectedRows.length != 1) {
                return;
            }
            int row = 0;
            while (row < selectedRows.length) {
                int modelIndex = stepTable.convertRowIndexToModel(selectedRows[row]);
                if (modelIndex == 0) {
                    return;
                }
                ListUtils.moveItem(job.getSteps(), (int)modelIndex, (boolean)true);
                stepModel.fireTableRowsUpdated(modelIndex - 1, modelIndex);
                stepTable.getSelectionModel().setSelectionInterval(stepTable.convertRowIndexToView(modelIndex - 1), stepTable.convertRowIndexToView(modelIndex - 1));
                ++row;
            }
        });
        jobEdit.getMoveDownButton().addActionListener(al -> {
            int[] selectedRows = stepTable.getSelectedRows();
            if (selectedRows.length != 1) {
                return;
            }
            int row = selectedRows.length - 1;
            while (row >= 0) {
                int modelIndex = stepTable.convertRowIndexToModel(selectedRows[row]);
                if (modelIndex + 1 >= job.getSteps().size()) {
                    return;
                }
                ListUtils.moveItem(job.getSteps(), (int)modelIndex, (boolean)false);
                stepModel.fireTableRowsUpdated(modelIndex, modelIndex + 1);
                stepTable.getSelectionModel().setSelectionInterval(stepTable.convertRowIndexToView(modelIndex + 1), stepTable.convertRowIndexToView(modelIndex + 1));
                --row;
            }
        });
        jobEdit.getAddButton().addActionListener(arg_0 -> this.lambda$23(job, stepModel, stepTable, (APresenter)presenter, jobEdit, model, arg_0));
        jobEdit.getEditButton().addActionListener(arg_0 -> this.lambda$24(stepTable, stepModel, job, (APresenter)presenter, jobEdit, model, arg_0));
        jobEdit.getRemoveStepButton().addActionListener(arg_0 -> this.lambda$25(stepTable, stepModel, job, model, (APresenter)presenter, jobEdit, arg_0));
        stepTable.packAll();
        scheduleTable.packAll();
        jobEdit.getStartAtStep().setRenderer(new DefaultListCellRenderer(){

            @Override
            public Component getListCellRendererComponent(JList<?> list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                JLabel comp = (JLabel)super.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
                if (value instanceof Integer) {
                    comp.setText("Step ID: " + value);
                }
                return comp;
            }
        });
        jobEdit.getAddScheduleButton().addActionListener(al -> {
            SQLServerSchedule schedule = new ScheduleEdit().addSchedule();
            if (schedule != null) {
                if (StringUtils.isEmpty(schedule.getScheduleName())) {
                    schedule.setScheduleName(schedule.getScheduleString());
                }
                scheduleModel.addRow(schedule);
                scheduleModel.fireTableDataChanged();
                scheduleTable.packAll();
            }
        });
        jobEdit.getEditScheduleButton().addActionListener(al -> {
            int viewRowIndex = scheduleTable.getSelectedRow();
            this.editScheduleRow(scheduleModel, scheduleTable, viewRowIndex);
        });
        jobEdit.getDeleteSchedule().addActionListener(al -> {
            int[] selectedRows = scheduleTable.getSelectedRows();
            int row = selectedRows.length - 1;
            while (row >= 0) {
                int modelIndex = scheduleTable.convertRowIndexToModel(selectedRows[row]);
                SQLServerSchedule editSchedule = (SQLServerSchedule)scheduleModel.getValueAt(modelIndex);
                job.deleteSchedule(editSchedule);
                scheduleModel.fireTableRowsDeleted(modelIndex, modelIndex);
                --row;
            }
        });
        stepTable.getSelectionModel().addListSelectionListener(l -> this.enableDisableStepButtons(jobEdit));
        scheduleTable.getSelectionModel().addListSelectionListener(l -> this.enableScheduleButtons(jobEdit));
        this.enableDisableStepButtons(jobEdit);
        this.enableScheduleButtons(jobEdit);
        presenter.setObject((Object)job);
    }

    private void assignEditorsForTable(VTable stepTable, SQLServerJob job) {
        TableCellEditor editor = this.getEditorForStepMove(job);
        stepTable.getColumn(((JobStepTableModel)((Object)stepTable.getModel())).getColumnName(4)).setCellEditor(editor);
        stepTable.getColumn(((JobStepTableModel)((Object)stepTable.getModel())).getColumnName(3)).setCellEditor(editor);
    }

    private void editScheduleRow(JobScheduleModel scheduleModel, VTable scheduleTable, int viewRowIndex) {
        SQLServerSchedule editSchedule = (SQLServerSchedule)scheduleModel.getValueAt(scheduleTable.convertRowIndexToModel(viewRowIndex));
        SQLServerSchedule schedule = new ScheduleEdit().editSchedule(editSchedule = editSchedule.createCopy());
        if (schedule != null) {
            if (StringUtils.isEmpty(schedule.getScheduleName())) {
                schedule.setScheduleName(schedule.getScheduleString());
            }
            scheduleModel.replaceRow(scheduleTable.convertRowIndexToModel(viewRowIndex), schedule);
            scheduleModel.fireTableDataChanged();
            scheduleTable.packAll();
        }
    }

    private void enableScheduleButtons(JobEditView jobEdit) {
        int count = jobEdit.getScheduleTable().getSelectedRowCount();
        jobEdit.getEditScheduleButton().setEnabled(count == 1);
        jobEdit.getDeleteSchedule().setEnabled(count > 0);
    }

    private void enableDisableStepButtons(JobEditView jobEdit) {
        int count = jobEdit.getStepTable().getSelectedRowCount();
        jobEdit.getEditButton().setEnabled(count == 1);
        jobEdit.getRemoveStepButton().setEnabled(count > 0);
        jobEdit.getMoveUpButton().setEnabled(count == 1);
        jobEdit.getMoveDownButton().setEnabled(count == 1);
        jobEdit.getDuplicateButton().setEnabled(count > 0);
    }

    public TableCellEditor getEditorForStepMove(SQLServerJob sb) {
        JComboBox<Object> combo = new JComboBox<Object>();
        combo.setRenderer(new LabelledCellRenderer());
        ArrayList<StepAction> actionList = new ArrayList<StepAction>();
        actionList.add(StepAction.GO_TO_NEXT_STEP);
        actionList.add(StepAction.QUIT_WITH_SUCCESS);
        actionList.add(StepAction.QUIT_WITH_FAILURE);
        this.getSteps(sb).forEach(c -> actionList.add(new StepAction((int)c)));
        combo.setModel(new DefaultComboBoxModel<StepAction>(actionList.toArray(new StepAction[0])));
        combo.setEditable(false);
        DefaultCellEditor comboBoxCellEditor = new DefaultCellEditor(combo);
        comboBoxCellEditor.setClickCountToStart(2);
        return comboBoxCellEditor;
    }

    private List<Integer> getSteps(SQLServerJob job) {
        List<Integer> steps = job.getSteps().stream().map(s -> (SQLServerJobStep)s).map(SQLServerJobStep::getStepNumber).sorted().collect(Collectors.toList());
        if (steps.size() == 0) {
            steps.add(1);
        }
        return steps;
    }

    @Override
    public void cleanup() {
        if (this.shuttingDown) {
            return;
        }
        this.shuttingDown = true;
        this.loadCommand.cleanup();
    }

    private /* synthetic */ void lambda$23(SQLServerJob sQLServerJob, JobStepTableModel jobStepTableModel, VTable vTable, APresenter aPresenter, JobEditView jobEditView, SQLServerJobModel sQLServerJobModel, ActionEvent al) {
        new JobStepEdit().jobStepAdd(sQLServerJob, this.feedback);
        jobStepTableModel.fireTableDataChanged();
        vTable.packAll();
        aPresenter.bind((JComboBox)jobEditView.getStartAtStep()).to(this.getSteps(sQLServerJob), sQLServerJobModel.startStepId, true);
        this.assignEditorsForTable(vTable, sQLServerJob);
    }

    private /* synthetic */ void lambda$24(VTable vTable, JobStepTableModel jobStepTableModel, SQLServerJob sQLServerJob, APresenter aPresenter, JobEditView jobEditView, SQLServerJobModel sQLServerJobModel, ActionEvent al) {
        int viewRowIndex = vTable.getSelectedRow();
        IJobStep step = (IJobStep)jobStepTableModel.getValueAt(vTable.convertRowIndexToModel(viewRowIndex));
        new JobStepEdit().jobStepEdit(sQLServerJob, (SQLServerJobStep)step, this.feedback);
        jobStepTableModel.fireTableDataChanged();
        vTable.packAll();
        aPresenter.bind((JComboBox)jobEditView.getStartAtStep()).to(this.getSteps(sQLServerJob), sQLServerJobModel.startStepId, true);
        this.assignEditorsForTable(vTable, sQLServerJob);
    }

    private /* synthetic */ void lambda$25(VTable vTable, JobStepTableModel jobStepTableModel, SQLServerJob sQLServerJob, SQLServerJobModel sQLServerJobModel, APresenter aPresenter, JobEditView jobEditView, ActionEvent al) {
        int[] selectedRows = vTable.getSelectedRows();
        boolean jobStartStepDeleted = false;
        int row = selectedRows.length - 1;
        while (row >= 0) {
            int modelIndex = vTable.convertRowIndexToModel(selectedRows[row]);
            SQLServerJobStep editStep = (SQLServerJobStep)jobStepTableModel.getValueAt(modelIndex);
            if (editStep.getStepNumber() == sQLServerJob.getStartStepId()) {
                jobStartStepDeleted = true;
            }
            sQLServerJob.deleteStep(editStep);
            jobStepTableModel.fireTableRowsDeleted(modelIndex, modelIndex);
            --row;
        }
        if (jobStartStepDeleted && sQLServerJob.getSteps().size() > 0) {
            sQLServerJobModel.startStepId.setValue((Object)((SQLServerJobStep)sQLServerJob.getSteps().get(0)).getStepNumber());
        }
        aPresenter.bind((JComboBox)jobEditView.getStartAtStep()).to(this.getSteps(sQLServerJob), sQLServerJobModel.startStepId, true);
        this.assignEditorsForTable(vTable, sQLServerJob);
    }

    private static class SQLServerJobModel
    extends AModel<SQLServerJob> {
        IProperty<String> name = this.getProperty("name");
        IProperty<Boolean> enabled = this.getProperty("enabled");
        IProperty<Integer> startStepId = this.getProperty("startStepId");

        private SQLServerJobModel() {
        }

        protected void copyObject(SQLServerJob object) {
            this.copy = object;
        }
    }
}

