/*
 * Decompiled with CFR 0.152.
 */
package com.sigge.filerunner.sql.sqlserver;

import com.sigge.filerunner.sql.IResultSetProcessor;
import com.sigge.filerunner.sql.sqlserver.queryplan.QueryPlanBuilder;
import com.sigge.filerunner.view.results.IResultSetTable;
import com.sigge.filerunner.view.results.MultiResultPane;
import com.sigge.filerunner.view.results.QueryPlanPanel;
import com.siggemannen.core.ListUtils;
import java.sql.SQLWarning;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SQLServerResultSetProcessor
implements IResultSetProcessor {
    private static final Logger LOGGER = LoggerFactory.getLogger(SQLServerResultSetProcessor.class);
    private long counter = 1L;

    @Override
    public boolean displayWarning(SQLWarning warning) {
        return !ListUtils.in((Object)warning.getErrorCode(), (Object[])new Integer[]{8153, 8625});
    }

    @Override
    public boolean handleQueryPlan(IResultSetTable resultSet, MultiResultPane mp) {
        if (resultSet.getColumnCount() == 1 && resultSet.getColumnName(0).equals("Microsoft SQL Server 2005 XML Showplan")) {
            if (!mp.isQpenabled()) {
                return true;
            }
            try {
                String qplan = (String)resultSet.getValueAt(0, 0);
                QueryPlanBuilder qp = new QueryPlanBuilder();
                List<QueryPlanPanel> plans = qp.buildGraph(qplan, mp.getQueryPlanRepo(), resultSet.getIdentifier(), this.counter++);
                for (QueryPlanPanel qpl : plans) {
                    mp.addQueryPlan(qpl, resultSet);
                }
                return true;
            }
            catch (Exception e) {
                LOGGER.error("Error generating query plan", (Throwable)e);
            }
        }
        return false;
    }
}

