/*
 * Decompiled with CFR 0.152.
 */
package com.sigge.filerunner.sql.sqlserver;

import com.sigge.filerunner.sql.edit.ParseError;
import com.sigge.filerunner.sql.edit.ParseSource;
import com.siggemannen.sql.antler.ErrorBlockElementsUnfinishedStrategy;
import com.siggemannen.sql.antler.TSqlParser;
import com.siggemannen.sql.antler.TSqlParserBaseListener;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collections;
import java.util.List;
import org.antlr.v4.runtime.ANTLRErrorListener;
import org.antlr.v4.runtime.CharStream;
import org.antlr.v4.runtime.CommonTokenStream;
import org.antlr.v4.runtime.IntStream;
import org.antlr.v4.runtime.Lexer;
import org.antlr.v4.runtime.NoViableAltException;
import org.antlr.v4.runtime.Parser;
import org.antlr.v4.runtime.ParserRuleContext;
import org.antlr.v4.runtime.RecognitionException;
import org.antlr.v4.runtime.Recognizer;
import org.antlr.v4.runtime.Token;
import org.antlr.v4.runtime.atn.ATNConfigSet;
import org.antlr.v4.runtime.dfa.DFA;
import org.antlr.v4.runtime.tree.ErrorNode;
import org.antlr.v4.runtime.tree.ParseTree;

public class SQLServerParserWalkerListener
extends TSqlParserBaseListener
implements ANTLRErrorListener {
    private final List<ErrorNode> errors = new ArrayList<ErrorNode>();
    private final List<ParseError> sqlErrors = Collections.synchronizedList(new ArrayList());
    int errorCount = 0;

    public void reset() {
        this.errors.clear();
        this.sqlErrors.clear();
        this.errorCount = 0;
    }

    public void visitErrorNode(ErrorNode node) {
        this.errors.add(node);
    }

    public List<ParseError> getSqlErrors() {
        return this.sqlErrors;
    }

    public void enterUnfinished_alias(TSqlParser.Unfinished_aliasContext ctx) {
        this.error((ParserRuleContext)ctx, "Unfinished alias");
    }

    public void enterInsert_column_list(TSqlParser.Insert_column_listContext ctx) {
        if (ctx.insert_cols == null) {
            this.error((ParserRuleContext)ctx, "Need to specify at least one column");
        }
    }

    public void enterJoin_on(TSqlParser.Join_onContext ctx) {
        if (ctx.cond == null) {
            this.error((ParserRuleContext)ctx, "Unfinished join condition");
        }
    }

    public void enterExecute_statement_arg(TSqlParser.Execute_statement_argContext ctx) {
        if (ctx.trailer != null) {
            this.error((ParserRuleContext)ctx, "Trailing comma");
        }
    }

    public void enterAsterisk(TSqlParser.AsteriskContext ctx) {
        if (ctx.alias == null && ctx.table_name() != null) {
            this.error((ParserRuleContext)ctx, "Unfinished alias");
        }
    }

    public void enterPredicate(TSqlParser.PredicateContext ctx) {
        TSqlParser.Comparison_operatorContext op = ctx.comparison_operator();
        List ls = ctx.expression();
        if (op != null && ls != null && ls.size() == 2) {
            if (SQLServerParserWalkerListener.fastCompareExpressions((TSqlParser.ExpressionContext)ls.get(0), (TSqlParser.ExpressionContext)ls.get(1))) {
                this.warning((ParserRuleContext)ctx, "Same expression on both sides", true);
            } else if (((TSqlParser.ExpressionContext)ls.get(1)).getChildCount() == 1 && "NULL".equalsIgnoreCase(((TSqlParser.ExpressionContext)ls.get(1)).getChild(0).getText()) || ((TSqlParser.ExpressionContext)ls.get(0)).getChildCount() == 1 && "NULL".equalsIgnoreCase(((TSqlParser.ExpressionContext)ls.get(0)).getChild(0).getText())) {
                this.warning((ParserRuleContext)ctx, "NULL can never be compared to anything", true);
            }
        }
    }

    private static boolean fastCompareExpressions(TSqlParser.ExpressionContext ex1, TSqlParser.ExpressionContext ex2) {
        if (ex1 == null || ex2 == null) {
            return false;
        }
        if (ex1.getChildCount() != ex2.getChildCount()) {
            return false;
        }
        int i = 0;
        while (i < ex1.getChildCount()) {
            ParseTree t2;
            ParseTree t = ex1.getChild(i);
            if (t != (t2 = ex2.getChild(i))) {
                if (t == null && t2 != null || t2 == null && t != null) {
                    return false;
                }
                if (t.getClass() != t2.getClass()) {
                    return false;
                }
                if (!t.getText().equalsIgnoreCase(t2.getText())) {
                    return false;
                }
            }
            ++i;
        }
        return true;
    }

    public void enterBlock_statement(TSqlParser.Block_statementContext ctx) {
        if (ctx.sql_clauses().size() == 0) {
            this.error((ParserRuleContext)ctx, "Block statement must contain a clause");
        }
    }

    public void enterUnfinished_set_element(TSqlParser.Unfinished_set_elementContext ctx) {
        this.error((ParserRuleContext)ctx, "Unfinished set element");
    }

    public void enterUnpivot(TSqlParser.UnpivotContext ctx) {
        if (ctx.as_table_alias() == null || ctx.as_table_alias().table_alias() == null) {
            this.error((ParserRuleContext)ctx, "Alias is required for unpivots");
        }
    }

    public void enterPivot(TSqlParser.PivotContext ctx) {
        if (ctx.as_table_alias() == null || ctx.as_table_alias().table_alias() == null) {
            this.error((ParserRuleContext)ctx, "Alias is required for pivots");
        }
    }

    public void enterDerived_table_source(TSqlParser.Derived_table_sourceContext ctx) {
        if (ctx.as_table_alias_without_hints() == null || ctx.as_table_alias_without_hints().id() == null) {
            this.error((ParserRuleContext)ctx, "Alias is required for subqueries");
        }
    }

    public void enterXml_nodes_source(TSqlParser.Xml_nodes_sourceContext ctx) {
        if (ctx.as_table_alias_without_hints() == null) {
            this.error((ParserRuleContext)ctx, "Nodes call must have a table alias");
        }
        if (ctx.column_alias_list() == null) {
            this.error((ParserRuleContext)ctx, "Nodes call must have a column alias");
        }
    }

    public void enterUpdate_statement(TSqlParser.Update_statementContext ctx) {
        if (ctx.ddl_object() == null && ctx.rowset_function_limited() == null) {
            this.error((ParserRuleContext)ctx, "Target table / alias must be specified");
        }
    }

    private void warning(ParserRuleContext ctx, String errorMessage, boolean wholeCtx) {
        Token t = ctx.stop;
        ParseError e2 = new ParseError(ctx.getStart().getLine(), wholeCtx ? ctx.getStart().getStartIndex() : t.getStartIndex(), ctx.getStop().getStopIndex(), errorMessage, true);
        this.sqlErrors.add(e2);
    }

    private void error(ParserRuleContext ctx, String errorMessage, boolean wholeCtx) {
        Token t = ctx.stop;
        ParseError e2 = new ParseError(ctx.getStart().getLine(), wholeCtx ? ctx.getStart().getStartIndex() : t.getStartIndex(), ctx.getStop().getStopIndex(), errorMessage);
        this.sqlErrors.add(e2);
    }

    private void error(ParserRuleContext ctx, String errorMessage) {
        this.error(ctx, errorMessage, false);
    }

    public void enterUnfinished_predicate(TSqlParser.Unfinished_predicateContext ctx) {
        this.error((ParserRuleContext)ctx, "Unfinished predicate");
    }

    public void enterUnfinished_search_condition(TSqlParser.Unfinished_search_conditionContext ctx) {
        this.error((ParserRuleContext)ctx, "Unfinished condition");
    }

    public void syntaxError(Recognizer<?, ?> recognizer, Object offendingSymbol, int line, int charPositionInLine, String msg, RecognitionException e) {
        List stack;
        if (this.errorCount == 101) {
            return;
        }
        ++this.errorCount;
        boolean isRecognitionUnclosedException = e instanceof ErrorBlockElementsUnfinishedStrategy.RecognitionUnclosedException;
        boolean nonViable = e instanceof NoViableAltException || msg.startsWith("extraneous input");
        String stackMessage = "";
        if (recognizer instanceof Parser && (stack = ((Parser)recognizer).getRuleInvocationStack()).size() > 0) {
            stackMessage = ((String)stack.get(0)).toString();
        }
        Token offendingToken = (Token)offendingSymbol;
        StringBuilder sb = new StringBuilder();
        sb.append("<html>");
        if (!isRecognitionUnclosedException) {
            sb.append(stackMessage).append("[<br>");
        }
        sb.append(msg).append("<br>");
        IntStream stream = recognizer.getInputStream();
        String input = "";
        if (recognizer instanceof Parser) {
            input = ((CommonTokenStream)stream).getTokenSource().getInputStream().toString();
        } else if (recognizer instanceof Lexer) {
            input = ((CharStream)recognizer.getInputStream()).toString();
        }
        String[] lines = input.split("\r\n|\r|\n");
        sb.append("<pre>");
        try {
            sb.append(lines[line - 1]).append(System.lineSeparator());
        }
        catch (Exception exception) {
            // empty catch block
        }
        int i = 0;
        while (i < charPositionInLine) {
            sb.append(" ");
            ++i;
        }
        int start = 0;
        int stop = input.length();
        if (offendingToken != null) {
            start = offendingToken.getStartIndex();
            stop = offendingToken.getStopIndex();
        }
        if (offendingToken != null && offendingToken.getType() == -1 && recognizer instanceof Parser) {
            Parser p = (Parser)recognizer;
            ParserRuleContext ctx = p.getRuleContext();
            offendingToken = ctx.stop != null ? ctx.stop : ctx.start;
            start = ctx.start.getStartIndex();
            line = ctx.start.getLine();
            int n = stop = isRecognitionUnclosedException ? ctx.start.getStopIndex() : input.length();
        }
        if (start >= 0 && stop >= 0 && !isRecognitionUnclosedException) {
            int i2 = start;
            while (i2 <= start + Math.min(1000, stop - start)) {
                sb.append("^");
                ++i2;
            }
        }
        sb.append("</pre>");
        if (!isRecognitionUnclosedException) {
            sb.append("<br>]");
        }
        ParseError e2 = new ParseError(line, start, stop, sb.toString(), false, nonViable, ParseSource.FILE);
        this.sqlErrors.add(e2);
        if (this.errorCount == 100) {
            this.sqlErrors.add(new ParseError(line, start, stop, "Too many errors, parser gives up"));
        }
    }

    public void reportAmbiguity(Parser recognizer, DFA dfa, int startIndex, int stopIndex, boolean exact, BitSet ambigAlts, ATNConfigSet configs) {
    }

    public void reportAttemptingFullContext(Parser recognizer, DFA dfa, int startIndex, int stopIndex, BitSet conflictingAlts, ATNConfigSet configs) {
    }

    public void reportContextSensitivity(Parser recognizer, DFA dfa, int startIndex, int stopIndex, int prediction, ATNConfigSet configs) {
    }
}

