/*
 * Decompiled with CFR 0.152.
 */
package com.sigge.filerunner.sql.sqlserver;

import com.sigge.filerunner.completion.domain.SQLObject;
import com.sigge.filerunner.sql.sqlserver.AProcWalker;
import com.sigge.filerunner.sql.sqlserver.Proc;
import com.sigge.parsql.sql.transform.ISQLToken;

public class ProcInformation
extends AProcWalker {
    private Proc proc;
    private boolean procBailed;
    private boolean performThis = true;
    private int state = 0;
    private boolean hasCreateTable = false;
    private final String definition;
    private SQLObject object;

    public ProcInformation(Proc p, String def, SQLObject proc2) {
        this.proc = p;
        this.definition = def;
        this.object = proc2;
        if (def.length() < 300000) {
            this.hasCreateTable = this.performThis = def.matches("(?i)(?s).*create.*table.*#.*exec.*");
            this.performThis = false;
        }
    }

    @Override
    public Boolean apply(ISQLToken t, String u) {
        boolean res;
        boolean bl = res = !this.procBailed && !(this.procBailed = this.proc.apply(t, u).booleanValue());
        if (res) {
            return res;
        }
        if (!this.performThis) {
            return false;
        }
        String token = u.substring(t.getStart(), t.getEnd() + 1);
        switch (this.state) {
            case 0: {
                if (!this.matches(token, "CREATE")) break;
                this.state = 1;
                break;
            }
            case 1: {
                if (this.matches(token, "TABLE")) {
                    this.hasCreateTable = true;
                    return false;
                }
                this.state = 0;
            }
        }
        return true;
    }

    public Proc getDefaults() {
        return this.proc;
    }

    public boolean isHasCreateTable() {
        return this.hasCreateTable;
    }

    public String getDefinition() {
        return this.definition;
    }

    public SQLObject getProcedureObject() {
        return this.object;
    }
}

