/*
 * Decompiled with CFR 0.152.
 */
package com.sigge.filerunner.sql.sqlserver;

import com.sigge.filerunner.sql.sqlserver.CaretPosition;
import com.sigge.filerunner.sql.transform.Batch;
import com.sigge.filerunner.sql.transform.Clause;
import com.sigge.filerunner.sql.transform.ClauseHolder;
import com.sigge.filerunner.sql.transform.SQLFile;
import com.sigge.filerunner.sql.transform.Scope;
import com.siggemannen.core.Tuple;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Stack;
import org.antlr.v4.runtime.CharStream;
import org.antlr.v4.runtime.ParserRuleContext;
import org.antlr.v4.runtime.Token;
import org.antlr.v4.runtime.misc.Interval;
import org.antlr.v4.runtime.tree.ParseTree;
import org.antlr.v4.runtime.tree.TerminalNode;

public class ClauseUtility {
    public static Clause findNearestStatement(int position, ClauseHolder file) {
        Clause cecs = null;
        cecs = ClauseUtility.findNearest(file, position, -1);
        return cecs;
    }

    private static Clause findNearest(ClauseHolder ch, int position, int pos) {
        Clause cecs = null;
        int lastIndex = pos;
        boolean found = false;
        for (Clause c : ch.getClauses()) {
            if (c == null) continue;
            ParserRuleContext context = c.getContext();
            if (c instanceof ClauseHolder) {
                Clause cecs2 = ClauseUtility.findNearest((ClauseHolder)c, position, lastIndex);
                if (cecs2 != null) {
                    cecs = cecs2;
                    continue;
                }
                if (position > 0 && (context == null || context.getStart() == null || context.getStart().getStartIndex() >= position) || context.getStart().getStartIndex() <= lastIndex) continue;
                lastIndex = context.getStart().getStartIndex();
                cecs = c;
                found = true;
                continue;
            }
            if ((position <= 0 || context != null && context.getStart() != null && context.getStart().getStartIndex() < position) && context.getStart().getStartIndex() > lastIndex) {
                lastIndex = context.getStart().getStartIndex();
                cecs = c;
                found = true;
                continue;
            }
            if (!found) continue;
            break;
        }
        return cecs;
    }

    public static List<Tuple<Clause, ParserRuleContext>> getClauses(Scope c, int position, boolean includeParents, Class ... clazz) {
        return ClauseUtility.getClauses(c, position, includeParents, false, clazz);
    }

    public static List<Tuple<Clause, ParserRuleContext>> getClauses(Scope c, int position, boolean includeParents, boolean includePositionWithin, Class ... clazz) {
        ArrayList<Tuple<Clause, ParserRuleContext>> lc = new ArrayList<Tuple<Clause, ParserRuleContext>>();
        ArrayList<Scope> scopes = new ArrayList<Scope>();
        scopes.add(c);
        if (includeParents) {
            Scope p;
            Scope scope = p = c instanceof Batch ? c : c.getParent();
            if (p != null && p instanceof Batch) {
                Batch b = (Batch)p;
                while ((b = b.getPreviousBatch()) != null) {
                    scopes.add(b);
                }
            }
            Collections.reverse(scopes);
        }
        for (Scope s : scopes) {
            ClauseUtility.populateClauses(s, Arrays.asList(clazz), position, lc, includePositionWithin);
        }
        return lc;
    }

    private static void populateClauses(ClauseHolder c, List<Class> clazzes, int position, List<Tuple<Clause, ParserRuleContext>> lc, boolean includePositionWithin) {
        for (Clause clause : c.getClauses()) {
            if (clause == null) continue;
            ClauseUtility.getClausesFromClause(clazzes, position, lc, clause, includePositionWithin);
            if (!(clause instanceof ClauseHolder)) continue;
            ClauseUtility.populateClauses((ClauseHolder)clause, clazzes, position, lc, includePositionWithin);
        }
    }

    private static void getClausesFromClause(List<Class> clazzes, int position, List<Tuple<Clause, ParserRuleContext>> lc, Clause clause, boolean includePositionWithin) {
        if (clause.getContext() != null && (ClauseUtility.contextBeforeBounds(clause.getContext(), position) || includePositionWithin && ClauseUtility.contextWithinBounds(clause.getContext(), position))) {
            for (Class clazz : clazzes) {
                ParserRuleContext ruleContext;
                if (clause.getContext().getClass().equals(clazz)) {
                    lc.add((Tuple<Clause, ParserRuleContext>)Tuple.of((Object)clause, (Object)clause.getContext()));
                }
                if ((ruleContext = clause.getContext().getRuleContext(clazz, 0)) == null) continue;
                lc.add((Tuple<Clause, ParserRuleContext>)Tuple.of((Object)clause, (Object)ruleContext));
                break;
            }
        }
    }

    public static boolean contextBeforeBounds(ParserRuleContext prc, int position) {
        return prc.getStart().getStartIndex() <= position && prc.getStop() != null && prc.getStop().getStopIndex() <= position;
    }

    public static boolean contextWithinBounds(ParserRuleContext prc, int position) {
        return prc.getStart().getStartIndex() <= position && prc.getStop() != null && prc.getStop().getStopIndex() >= position;
    }

    public static Clause findOuterest(SQLFile file, CaretPosition position) {
        Clause cecs = null;
        cecs = ClauseUtility.findOuterest((ClauseHolder)file, position);
        return cecs;
    }

    private static Clause findOuterest(ClauseHolder ch, CaretPosition position) {
        for (Clause c : ch.getClauses()) {
            if (c.getContext().getStart().getStartIndex() >= position.getIndex() || c.getContext().getStop().getStopIndex() < position.getIndex()) continue;
            if (c instanceof ClauseHolder) {
                return ClauseUtility.findOuterest((ClauseHolder)c, position);
            }
            return c;
        }
        return ch;
    }

    public static boolean matchesParam(ParserRuleContext ctx, int position) {
        return ctx != null && ctx.start.getStartIndex() <= position && (ctx.stop == null || ctx.stop.getStopIndex() + 1 < position);
    }

    public static boolean matchesParam2(ParserRuleContext ctx, int position) {
        return ctx != null && ctx.start.getStartIndex() <= position;
    }

    public static boolean isRulePartOfRule(ParserRuleContext rule, Integer ... rules) {
        return ClauseUtility.isRulePartOfRule(rule, Arrays.asList(rules));
    }

    public static boolean isRulePartOfRule(ParserRuleContext rule, List<Integer> rules) {
        if (rule == null) {
            return false;
        }
        if (rules.contains(rule.getRuleIndex())) {
            return true;
        }
        return ClauseUtility.isRulePartOfRule(rule.getParent(), rules);
    }

    public static ParserRuleContext getRulePartOfRule(ParserRuleContext rule, Integer ... rules) {
        return ClauseUtility.getRulePartOfRule(rule, Arrays.asList(rules));
    }

    public static ParserRuleContext getRulePartOfRule(ParserRuleContext rule, List<Integer> rules) {
        if (rule == null) {
            return rule;
        }
        if (rules.contains(rule.getRuleIndex())) {
            return rule;
        }
        return ClauseUtility.getRulePartOfRule(rule.getParent(), rules);
    }

    public static void walk(ClauseHolder sf, TriFunction<Clause, Clause, Integer, Boolean> walker) {
        Stack<Integer> levels = new Stack<Integer>();
        levels.add(0);
        ClauseUtility.walk(sf, walker, levels);
    }

    private static void walk(ClauseHolder sf, TriFunction<Clause, Clause, Integer, Boolean> walker, Stack<Integer> levels) {
        for (Clause cx : sf.getClauses()) {
            if (cx instanceof Scope) {
                levels.add(levels.peek() + 1);
            }
            if (!walker.apply(cx, sf, levels.peek()).booleanValue()) {
                return;
            }
            if (cx instanceof ClauseHolder) {
                ClauseUtility.walk((ClauseHolder)cx, walker, levels);
            }
            if (!(cx instanceof Scope)) continue;
            levels.pop();
        }
    }

    public static StringBuilder getExpressionTree(ParseTree pr) {
        StringBuilder sb = new StringBuilder();
        ClauseUtility.printExpressionTree(pr, sb, Integer.MAX_VALUE);
        return sb;
    }

    private static int printExpressionTree(ParseTree pr, StringBuilder sb, int end) {
        if (pr == null) {
            return end;
        }
        for (int i = 0; i < pr.getChildCount(); ++i) {
            ParseTree pt = pr.getChild(i);
            if (pt instanceof TerminalNode) {
                Token t = (Token)pt.getPayload();
                if (t.getStartIndex() < 0 || t.getStopIndex() < 0) continue;
                String text = t.getInputStream().getText(new Interval(t.getStartIndex(), t.getStopIndex()));
                if (t.getStartIndex() > end && text.matches(".*[^0-9()].*")) {
                    sb.append(" ");
                }
                sb.append(text);
                end = t.getStopIndex();
                continue;
            }
            end = ClauseUtility.printExpressionTree(pt, sb, end);
        }
        return end;
    }

    public static String getTokenLoad(ParseTree pt, int start, int end) {
        Object obj = pt.getPayload();
        CharStream cs = null;
        if (obj instanceof Token) {
            cs = ((Token)obj).getInputStream();
        } else if (obj instanceof ParserRuleContext) {
            cs = ((ParserRuleContext)obj).getStart().getInputStream();
        }
        if (cs != null) {
            return cs.getText(new Interval(start, end));
        }
        return null;
    }

    @FunctionalInterface
    public static interface TriFunction<A, B, C, R> {
        public R apply(A var1, B var2, C var3);
    }
}

