/*
 * Decompiled with CFR 0.152.
 */
package com.sigge.filerunner.sql.mysql;

import com.google.inject.Singleton;
import com.mysql.cj.conf.ConnectionUrl;
import com.sigge.dbrunner.Database;
import com.sigge.dbrunner.DatabaseServerConfig;
import com.sigge.dbrunner.mysql.MySQLDatabase;
import com.sigge.filerunner.config.ConfigHandler;
import com.sigge.filerunner.core.Encrypter;
import com.sigge.filerunner.core.StringUtils;
import com.sigge.filerunner.sql.DatabaseManager;
import com.sigge.filerunner.sql.DatabaseNeutralContext;
import com.sigge.filerunner.sql.DatabaseNeutralServerContext;
import com.sigge.filerunner.sql.IDatabaseContextOperator;
import com.sigge.filerunner.sql.IServerContext;

@Singleton
public class MysqlDatabaseCreator
implements IDatabaseContextOperator {
    @Override
    public Database create(DatabaseServerConfig db) {
        if (!this.isValid(db)) {
            return null;
        }
        String password = db.getPassword();
        if (ConfigHandler.getConfig().isEncryptedData()) {
            try {
                password = Encrypter.decrypt(password, DatabaseManager.getKeypass());
            }
            catch (Exception e) {
                throw new RuntimeException("Couldn't decode key", e);
            }
        }
        MySQLDatabase d = new MySQLDatabase(db);
        return d;
    }

    @Override
    public boolean isValid(DatabaseServerConfig db) {
        if (db.getUrl() != null && db.getUrl().length() > 0) {
            return ConnectionUrl.acceptsUrl((String)db.getUrl());
        }
        return !StringUtils.isEmpty(db.getServer()) && (!StringUtils.isEmpty(db.getUser()) || db.getUseAD() != false);
    }

    @Override
    public IServerContext createContext(Database database) {
        return new DatabaseNeutralServerContext(database, DatabaseNeutralContext::new);
    }
}

