/*
 * Decompiled with CFR 0.152.
 */
package com.sigge.filerunner.sql.edit;

import com.sigge.filerunner.completion.domain.SQLObject;
import com.sigge.filerunner.completion.domain.SQLObjectType;
import com.sigge.filerunner.sql.DatabaseContext;
import com.sigge.filerunner.sql.IServerContext;
import com.sigge.filerunner.sql.edit.ColumnPlace;
import com.sigge.filerunner.sql.edit.ISQLColumnTableListener;
import com.sigge.filerunner.sql.edit.InsertHolder;
import com.sigge.filerunner.sql.edit.ParsingContext;
import com.sigge.filerunner.sql.edit.SQLService;
import com.sigge.filerunner.sql.sqlserver.SelectColumnsHolder;
import com.sigge.filerunner.sql.transform.dml.SelectColumn;
import com.sigge.filerunner.sql.transform.expression.Expression;
import com.sigge.filerunner.sql.transform.expression.SQLName;
import com.sigge.filerunner.sql.transform.select.source.TableValues;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.antlr.v4.runtime.ParserRuleContext;
import org.antlr.v4.runtime.Token;

public class SQLServerUtils {
    public static void validateInsert(IServerContext serverContext, DatabaseContext context, InsertHolder holder, ParsingContext parseContext, ISQLColumnTableListener listener, SQLService service) {
        int size;
        Optional<SelectColumnsHolder> hh;
        ArrayList sc = new ArrayList();
        String fullname = null;
        if (holder.getTarget().getTable() != null) {
            fullname = holder.getTarget().getTable().fullName();
        } else if (holder.getTarget().getTableVariable() != null) {
            fullname = holder.getTarget().getTableVariable().getTerminal();
        }
        if (fullname == null) {
            return;
        }
        List<SQLObject> obj = service.getObjectFromName(serverContext, context, fullname, parseContext, Optional.ofNullable(listener), new SQLObjectType[0]);
        if (obj.size() == 0 && !(hh = service.findHolderFromTableOrAlias(holder.getHolder(), fullname, ColumnPlace.NORMAL, parseContext)).isPresent()) {
            Token context2 = holder.getTarget().getStartToken().get();
            listener.acceptMessage(context2, "Insert target " + fullname + " not found", false);
        }
        sc.addAll(obj.stream().map(SQLObject::getColumns).flatMap(Collection::stream).map(so -> so.getName()).collect(Collectors.toList()));
        for (SQLName sn : holder.getInsertColumns()) {
            boolean found = false;
            for (String s : sc) {
                if (!context.isSameIdentifier(s, sn.getName())) continue;
                found = true;
                break;
            }
            if (found) continue;
            listener.acceptUnresolvedColumn((ParserRuleContext)sn.getTokenSource());
        }
        int sizeWithoutIdentity = size = holder.getInsertColumns().size();
        if (size == 0 && obj.size() > 0) {
            size = obj.get(0).getColumns().size();
            sizeWithoutIdentity = (int)obj.get(0).getColumns().stream().filter(f -> f.getCustomProperty("COLUMN_IDENTITY", false) == false).count();
        }
        switch (holder.getSelectColumns().getType()) {
            case DEFAULT_VALUES: {
                return;
            }
            case EXEC: {
                return;
            }
            case NORMAL: {
                Optional<Token> startToken;
                String errorMessage;
                int selectColumnsSize = 0;
                int i = 0;
                while (i < holder.getSelectColumns().getColumns().size()) {
                    SelectColumn col = holder.getSelectColumns().getColumns().get(i);
                    selectColumnsSize = col.isAllStar() ? (selectColumnsSize += size) : ++selectColumnsSize;
                    ++i;
                }
                if (selectColumnsSize <= 0 || size <= 0) break;
                String string = selectColumnsSize > size ? "Number of select columns (" + selectColumnsSize + ") is larger than number of target columns (" + size + ")" : (errorMessage = selectColumnsSize < sizeWithoutIdentity ? "Number of select columns (" + selectColumnsSize + ") is lesser than number of target columns (" + sizeWithoutIdentity + ")" : null);
                if (errorMessage == null || !(startToken = SQLServerUtils.getFirstTokenFromInsertList(holder)).isPresent()) break;
                listener.acceptMessage(startToken.get(), errorMessage, false);
                break;
            }
            case VALUES: {
                String errorMessage;
                TableValues tv = holder.getSelectColumns().getTableValues().orElse(null);
                if (tv == null) {
                    return;
                }
                HashSet<Integer> expSizes = new HashSet<Integer>();
                for (List<Expression> exps : tv.getValues()) {
                    service.innerExpression(exps, holder.getHolder(), parseContext, listener, null);
                    expSizes.add(exps.size());
                }
                if (expSizes.size() == 0) {
                    return;
                }
                int tvSize = (Integer)expSizes.stream().findFirst().get();
                if (tvSize <= 0 || size <= 0) break;
                String string = tvSize > size ? "Number of select columns (" + tvSize + ") is larger than number of target columns (" + size + ")" : (errorMessage = tvSize < size ? "Number of select columns (" + tvSize + ") is lesser than number of target columns (" + size + ")" : null);
                if (errorMessage == null) break;
                if (holder.getInsertColumns().size() > 0) {
                    Optional<Token> startToken = SQLServerUtils.getFirstTokenFromInsertList(holder);
                    if (!startToken.isPresent()) break;
                    listener.acceptMessage(startToken.get(), errorMessage, false);
                    break;
                }
                listener.acceptMessage(tv.getStartToken().get(), errorMessage, false);
            }
        }
    }

    public static Optional<Token> getFirstTokenFromInsertList(InsertHolder holder) {
        Optional<Token> startToken = Optional.empty();
        if (holder.getInsertColumns().size() > 0) {
            startToken = holder.getInsertColumns().get(0).getStartToken();
        } else if (holder.getInsertType() == InsertHolder.InsertType.OUTPUT_INSERT && holder.getTarget() != null) {
            startToken = holder.getTarget().getStartToken();
        } else if (holder.getHolder().getContext().start != null) {
            startToken = Optional.of(holder.getHolder().getContext().start);
        }
        return startToken;
    }
}

