/*
 * Decompiled with CFR 0.152.
 */
package com.sigge.filerunner.sql.edit;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import com.sigge.filerunner.completion.ADBCompletionProvider;
import com.sigge.filerunner.completion.domain.SQLObject;
import com.sigge.filerunner.core.TaskTrigger;
import com.sigge.filerunner.sql.CancellableCallback;
import com.sigge.filerunner.sql.DatabaseContext;
import com.sigge.filerunner.sql.IServerContext;
import com.sigge.filerunner.sql.SQLManager;
import com.sigge.filerunner.sql.ServerDatabase;
import com.sigge.filerunner.sql.edit.IEditor;
import com.sigge.filerunner.sql.edit.IParseResult;
import com.sigge.filerunner.sql.edit.ISQLColumnTableListener;
import com.sigge.filerunner.sql.edit.ParseError;
import com.sigge.filerunner.sql.edit.ParsingContext;
import com.sigge.filerunner.sql.edit.SQLService;
import com.sigge.filerunner.sql.edit.SQLTableListener;
import com.sigge.filerunner.sql.sqlserver.ClauseUtility;
import com.sigge.filerunner.sql.sqlserver.ColumnFrom;
import com.sigge.filerunner.sql.sqlserver.SQLServerParserWalkerListener;
import com.sigge.filerunner.sql.sqlserver.SQLServerSQLService;
import com.sigge.filerunner.sql.sqlserver.SelectColumnsHolder;
import com.sigge.filerunner.sql.sqlserver.parser.SQLRuleVisitor;
import com.sigge.filerunner.sql.transform.Batch;
import com.sigge.filerunner.sql.transform.Clause;
import com.sigge.filerunner.sql.transform.ClauseHolder;
import com.sigge.filerunner.sql.transform.SQLFile;
import com.sigge.filerunner.sql.transform.declare.Declare;
import com.sigge.filerunner.sql.transform.declare.DeclareBlock;
import com.sigge.filerunner.sql.transform.expression.ColumnNameExpression;
import com.sigge.filerunner.sql.transform.expression.Expression;
import com.sigge.filerunner.sql.transform.expression.FullExpression;
import com.sigge.filerunner.view.changedb.ChangeDatabaseListener;
import com.sigge.filerunner.view.runners.IRunningState;
import com.sigge.filerunner.view.runners.SQLScriptState;
import com.sigge.filerunner.view.tabs.TabContent;
import com.siggemannen.binding.ADocumentAdapter;
import com.siggemannen.core.Tuple;
import com.siggemannen.functional.throwing.ThrowingConsumer;
import com.siggemannen.sql.antler.CaseChangingCharStreamUpper;
import com.siggemannen.sql.antler.ErrorBlockElementsUnfinishedStrategy;
import com.siggemannen.sql.antler.TSqlLexer;
import com.siggemannen.sql.antler.TSqlParser;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.Element;
import org.antlr.v4.runtime.ANTLRErrorListener;
import org.antlr.v4.runtime.ANTLRErrorStrategy;
import org.antlr.v4.runtime.CharStream;
import org.antlr.v4.runtime.CharStreams;
import org.antlr.v4.runtime.CodePointCharStream;
import org.antlr.v4.runtime.CommonTokenStream;
import org.antlr.v4.runtime.IntStream;
import org.antlr.v4.runtime.Token;
import org.antlr.v4.runtime.TokenSource;
import org.antlr.v4.runtime.TokenStream;
import org.antlr.v4.runtime.atn.ParserATNSimulator;
import org.antlr.v4.runtime.atn.PredictionMode;
import org.antlr.v4.runtime.misc.Interval;
import org.antlr.v4.runtime.tree.ParseTree;
import org.antlr.v4.runtime.tree.ParseTreeListener;
import org.antlr.v4.runtime.tree.ParseTreeWalker;
import org.fife.ui.rsyntaxtextarea.RSyntaxTextArea;
import org.fife.ui.rsyntaxtextarea.folding.Fold;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class ParserEditor
implements IEditor {
    private static final Map<RSyntaxTextArea, EditorState> STATE = new ConcurrentHashMap<RSyntaxTextArea, EditorState>();
    private final ScheduledExecutorService SCHEDULED_THREAD_POOL = Executors.newScheduledThreadPool(3);
    private static final Logger LOGGER = LoggerFactory.getLogger(ParserEditor.class);
    private boolean onInit = true;
    private final IRunningState reporter;
    private final SQLManager manager;

    @Inject
    public ParserEditor(IRunningState reporter, SQLManager manager) {
        this.reporter = reporter;
        this.manager = manager;
    }

    @Override
    public synchronized void register(RSyntaxTextArea textArea, TabContent tabContent) {
        EditorState area = STATE.get(textArea);
        if (area == null) {
            EditorState editorState = new EditorState(textArea, tabContent);
            STATE.put(textArea, editorState);
            textArea.getDocument().addDocumentListener((DocumentListener)((Object)editorState));
        } else if (area.tabContent == null) {
            area.tabContent = tabContent;
        }
    }

    @Override
    public void unregister(RSyntaxTextArea textArea) {
        EditorState s = STATE.remove(textArea);
        if (s != null) {
            textArea.getDocument().removeDocumentListener((DocumentListener)((Object)s));
            this.manager.removeChangeDatabaseListener(s);
        }
    }

    @Override
    public IParseResult parse(RSyntaxTextArea textArea) {
        EditorState s = STATE.get(textArea);
        if (s != null) {
            return s.result;
        }
        this.register(textArea, null);
        return ParserEditor.STATE.get((Object)textArea).result;
    }

    public IParseResult parseNow(RSyntaxTextArea area) {
        IParseResult result = this.parse(area);
        EditorState s = STATE.get(area);
        s.parse();
        return result;
    }

    @Override
    public void setOnInit(boolean onInit) {
        this.onInit = onInit;
    }

    private class EditorState
    extends ADocumentAdapter
    implements ChangeDatabaseListener {
        private boolean called = false;
        RSyntaxTextArea area;
        InternalParseResult result;
        TSqlLexer lt;
        TSqlParser tp;
        private SQLServerParserWalkerListener listener;
        private ScheduledFuture<?> future = null;
        private TabContent tabContent;
        private final TaskTrigger trigger = new TaskTrigger();
        private volatile CancellableCallback callback = null;
        Tuple<Integer, String> lastDatabaseId = null;

        EditorState(RSyntaxTextArea area, TabContent tabContent) {
            this.tabContent = tabContent;
            this.result = new InternalParseResult(this.trigger);
            this.area = area;
            this.initParsers();
            this.trigger.setTriggered();
            ParserEditor.this.manager.addChangeDatabaseListener(this);
            this.reparse(area);
        }

        private void initParsers() {
            this.lt = new TSqlLexer(null);
            this.tp = new TSqlParser(null);
            this.lt.removeErrorListeners();
            this.tp.removeErrorListeners();
            this.tp.setTrace(false);
            this.tp.setProfile(false);
            ((ParserATNSimulator)this.tp.getInterpreter()).setPredictionMode(PredictionMode.SLL);
            this.tp.setBuildParseTree(true);
            this.listener = new SQLServerParserWalkerListener();
            this.lt.addErrorListener((ANTLRErrorListener)this.listener);
            this.tp.addErrorListener((ANTLRErrorListener)this.listener);
        }

        private void reparse(RSyntaxTextArea area) {
            this.scheduleParse();
        }

        private void scheduleParse() {
            if (this.future != null) {
                boolean res = this.future.cancel(true);
                this.initParsers();
            }
            this.future = ParserEditor.this.SCHEDULED_THREAD_POOL.schedule(this::parse, (long)this.getTime(), TimeUnit.MILLISECONDS);
        }

        private void scheduleSecondPass() {
            if (this.future != null) {
                boolean bl = this.future.cancel(true);
            }
            this.future = ParserEditor.this.SCHEDULED_THREAD_POOL.schedule(() -> {
                this.secondPassParse();
                this.scheduleReparse();
            }, (long)this.getTime(), TimeUnit.MILLISECONDS);
        }

        private int getTime() {
            int length = this.area.getDocument().getLength();
            if (ParserEditor.this.onInit) {
                return 2000;
            }
            if (length <= 5000) {
                return 120;
            }
            if (length > 1000000) {
                return 500;
            }
            return 250;
        }

        private void parse() {
            this.trigger.process();
            try {
                TSqlLexer lt2 = this.lt;
                TSqlParser tp2 = this.tp;
                SQLServerParserWalkerListener listener2 = this.listener;
                listener2.reset();
                lt2.removeErrorListeners();
                tp2.removeErrorListeners();
                lt2.addErrorListener((ANTLRErrorListener)listener2);
                tp2.addErrorListener((ANTLRErrorListener)listener2);
                tp2.setErrorHandler((ANTLRErrorStrategy)new ErrorBlockElementsUnfinishedStrategy());
                CodePointCharStream s = CharStreams.fromString((String)this.area.getText());
                CaseChangingCharStreamUpper upper = new CaseChangingCharStreamUpper((CharStream)s);
                lt2.setInputStream((IntStream)upper);
                CommonTokenStream tokens = new CommonTokenStream((TokenSource)lt2);
                tp2.setTokenStream((TokenStream)tokens);
                SQLFile file = (SQLFile)new SQLRuleVisitor().visit((ParseTree)tp2.tsql_file());
                if (Thread.currentThread().isInterrupted()) {
                    this.trigger.reset();
                    return;
                }
                this.result.clauses = file;
                if (file.getContext() != null) {
                    ParseTreeWalker walker = new ParseTreeWalker();
                    walker.walk((ParseTreeListener)listener2, (ParseTree)file.getContext());
                }
                this.result.parseResult = listener2.getSqlErrors();
                this.secondPassParse();
                ArrayList<Fold> folds = new ArrayList<Fold>();
                int foldCount = this.getFolds(folds, null, file, tokens, this.area);
                this.result.folds = foldCount > 1 ? folds : new ArrayList<Fold>();
                this.trigger.reset();
                if (this.result.futureTree != null) {
                    this.result.futureTree.accept((Object)this.result.clauses);
                    this.result.futureTree = null;
                }
                if (this.result.futureFold != null) {
                    this.result.futureFold.accept(this.result.folds);
                    this.result.futureFold = null;
                }
                if (this.result.futureResult != null) {
                    this.result.futureResult.accept(this.result.parseResult);
                    this.result.futureResult = null;
                }
            }
            catch (Exception ex) {
                LOGGER.error("Error terror" + this.area.getDocument().getLength(), (Throwable)ex);
            }
        }

        private void secondPassParse() {
            ParseError e;
            Iterator<ParseError> iterator;
            Tuple<IServerContext, ServerDatabase> ctx = this.getContext();
            IServerContext server = (IServerContext)ctx.first();
            if (server == null || this.result.clauses == null) {
                return;
            }
            ServerDatabase db = (ServerDatabase)ctx.second();
            DatabaseContext dbX = server.getContextForDatabase(db);
            this.callback = new CancellableCallback(() -> {
                this.secondPassParse();
                this.scheduleReparse();
            });
            if (dbX == null || !dbX.isLoaded(this.callback)) {
                return;
            }
            this.lastDatabaseId = SQLManager.getDatabaseIdFromContext(dbX);
            final SQLService ss = new SQLService(server, dbX);
            final SQLTableListener listener = new SQLTableListener(this.result.parseResult, this.callback);
            final HashSet holders = new HashSet();
            boolean isNonViable = false;
            if (this.result.parseResult != null && (iterator = new ArrayList<ParseError>(this.result.parseResult).iterator()).hasNext() && (e = iterator.next()).isNonViableScript()) {
                isNonViable = true;
            }
            final boolean isNonViable2 = isNonViable;
            ClauseUtility.walk(this.result.clauses, new ClauseUtility.TriFunction<Clause, Clause, Integer, Boolean>(){

                @Override
                public Boolean apply(Clause a, Clause b, Integer c) {
                    SelectColumnsHolder parentHolder;
                    if (Thread.interrupted()) {
                        return false;
                    }
                    if (a == null || a.getContext() == null || a.getContext().getStart() == null || a instanceof Batch) {
                        return true;
                    }
                    int startIndex = a.getContext().getStart().getStartIndex();
                    List<SelectColumnsHolder> h = ss.getHolders(a, startIndex);
                    List<SQLObject> declares = ss.getDeclaredObjectsFromPosition(EditorState.this.result.clauses, startIndex, Optional.empty());
                    List<DeclareBlock> variables = SQLServerSQLService.getDeclaredVariables(EditorState.this.result.clauses, startIndex);
                    if (a instanceof Declare) {
                        Map dups = EditorState.this.getDuplicates(((Declare)a).block, variables);
                        for (String key : dups.keySet()) {
                            List dup = (List)dups.get(key);
                            int i = 0;
                            while (i < dup.size()) {
                                DeclareBlock block = (DeclareBlock)dup.get(i);
                                listener.acceptMessage(block.variableToken, "Variable declared multiple times", false);
                                ++i;
                            }
                        }
                    }
                    ParsingContext pxx = new ParsingContext(declares, variables);
                    SelectColumnsHolder selectColumnsHolder = parentHolder = h != null && h.size() > 0 ? h.get(0).getParent() : null;
                    if (h != null) {
                        EditorState.this.processHolderList(ss, listener, h, pxx, holders);
                        if (parentHolder != null) {
                            EditorState.this.processHolderList(ss, listener, parentHolder.getUnions(), pxx, holders);
                        }
                    }
                    if (!(a instanceof Batch) && !isNonViable2) {
                        ss.processClause(a, parentHolder, pxx, listener);
                    }
                    return true;
                }
            });
        }

        private Map<String, List<DeclareBlock>> getDuplicates(List<DeclareBlock> variables, List<DeclareBlock> blocks) {
            HashMap<String, List<DeclareBlock>> result = new HashMap<String, List<DeclareBlock>>();
            HashMap<String, List> existing = new HashMap<String, List>();
            for (DeclareBlock block : blocks) {
                if (block.getVariable() == null) continue;
                existing.computeIfAbsent(block.getVariable().toUpperCase(), f -> new ArrayList()).add(block);
            }
            for (DeclareBlock block : variables) {
                String variable = block.getVariable();
                if (variable == null) continue;
                if ((variable = variable.toUpperCase()) != null && existing.containsKey(variable)) {
                    result.computeIfAbsent(variable, f -> new ArrayList()).add(block);
                }
                existing.computeIfAbsent(variable, f -> new ArrayList()).add(block);
            }
            return result;
        }

        private void scheduleReparse() {
            SwingUtilities.invokeLater(() -> {
                if (this.area.getParserCount() != 0) {
                    this.area.forceReparsing(0);
                } else if (!this.called) {
                    this.called = true;
                    LOGGER.error("For some reason this was called but parser count was 0");
                }
            });
        }

        private void processHolderList(SQLService ss, ISQLColumnTableListener listener, List<SelectColumnsHolder> holders, ParsingContext parsingContext, Set<SelectColumnsHolder> alreadyProcessed) {
            HashSet names = new HashSet();
            HashSet<String> namesCTEs = new HashSet<String>();
            for (SelectColumnsHolder hh : holders) {
                HashSet<String> toCheck;
                if (alreadyProcessed.contains(hh)) continue;
                String fullName = hh.getName();
                String aliasName = hh.getAlias();
                if (aliasName != null) {
                    fullName = aliasName;
                }
                HashSet<String> hashSet = toCheck = hh.isCTE() ? namesCTEs : names;
                if (fullName != null) {
                    if (toCheck.contains(fullName.toLowerCase())) {
                        listener.acceptErrorMessage(null, hh.getContext(), "Duplicated " + (hh.isCTE() ? "correlation" : "cte") + " name: " + fullName, false);
                    } else {
                        toCheck.add(fullName.toLowerCase());
                    }
                }
                this.processHolder(ss, listener, alreadyProcessed, parsingContext, hh);
                List<SelectColumnsHolder> froms = hh.getFroms();
                if (froms != null) {
                    this.processHolderList(ss, listener, froms, parsingContext, alreadyProcessed);
                }
                this.processHolderList(ss, listener, hh.getUnions(), parsingContext, alreadyProcessed);
            }
        }

        private void processHolder(SQLService ss, ISQLColumnTableListener listener, Set<SelectColumnsHolder> holders, ParsingContext parsingContext, SelectColumnsHolder hh) {
            holders.add(hh);
            List<String> cols = ss.getColumns(hh, parsingContext, Optional.of(listener));
            SelectColumnsHolder parent = hh.getParent();
            if (parent != null) {
                if (!holders.contains(parent)) {
                    holders.add(parent);
                    ss.getColumns(parent, parsingContext, Optional.of(listener));
                }
                HashSet<ADBCompletionProvider.Wrapee> wrapees = new HashSet<ADBCompletionProvider.Wrapee>();
                HashSet<String> wrapees2 = new HashSet<String>();
                for (String s : cols) {
                    if (s == null) {
                        System.out.println("Null col for tabcontent: " + this.tabContent);
                        System.out.println(parent.getCols().get(0).isAllStar());
                        System.out.println(parent);
                    }
                    if (wrapees.add(new ADBCompletionProvider.Wrapee(s)) || wrapees2.size() >= 10) continue;
                    wrapees2.add(s);
                }
                if (wrapees2.size() > 0) {
                    String s;
                    s = String.join((CharSequence)",", wrapees2);
                    listener.acceptMessage(hh.getContext().getStart(), "Duplicate columns: " + s, false);
                }
                ArrayList<ColumnFrom> rawColumns = new ArrayList<ColumnFrom>();
                SelectColumnsHolder.getColumns(hh, rawColumns);
                for (ColumnFrom rawColumn : rawColumns) {
                    Expression exp;
                    Expression column;
                    if (rawColumn.getColumn().getAlias() != null || (column = rawColumn.getColumn().getColumn()) == null || !(column instanceof FullExpression)) continue;
                    List<Expression> exps = ((FullExpression)column).unwrap();
                    if (exps.size() > 1) {
                        exps.get(0).getStartToken().ifPresent(tok -> listener.acceptMessage((Token)tok, "Expressions without alias", false));
                        continue;
                    }
                    if (exps.size() <= 0 || (exp = exps.get(0)) instanceof ColumnNameExpression) continue;
                    exp.getStartToken().ifPresent(tok -> listener.acceptMessage((Token)tok, "Expression without alias", false));
                }
            }
        }

        private Tuple<IServerContext, ServerDatabase> getContext() {
            if (this.tabContent != null) {
                try {
                    List<ServerDatabase> currentDatabases;
                    SQLScriptState state = ParserEditor.this.reporter.getCurrentState(this.tabContent);
                    if (state != null && (currentDatabases = state.getCurrentDatabases()).size() > 0) {
                        return Tuple.of((Object)ParserEditor.this.manager.getContextFromDatabase(currentDatabases.get(0)), (Object)currentDatabases.get(0));
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            return Tuple.of((Object)ParserEditor.this.manager.getContextFromDatabase(ParserEditor.this.manager.getCurrent()), (Object)ParserEditor.this.manager.getCurrent());
        }

        private int getFolds(List<Fold> folds, Fold current, Clause clause, CommonTokenStream tokens, RSyntaxTextArea textArea) {
            int foldCount = 0;
            Element el = textArea.getDocument().getDefaultRootElement();
            if (clause != null && clause.getContext().exception == null) {
                Interval sourceInterval = clause.getContext().getSourceInterval();
                try {
                    Token startToken = tokens.get(sourceInterval.a);
                    Token endToken = sourceInterval.b == -1 ? tokens.get(tokens.size() - 1) : tokens.get(sourceInterval.b);
                    if (el.getElementIndex(startToken.getStartIndex()) - el.getElementIndex(endToken.getStopIndex()) < -1) {
                        if (!(clause instanceof SQLFile)) {
                            if (current == null) {
                                current = new Fold(0, textArea, startToken.getStartIndex());
                                current.setEndOffset(endToken.getStopIndex());
                                folds.add(current);
                            } else {
                                Fold cc = current.createChild(0, startToken.getStartIndex());
                                cc.setEndOffset(endToken.getStopIndex());
                                if (clause instanceof ClauseHolder) {
                                    current = cc;
                                }
                            }
                            ++foldCount;
                        }
                        if (clause instanceof ClauseHolder) {
                            for (Clause c : ((ClauseHolder)clause).getClauses()) {
                                foldCount += this.getFolds(folds, current, c, tokens, textArea);
                            }
                        } else {
                            current = null;
                        }
                    }
                }
                catch (BadLocationException e) {
                    LOGGER.error("Bad location while folding, shouldn't happen", (Throwable)e);
                }
            }
            return foldCount;
        }

        protected void setValueFromDocument(DocumentEvent e) {
            if (this.callback != null) {
                this.callback.cancel();
            }
            this.trigger.setTriggered();
            this.reparse(this.area);
        }

        @Override
        public void newDatabase(List<ServerDatabase> sb, ServerDatabase current) {
            if (sb != null && sb.size() > 0) {
                try {
                    Tuple<IServerContext, ServerDatabase> ctx = this.getContext();
                    if (ctx != null && ctx.second() != null && this.lastDatabaseId != null && !this.lastDatabaseId.equals(SQLManager.getDatabaseIdFromContext((ServerDatabase)ctx.second()))) {
                        this.scheduleSecondPass();
                    }
                }
                catch (Exception ex) {
                    LOGGER.error("Error while doing new db", (Throwable)ex);
                }
            }
        }
    }

    class InternalParseResult
    implements IParseResult {
        volatile SQLFile clauses;
        volatile List<Fold> folds;
        volatile List<ParseError> parseResult;
        volatile ThrowingConsumer<ClauseHolder> futureTree;
        volatile ThrowingConsumer<List<Fold>> futureFold;
        volatile ThrowingConsumer<List<ParseError>> futureResult;
        private final TaskTrigger trigger;

        public InternalParseResult(TaskTrigger trigger) {
            this.trigger = trigger;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Optional<ClauseHolder> getParseTree(ThrowingConsumer<ClauseHolder> futureTree) {
            InternalParseResult internalParseResult = this;
            synchronized (internalParseResult) {
                if (this.trigger.isProcessed()) {
                    return Optional.ofNullable(this.clauses);
                }
                if (futureTree != null) {
                    this.futureTree = futureTree;
                }
                return Optional.empty();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Optional<List<Fold>> getFolds(ThrowingConsumer<List<Fold>> futureFold) {
            InternalParseResult internalParseResult = this;
            synchronized (internalParseResult) {
                if (this.trigger.isProcessed()) {
                    return Optional.ofNullable(this.folds);
                }
                if (futureFold != null) {
                    this.futureFold = futureFold;
                }
                return Optional.empty();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Optional<List<ParseError>> getParseResult(ThrowingConsumer<List<ParseError>> futureResult) {
            InternalParseResult internalParseResult = this;
            synchronized (internalParseResult) {
                if (this.trigger.isProcessed()) {
                    return Optional.ofNullable(this.parseResult);
                }
                if (futureResult != null) {
                    this.futureResult = futureResult;
                }
                return Optional.empty();
            }
        }
    }
}

