/*
 * Decompiled with CFR 0.152.
 */
package com.sigge.filerunner.sql.edit;

import com.sigge.filerunner.sql.edit.ParseSource;
import java.util.Objects;

public class ParseError {
    private final int line;
    private final int start;
    private final int end;
    private final String message;
    private final boolean warning;
    private final ParseSource parseSource;
    private final boolean nonViable;

    public ParseError(int line, int start, int end, String message) {
        this(line, start, end, message, false);
    }

    public ParseError(int line, int start, int end, String message, boolean warning) {
        this(line, start, end, message, warning, ParseSource.FILE);
    }

    public ParseError(int line, int start, int end, String message, boolean warning, ParseSource parseSource) {
        this(line, start, end, message, warning, false, parseSource);
    }

    public ParseError(int line, int start, int end, String message, boolean warning, boolean nonViable, ParseSource parseSource) {
        this.line = line;
        this.start = start;
        this.end = end;
        this.message = message;
        this.warning = warning;
        this.nonViable = nonViable;
        this.parseSource = parseSource;
    }

    public int getLine() {
        return this.line;
    }

    public String getMessage() {
        return this.message;
    }

    public String toString() {
        return "Error:" + this.message + ", line:" + this.line + ", char: " + this.getStart() + " end: " + this.getEnd();
    }

    public int getStart() {
        return this.start;
    }

    public int getEnd() {
        return this.end;
    }

    public boolean isWarning() {
        return this.warning;
    }

    public boolean isNonViableScript() {
        return this.nonViable;
    }

    public ParseSource getParseSource() {
        return this.parseSource;
    }

    public int hashCode() {
        return Objects.hash(this.start, this.end);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof ParseError)) {
            return false;
        }
        ParseError other = (ParseError)obj;
        return this.start == other.start && this.end == other.end && Objects.equals(this.message, other.message);
    }
}

