/*
 * Decompiled with CFR 0.152.
 */
package com.sigge.filerunner.sql.edit;

import com.sigge.filerunner.core.StringUtils;
import com.sigge.filerunner.sql.edit.ISQLColumnTableListener;
import com.sigge.filerunner.sql.transform.expression.SQLName;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Stream;

public class ColumnListCheck {
    private final Map<String, List<SQLName>> map = new ConcurrentHashMap<String, List<SQLName>>();

    public ColumnListCheck(List<SQLName> names) {
        for (int i = 0; i < names.size(); ++i) {
            SQLName sn = names.get(i);
            if (!StringUtils.isNotEmpty(sn.getName())) continue;
            this.map.computeIfAbsent(sn.getName().toLowerCase(), f -> new ArrayList()).add(sn);
        }
    }

    public ColumnListCheck(Stream<SQLName> names) {
        names.filter(n -> n != null && StringUtils.isNotEmpty(n.getName())).forEachOrdered(n -> this.map.computeIfAbsent(n.getName().toLowerCase(), f -> new ArrayList()).add(n));
    }

    public void validate(ISQLColumnTableListener listener) {
        for (String key : this.map.keySet()) {
            List<SQLName> names = this.map.get(key);
            for (int i = 0; names.size() > 1 && i < names.size(); ++i) {
                SQLName n = names.get(i);
                if (!n.getStartToken().isPresent()) continue;
                listener.acceptMessage(n.getStartToken().get(), "Duplicate column: " + n.getName(), i == 0);
            }
        }
    }
}

