/*
 * Decompiled with CFR 0.152.
 */
package com.sigge.filerunner.sql;

import com.google.inject.AbstractModule;
import com.google.inject.Binder;
import com.google.inject.TypeLiteral;
import com.google.inject.multibindings.MapBinder;
import com.sigge.filerunner.sql.IDatabaseContextOperator;
import com.sigge.filerunner.sql.db2.DB2DatabaseCreator;
import com.sigge.filerunner.sql.jdbc.JDBCDatabaseCreator;
import com.sigge.filerunner.sql.mysql.MysqlDatabaseCreator;
import com.sigge.filerunner.sql.oracle.OracleDatabaseCreator;
import com.sigge.filerunner.sql.postgres.PostgresDatabaseCreator;
import com.sigge.filerunner.sql.sqlite.SQLiteDatabaseCreator;
import com.sigge.filerunner.sql.sqlserver.SQLServerDatabaseCreator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DatabaseModule
extends AbstractModule {
    private static final Logger LOGGER = LoggerFactory.getLogger(DatabaseModule.class);

    protected void configure() {
        LOGGER.info("start bind");
        this.initDatabaseBinders();
        LOGGER.info("finish bind");
    }

    private void initDatabaseBinders() {
        MapBinder databaseBinder = MapBinder.newMapBinder((Binder)this.binder(), (TypeLiteral)new TypeLiteral<String>(){}, (TypeLiteral)new TypeLiteral<IDatabaseContextOperator>(){});
        databaseBinder.addBinding((Object)"MSSQL").to(SQLServerDatabaseCreator.class);
        databaseBinder.addBinding((Object)"MYSQL").to(MysqlDatabaseCreator.class);
        databaseBinder.addBinding((Object)"ORACLE").to(OracleDatabaseCreator.class);
        databaseBinder.addBinding((Object)"SQLITE").to(SQLiteDatabaseCreator.class);
        databaseBinder.addBinding((Object)"POSTGRES").to(PostgresDatabaseCreator.class);
        databaseBinder.addBinding((Object)"JDBC").to(JDBCDatabaseCreator.class);
        databaseBinder.addBinding((Object)"DB2").to(DB2DatabaseCreator.class);
    }
}

