/*
 * Decompiled with CFR 0.152.
 */
package com.sigge.filerunner.sql;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import com.sigge.dbrunner.Database;
import com.sigge.dbrunner.DatabaseServerConfig;
import com.sigge.filerunner.config.Config;
import com.sigge.filerunner.config.ConfigHandler;
import com.sigge.filerunner.core.Encrypter;
import com.sigge.filerunner.sql.DatabaseFromConfig;
import com.sigge.filerunner.sql.IDatabaseContextOperator;
import com.sigge.filerunner.sql.ServerDatabase;
import com.sigge.filerunner.view.IStatusUpdater;
import com.sigge.filerunner.view.database.RunnerServerConfig;
import com.siggemannen.backgroundrunner.BackgroundRunner;
import com.siggemannen.core.Tuple;
import com.siggemannen.functional.throwing.ThrowingConsumer;
import java.sql.SQLException;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Deque;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreePath;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class DatabaseManager {
    private static List<RunnerServerConfig> serverConfigs = new ArrayList<RunnerServerConfig>();
    private static Map<String, ServerDatabase> lookup1 = new HashMap<String, ServerDatabase>();
    private static Map<String, Tuple<DefaultMutableTreeNode, DefaultMutableTreeNode>> lookup2 = new HashMap<String, Tuple<DefaultMutableTreeNode, DefaultMutableTreeNode>>();
    private static Map<Database, DefaultMutableTreeNode> lookup3 = new HashMap<Database, DefaultMutableTreeNode>();
    private static List<ServerDatabase> serverDatabases = new ArrayList<ServerDatabase>();
    private static List<DatabaseFromConfig> databases = new ArrayList<DatabaseFromConfig>();
    private static final Deque<Runnable> waiters = new ArrayDeque<Runnable>();
    private static DefaultMutableTreeNode treeRoot = new DefaultMutableTreeNode();
    private static String lastErrorMessage = "";
    private static volatile boolean isRunning = true;
    private static char[] keypass = null;
    private final Map<String, IDatabaseContextOperator> dbMap;
    private final IStatusUpdater statusUpdater;
    private static final Logger LOGGER = LoggerFactory.getLogger(DatabaseManager.class);

    @Inject
    public DatabaseManager(Map<String, IDatabaseContextOperator> dbMap, IStatusUpdater statusUpdater) {
        this.dbMap = dbMap;
        this.statusUpdater = statusUpdater;
        LOGGER.debug("Created db manager");
        this.init(dbMap);
    }

    private void init(Map<String, IDatabaseContextOperator> dbMap) {
        for (IDatabaseContextOperator operator : dbMap.values()) {
            operator.initiate();
        }
    }

    public void loadDatabasesFromConfig(ThrowingConsumer<Exception> onError) {
        isRunning = true;
        serverConfigs = DatabaseManager.getConfig().getDatabases();
        keypass = DatabaseManager.getConfig().getKeypass();
        serverDatabases.forEach(s -> s.getDb().closeAllSessions());
        serverDatabases.clear();
        try {
            DatabaseManager.checkEncryption();
        }
        catch (Exception e1) {
            isRunning = false;
            onError.accept((Object)e1);
            return;
        }
        if (serverConfigs != null) {
            new BackgroundRunner(() -> this.generateDatabases(serverConfigs), e -> {
                isRunning = false;
                onError.accept((Object)((Exception)e));
            }).execute();
        } else {
            isRunning = false;
        }
    }

    public List<String> getSupportedProviders() {
        return Collections.unmodifiableList(new ArrayList<String>(this.dbMap.keySet()));
    }

    private static void checkEncryption() throws Exception {
        if (!DatabaseManager.getConfig().isEncryptedData() || serverConfigs == null) {
            return;
        }
        if (keypass == null || keypass.length == 0) {
            throw new Exception("No keypass");
        }
    }

    private static Config getConfig() {
        return ConfigHandler.getConfig();
    }

    public static void decrypt() {
        Config config = ConfigHandler.getConfig();
        config.setDatabases(databases.stream().map(d -> {
            RunnerServerConfig db = new RunnerServerConfig(d.getConfig());
            db.setServerColor(d.getConfig().getServerColor());
            db.setEnabled(d.getConfig().isEnabled());
            return db;
        }).collect(Collectors.toList()));
        config.setEncryptedData(false);
        config.setKeypass(null);
        Arrays.fill(keypass, '\u0000');
        keypass = null;
        ConfigHandler.saveAndIgnoreErrors();
    }

    public static void encrypt(boolean encryptFromConfig) {
        Config config = ConfigHandler.getConfig();
        keypass = config.getKeypass();
        if (!encryptFromConfig) {
            config.setDatabases(databases.stream().map(l -> {
                RunnerServerConfig d = l.getConfig();
                RunnerServerConfig db = new RunnerServerConfig(d);
                try {
                    db.setPassword(d.getPassword().length() > 0 ? Encrypter.encrypt(keypass, d.getPassword()) : d.getPassword());
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
                return db;
            }).collect(Collectors.toList()));
        } else {
            config.setDatabases(config.getDatabases().stream().map(l -> {
                RunnerServerConfig db = new RunnerServerConfig((RunnerServerConfig)l);
                try {
                    db.setPassword(l.getPassword().length() > 0 ? Encrypter.encrypt(keypass, l.getPassword()) : l.getPassword());
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
                return db;
            }).collect(Collectors.toList()));
        }
        keypass = config.getKeypass();
        config.setEncryptedData(true);
        ConfigHandler.saveAndIgnoreErrors();
    }

    public boolean isValid(DatabaseServerConfig config) {
        return this.dbMap.get(config.getDatabaseProvider()).isValid(config);
    }

    private void generateDatabases(List<RunnerServerConfig> servers) throws Exception {
        LOGGER.info("Starting regenerating tables");
        StringBuffer message = new StringBuffer();
        ArrayList<DatabaseFromConfig> dbs = new ArrayList<DatabaseFromConfig>();
        for (RunnerServerConfig ds : servers) {
            if (!ds.isEnabled()) continue;
            dbs.add(this.generateServer(ds));
        }
        databases = dbs;
        treeRoot = new DefaultMutableTreeNode("Servers");
        Object LOCK = new Object();
        HashMap<String, ServerDatabase> lookup1 = new HashMap<String, ServerDatabase>();
        HashMap<String, Tuple<DefaultMutableTreeNode, DefaultMutableTreeNode>> lookup2 = new HashMap<String, Tuple<DefaultMutableTreeNode, DefaultMutableTreeNode>>();
        HashMap<Database, DefaultMutableTreeNode> lookup3 = new HashMap<Database, DefaultMutableTreeNode>();
        databases.parallelStream().forEach(dbx -> {
            Database db = dbx.getDb();
            DefaultMutableTreeNode newChild = new DefaultMutableTreeNode(db);
            Object object2 = LOCK;
            synchronized (object2) {
                treeRoot.add(newChild);
                lookup3.put(db, newChild);
            }
            try {
                object2 = LOCK;
                synchronized (object2) {
                    this.statusUpdater.addMessage("Loading server: " + db.getLabel(), this.getClass().getName(), 60000);
                }
                List<String> databases2 = db.getDatabases();
                Collections.sort(databases2, String.CASE_INSENSITIVE_ORDER);
                for (String database : databases2) {
                    ServerDatabase serverDb = new ServerDatabase((Database)dbx, database);
                    Object object3 = LOCK;
                    synchronized (object3) {
                        DatabaseManager.addNode(newChild, serverDb, lookup1, lookup2);
                    }
                }
            }
            catch (Exception e) {
                if (!(e instanceof SQLException)) {
                    LOGGER.error("Couldn't load database", (Throwable)e);
                } else {
                    LOGGER.debug("Couldn't load database", (Throwable)e);
                }
                message.append("Server:").append(db.getServer()).append(", error:").append(e.getMessage()).append("\n");
                Object object4 = LOCK;
                synchronized (object4) {
                    this.statusUpdater.addMessage("Failed loading " + db.getLabel() + " due to " + e.getMessage(), this.getClass().getName());
                }
            }
        });
        DatabaseManager.lookup1 = lookup1;
        DatabaseManager.lookup2 = lookup2;
        DatabaseManager.lookup3 = lookup3;
        LOGGER.info("Finished regenerating");
        lastErrorMessage = message.toString();
        isRunning = false;
        try {
            try {
                while (true) {
                    waiters.pop().run();
                }
            }
            catch (Exception exception) {
                this.statusUpdater.removeMessage(this.getClass().getName());
            }
        }
        catch (Throwable throwable) {
            this.statusUpdater.removeMessage(this.getClass().getName());
            throw throwable;
        }
    }

    private static void addNode(DefaultMutableTreeNode newChild, ServerDatabase serverDb, Map<String, ServerDatabase> lookup1, Map<String, Tuple<DefaultMutableTreeNode, DefaultMutableTreeNode>> lookup2) {
        DefaultMutableTreeNode databaseChild = new DefaultMutableTreeNode(serverDb);
        newChild.add(databaseChild);
        serverDatabases.add(serverDb);
        lookup2.put(serverDb.getId(), (Tuple<DefaultMutableTreeNode, DefaultMutableTreeNode>)new Tuple((Object)databaseChild, (Object)newChild));
        lookup1.put(serverDb.getId(), serverDb);
    }

    public DatabaseFromConfig generateServer(RunnerServerConfig db) throws Exception {
        return new DatabaseFromConfig(this.dbMap.get(db.getDatabaseProvider()).create(db), db);
    }

    public static DefaultMutableTreeNode getRoot() {
        return treeRoot;
    }

    public static TreePath findDbTreePath(String d) {
        Tuple<DefaultMutableTreeNode, DefaultMutableTreeNode> tuple = lookup2.get(d);
        if (tuple == null) {
            System.err.println("Should never happen");
            return null;
        }
        return new TreePath(((DefaultMutableTreeNode)tuple.first()).getPath());
    }

    public static DefaultMutableTreeNode findNode(String d) {
        Tuple<DefaultMutableTreeNode, DefaultMutableTreeNode> tuple = lookup2.get(d);
        if (tuple == null) {
            System.err.println("Should never happen");
            return null;
        }
        return (DefaultMutableTreeNode)tuple.first();
    }

    public static ServerDatabase findDb(String d) {
        return lookup1.get(d);
    }

    public static String getLastErrorMessage() {
        return lastErrorMessage;
    }

    public static boolean isReady(Runnable callback, Runnable notReadyCallback) {
        if (!isRunning) {
            return true;
        }
        notReadyCallback.run();
        waiters.add(callback);
        return false;
    }

    public static boolean isReady() {
        return !isRunning;
    }

    public static List<ServerDatabase> getServerDatabases() {
        return serverDatabases;
    }

    public static char[] getKeypass() {
        return keypass;
    }

    public static ServerDatabase createDb(ServerDatabase serverDatabase) {
        DefaultMutableTreeNode node = lookup3.get(serverDatabase.getDb());
        if (node != null) {
            for (DatabaseFromConfig dx : databases) {
                if (!dx.getDb().equals(serverDatabase.getDb())) continue;
                ServerDatabase serverDb = new ServerDatabase(dx, serverDatabase.getDatabase());
                DatabaseManager.addNode(node, serverDb, lookup1, lookup2);
                return serverDb;
            }
        }
        return null;
    }
}

