/*
 * Decompiled with CFR 0.152.
 */
package com.sigge.filerunner.sql;

import com.sigge.dbrunner.IScriptRunner;
import com.sigge.dbrunner.SQLOptions;
import com.sigge.filerunner.completion.domain.EntityName;
import com.sigge.filerunner.completion.domain.SQLObject;
import com.sigge.filerunner.completion.domain.SQLObjectType;
import com.sigge.filerunner.core.ProgressReportedAdaptor;
import com.sigge.filerunner.sql.CancellableCallback;
import com.sigge.filerunner.sql.DatabaseContext;
import com.sigge.filerunner.sql.ResultsetConsumer;
import com.sigge.filerunner.sql.ServerDatabase;
import java.io.StringReader;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ADatabaseContext
implements DatabaseContext {
    protected IScriptRunner runner;
    protected List<SQLObject> objects = Collections.emptyList();
    protected List<SQLObject> schemas = Collections.emptyList();
    private volatile boolean isRunning;
    protected volatile boolean loaded;
    protected List<SQLObject> databases = Collections.emptyList();
    protected final ServerDatabase sb;
    protected final ScheduledExecutorService es;
    protected Logger LOGGER = LoggerFactory.getLogger(this.getClass());
    protected boolean closed = false;
    protected List<CancellableCallback> callbacks = Collections.synchronizedList(new ArrayList());
    protected ScheduledFuture<?> lastFuture;

    public ADatabaseContext(ServerDatabase sd) {
        this.sb = sd;
        this.es = Executors.newSingleThreadScheduledExecutor();
    }

    @Override
    public void close() {
        this.closed = true;
        if (this.runner != null) {
            this.runner.closeConnection();
            this.runner = null;
        }
        this.isRunning = false;
        this.es.shutdownNow();
        this.callbacks.clear();
    }

    @Override
    public List<SQLObject> getObjects() {
        return this.objects;
    }

    @Override
    public List<SQLObject> getSchemas() {
        return this.schemas;
    }

    @Override
    public List<SQLObject> getDatabases() {
        return this.databases;
    }

    @Override
    public boolean isLoaded(CancellableCallback callback) {
        if (!this.loaded && callback != null && !this.callbacks.contains(callback)) {
            this.callbacks.add(callback);
        }
        return this.loaded;
    }

    protected void setLoaded() {
        this.loaded = true;
        for (CancellableCallback callback : this.callbacks) {
            if (callback.isCancelled()) continue;
            try {
                callback.run();
            }
            catch (Exception ex) {
                this.LOGGER.error("Callback " + callback + " failed", (Throwable)ex);
            }
        }
        this.callbacks.clear();
    }

    @Override
    public List<SQLObject> getObjects(EntityName entity, boolean fuzzy, SQLObjectType ... types) {
        return null;
    }

    public synchronized void runSQL(String sql, final ResultsetConsumer resultConsumer, SQLOptions so) throws SQLException, Exception {
        if (this.runner == null || !this.runner.isAlive()) {
            if (this.runner != null) {
                this.runner.closeConnection();
            }
            try {
                this.runner = this.createRunner();
                this.isRunning = true;
            }
            catch (Exception ex) {
                this.isRunning = false;
                this.runner = null;
                if (this.logException(ex, "", false)) {
                    this.LOGGER.error("Error while creating runner", (Throwable)ex);
                }
                return;
            }
        }
        try {
            this.runner.runScript(new StringReader(sql), Arrays.asList(new ProgressReportedAdaptor(){
                int prevResults = 0;

                @Override
                public void reportScriptFailure(String command, Statement s, Exception e, boolean result) {
                    if (!ADatabaseContext.this.closed && ADatabaseContext.this.logException(e, command, true)) {
                        ADatabaseContext.this.LOGGER.error("Script run from command \"" + command + "\" failed", (Throwable)e);
                    }
                    ADatabaseContext.this.isRunning = false;
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void reportScriptFinished(String command, Statement s, boolean result) {
                    try {
                        this.prevResults += ADatabaseContext.this.processStatement(s, resultConsumer, this.prevResults);
                    }
                    catch (Exception ex) {
                        if (!ADatabaseContext.this.closed && ADatabaseContext.this.logException(ex, command, true)) {
                            ADatabaseContext.this.LOGGER.error("Processing statement from: " + ADatabaseContext.this + " from command \"" + command + "\" failed", (Throwable)ex);
                        }
                    }
                    catch (Throwable tr) {
                        ADatabaseContext.this.LOGGER.error("Error during subprocessing", tr);
                    }
                    finally {
                        ADatabaseContext.this.isRunning = false;
                    }
                }

                @Override
                public void reportFinished() {
                    ADatabaseContext.this.isRunning = false;
                }
            }), so);
        }
        catch (Exception ex) {
            this.isRunning = false;
            this.LOGGER.error("Error while setting up running", (Throwable)ex);
        }
    }

    protected boolean logException(Exception e, String command, boolean exceptionDuringScriptExecution) {
        return true;
    }

    protected abstract IScriptRunner createRunner() throws SQLException;

    protected int processStatement(Statement s, ResultsetConsumer resultConsumer, int prevResults) throws SQLException {
        int resultSets = 0;
        while (true) {
            ResultSet r = s.getResultSet();
            Throwable throwable = null;
            try {
                if (r == null) {
                    int updateCount = s.getUpdateCount();
                    if (updateCount == -1) break;
                    s.getMoreResults();
                    continue;
                }
                resultConsumer.consume(r, ++resultSets + prevResults);
                s.getMoreResults();
                continue;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (r == null) continue;
                if (throwable != null) {
                    try {
                        r.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                r.close();
                continue;
            }
            break;
        }
        return resultSets;
    }

    @Override
    public boolean isRunning() {
        return this.isRunning;
    }

    @Override
    public ServerDatabase getDatabase() {
        return this.sb;
    }

    public String toString() {
        return this.sb != null ? this.sb.toString() : super.toString();
    }
}

