/*
 * Decompiled with CFR 0.152.
 */
package com.sigge.filerunner.recent;

import com.google.common.collect.Iterators;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import com.google.inject.name.Named;
import com.sigge.filerunner.core.DateUtils;
import com.sigge.filerunner.core.DocumentListenerAdapter;
import com.sigge.filerunner.core.FilterHelper;
import com.sigge.filerunner.core.StoreItem;
import com.sigge.filerunner.recent.ItemStorer;
import com.sigge.filerunner.recent.RecentFilter;
import com.sigge.filerunner.view.DefaultListView;
import com.sigge.filerunner.view.core.JListUtils;
import com.sigge.filerunner.view.core.RowFilterExtension;
import com.sigge.filerunner.view.menu.RecentMenuHandler;
import java.awt.Component;
import java.awt.Frame;
import java.io.File;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.List;
import java.util.Spliterators;
import java.util.function.Consumer;
import java.util.stream.StreamSupport;
import javax.swing.BoundedRangeModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import javax.swing.RowSorter;
import javax.swing.SortOrder;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentListener;
import org.jdesktop.swingx.JXList;
import org.jdesktop.swingx.sort.ListSortController;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class RecentExplorer {
    private static final int MAX_ITEMS = 100;
    private final JFrame mainFrame;
    private final Consumer<File> fileConsumer;
    private final RecentMenuHandler handler;
    private final RowFilterExtension<StoreItem<File>> re = new RowFilterExtension<StoreItem>(500, Comparator.comparing(StoreItem::getTime));
    private boolean itemsFull;
    private static final Logger LOGGER = LoggerFactory.getLogger(RecentExplorer.class);

    @Inject
    public RecentExplorer(@Named(value="mainFrame") JFrame mainFrame, Consumer<File> fileConsumer, RecentMenuHandler handler) {
        this.mainFrame = mainFrame;
        this.fileConsumer = fileConsumer;
        this.handler = handler;
    }

    public void present() {
        DefaultListView jem = new DefaultListView((Frame)this.mainFrame, true, "Recent files", this.getClass().getCanonicalName().replace(".", "-"));
        ItemStorer<File, RecentFilter> storer = this.handler.getStorer();
        storer.resetItems();
        jem.setTextVisible(false);
        List<StoreItem<File>> items = storer.listItems(this.getFilter());
        this.itemsFull = items.size() < 100;
        JXList itemList = jem.getItemList();
        itemList.setSortable(true);
        itemList.setDoubleBuffered(true);
        DefaultListModel<StoreItem<File>> dlm = new DefaultListModel<StoreItem<File>>();
        for (StoreItem<File> file : items) {
            dlm.addElement(file);
        }
        itemList.setModel(dlm);
        itemList.setCellRenderer((ListCellRenderer)new DefaultListCellRenderer(){

            @Override
            public Component getListCellRendererComponent(JList<?> list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                JLabel jl = (JLabel)super.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
                StoreItem file = (StoreItem)value;
                if (file != null) {
                    StringBuilder sb = new StringBuilder("<html>&nbsp;").append(DateUtils.formatLocalDate(file.getTime(), true)).append("&nbsp;-&nbsp;").append(file.getItem());
                    jl.setText(sb.toString());
                }
                return jl;
            }
        });
        LOGGER.debug("items full: {}", (Object)this.itemsFull);
        BoundedRangeModel scrollModel = jem.getListScrollPane().getVerticalScrollBar().getModel();
        scrollModel.addChangeListener(e -> {
            if (!this.itemsFull && !scrollModel.getValueIsAdjusting() && scrollModel.getValue() + scrollModel.getExtent() >= scrollModel.getMaximum() & scrollModel.getValue() > 0) {
                LOGGER.debug("In scroll");
                List listItems = storer.listItems(this.getFilter());
                if (listItems.size() < 100 || listItems.size() == 0) {
                    LOGGER.debug("In scroll: full, items {}", (Object)listItems.size());
                    this.itemsFull = true;
                }
                for (StoreItem item : listItems) {
                    dlm.addElement(item);
                }
                this.filterFromText(jem, false);
            }
        });
        jem.getOpenButton().addActionListener(al -> this.chooseFile((JList)itemList));
        JListUtils.bindArrowsToFilter(jem.getSearchField(), (JComponent)itemList, () -> this.chooseFile((JList)itemList));
        ListSortController sorter = new ListSortController(dlm);
        sorter.setComparator(0, this.re);
        itemList.setRowSorter((RowSorter)sorter);
        sorter.setSortKeys(Arrays.asList(new RowSorter.SortKey(0, SortOrder.DESCENDING)));
        sorter.sort();
        jem.getSearchField().getDocument().addDocumentListener((DocumentListener)((Object)new DocumentListenerAdapter(() -> this.filterFromText(jem))));
        this.filterFromText(jem);
        jem.getItemDetail().setText("No preview available");
        jem.getItemDetail().setEditable(false);
        SwingUtilities.invokeLater(() -> {
            boolean bl = jem.getSearchField().requestFocusInWindow();
        });
        jem.setVisible(true);
    }

    private RecentFilter getFilter() {
        return RecentFilter.create().setOnlyLastFile(true).setMaxItems(100);
    }

    private void filterFromText(DefaultListView view) {
        this.filterFromText(view, true);
    }

    private void filterFromText(DefaultListView view, boolean scrollTo) {
        String text = view.getSearchField().getText();
        String regexFromString = FilterHelper.getRegexFromString2(text);
        JXList itemList = view.getItemList();
        StoreItem<File> sd = this.getSelectedItem((JList)itemList);
        if (sd == null || sd.getItem().getAbsolutePath().matches(regexFromString)) {
            sd = null;
        }
        Enumeration en = ((DefaultListModel)itemList.getModel()).elements();
        this.re.filterOut(StreamSupport.stream(Spliterators.spliteratorUnknownSize(Iterators.forEnumeration(en), 16), false).filter(v -> v != null && (text.length() == 0 || ((File)v.getItem()).getAbsolutePath().matches(regexFromString))), sd);
        itemList.setRowFilter(this.re);
        if (itemList.getSelectedValue() == null && itemList.getRowSorter().getViewRowCount() > 0) {
            itemList.setSelectedIndex(0);
        }
        if (scrollTo) {
            itemList.ensureIndexIsVisible(itemList.getSelectedIndex());
        }
    }

    private StoreItem<File> getSelectedItem(JList list) {
        return (StoreItem)list.getSelectedValue();
    }

    private void chooseFile(JList list) {
        List<Object> elements = list instanceof JXList ? Arrays.asList(((JXList)list).getSelectedValues()) : list.getSelectedValuesList();
        for (Object file : elements) {
            if (file == null) continue;
            this.fileConsumer.accept((File)((StoreItem)file).getItem());
        }
    }
}

