/*
 * Decompiled with CFR 0.152.
 */
package com.sigge.filerunner.imports.grib;

import com.sigge.filerunner.imports.grib.VariableWrapper;
import com.siggemannen.gribbs.TimeGridFile;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import ucar.nc2.Dimension;
import ucar.nc2.NetcdfFile;
import ucar.nc2.Variable;

public class GribFileState
implements Closeable {
    private TimeGridFile geo;
    private List<Variable> variables;
    private File file;
    private GeoVariables geoVariables;

    public GribFileState() {
    }

    public GribFileState(File f) {
        this.file = f;
    }

    @Override
    public void close() throws IOException {
        if (this.geo != null) {
            this.geo.close();
            this.geo = null;
            this.variables = null;
            this.geoVariables = null;
        }
    }

    public File getFile() {
        return this.file;
    }

    public void setFile(File f) {
        try {
            this.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.file = f;
    }

    public GeoVariables parse() throws IOException {
        this.geo = new TimeGridFile(this.file.getAbsolutePath());
        this.variables = this.geo.getFile().getVariables();
        this.geoVariables = new GeoVariables(this.variables);
        return this.geoVariables;
    }

    private static List<Variable> findGeospatVariables(NetcdfFile ncfile) {
        ArrayList<Variable> variables = new ArrayList<Variable>();
        for (Variable v : ncfile.getVariables()) {
            if (v.getDimensions().size() < 3) continue;
            variables.add(v);
        }
        return variables;
    }

    public List<? extends Variable> getVariables() {
        return this.variables;
    }

    public TimeGridFile getGribFile() {
        return this.geo;
    }

    public GeoVariables getGeoVariables() {
        return this.geoVariables;
    }

    public static class GeoVariables {
        List<VariableWrapper> latLonTime = new ArrayList<VariableWrapper>();
        List<VariableWrapper> latLonTimeEmpty = new ArrayList<VariableWrapper>();
        List<VariableWrapper> geos = new ArrayList<VariableWrapper>();

        public GeoVariables(List<Variable> variables) {
            Optional latPref = Optional.empty();
            Optional lonPref = Optional.empty();
            this.latLonTimeEmpty.add(null);
            for (Variable v : variables) {
                VariableWrapper wrapper = new VariableWrapper(v);
                switch (v.getDimensions().size()) {
                    case 0: {
                        break;
                    }
                    case 1: {
                        this.latLonTime.add(wrapper);
                        this.latLonTimeEmpty.add(wrapper);
                        break;
                    }
                    default: {
                        this.geos.add(wrapper);
                    }
                }
            }
            int i = this.latLonTime.size() - 1;
            while (i >= 0) {
                Variable vd = this.latLonTime.get(i).getV();
                boolean found = false;
                for (VariableWrapper dim : this.geos) {
                    Variable v = dim.getV();
                    for (Dimension d : v.getDimensions()) {
                        if (!vd.getShortName().equals(d.getShortName())) continue;
                        found = true;
                        break;
                    }
                    if (found) break;
                }
                if (!found) {
                    this.latLonTime.remove(i);
                    this.latLonTimeEmpty.remove(i);
                }
                --i;
            }
        }
    }
}

