/*
 * Decompiled with CFR 0.152.
 */
package com.sigge.filerunner.imports.geopackage;

import com.sigge.filerunner.imports.geopackage.GeoState;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.HashMap;
import java.util.NoSuchElementException;
import org.geotools.data.DataStore;
import org.geotools.data.DataStoreFinder;
import org.geotools.data.simple.SimpleFeatureReader;
import org.geotools.data.simple.SimpleFeatureSource;
import org.geotools.feature.FeatureCollection;
import org.geotools.feature.FeatureIterator;
import org.geotools.geopkg.FeatureEntry;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.filter.Filter;
import org.opengis.filter.IncludeFilter;

public class EsriPackageState
extends GeoState {
    private final DataStore dataStore;

    public EsriPackageState(File f) throws IOException {
        String[] names;
        HashMap<String, URL> map = new HashMap<String, URL>();
        map.put("url", f.toURI().toURL());
        this.dataStore = DataStoreFinder.getDataStore(map);
        for (String name : names = this.dataStore.getTypeNames()) {
            FeatureEntry featureEntry = new FeatureEntry();
            featureEntry.setGeometryColumn(name);
            featureEntry.setIdentifier(name);
            this.featureEntries.add(featureEntry);
        }
    }

    @Override
    public void close() throws IOException {
        this.dataStore.dispose();
    }

    @Override
    public SimpleFeatureReader getReader(FeatureEntry entry) throws IOException {
        IncludeFilter filter = Filter.INCLUDE;
        SimpleFeatureSource source = this.dataStore.getFeatureSource(entry.getGeometryColumn());
        FeatureCollection collection = source.getFeatures((Filter)filter);
        final FeatureIterator iter = collection.features();
        return new SimpleFeatureReader(){

            public SimpleFeature next() throws IOException, IllegalArgumentException, NoSuchElementException {
                return (SimpleFeature)iter.next();
            }

            public boolean hasNext() throws IOException {
                return iter.hasNext();
            }

            public SimpleFeatureType getFeatureType() {
                return ((SimpleFeature)iter.next()).getFeatureType();
            }

            public void close() throws IOException {
                iter.close();
            }
        };
    }
}

