/*
 * Decompiled with CFR 0.152.
 */
package com.sigge.filerunner.imports.excel;

import com.sigge.dbrunner.table.Column;
import com.sigge.dbrunner.table.ColumnType;
import com.sigge.filerunner.config.Config;
import com.sigge.filerunner.config.ConfigHandler;
import com.sigge.filerunner.imports.core.FileImporterModel;
import com.sigge.filerunner.imports.core.IPreviewer;
import com.sigge.filerunner.imports.core.ImportTablePreview;
import com.sigge.filerunner.imports.core.InvalidImportFileException;
import com.sigge.filerunner.imports.core.MainFrame;
import com.sigge.filerunner.imports.core.PreviewTableModel;
import com.sigge.filerunner.imports.excel.ExcelCellUtil;
import com.sigge.filerunner.imports.excel.ExcelHelper;
import com.sigge.filerunner.imports.excel.ExcelImportSettings;
import com.sigge.filerunner.imports.excel.ExcelPreviewView;
import com.sigge.filerunner.imports.excel.ExcelTypeDetector;
import com.sigge.filerunner.imports.excel.SimpleCellType;
import com.sigge.filerunner.view.core.VTable;
import com.siggemannen.backgroundrunner.BackgroundRunner;
import com.siggemannen.core.ListUtils;
import com.siggemannen.core.Tuple;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Vector;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.table.TableModel;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExcelPreviewer
implements IPreviewer {
    private final FileImporterModel model;
    private final MainFrame view;
    private final int ROWS_TO_PREVIEW = 200;
    private static final Logger LOGGER = LoggerFactory.getLogger(ExcelPreviewer.class);
    private static final String IMPORT_EXCEL_DETECT_DATATYPES = "imports.excel.autodetect";

    public ExcelPreviewer(FileImporterModel model, MainFrame view) {
        this.model = model;
        this.view = view;
    }

    @Override
    public void preview(File f) {
        ExcelImportSettings eis = this.model.getSettings() instanceof ExcelImportSettings ? (ExcelImportSettings)this.model.getSettings() : this.createNewSettings();
        this.model.setSettings(eis);
        eis.addListener((a, b, c) -> {
            if (ListUtils.in((Object)a, (Object[])new String[]{"includeRowNumberColumn", "detectDataType"})) {
                return;
            }
            try {
                this.previewInternal(f, eis);
            }
            catch (Exception e) {
                LOGGER.error("Error while previewing file", (Throwable)e);
                JOptionPane.showMessageDialog(this.view, "Something when wrong when previewing: " + e.getMessage());
            }
        });
        this.view.setCursor(new Cursor(3));
        new BackgroundRunner(() -> {
            try {
                this.previewInternal(f, eis);
                return null;
            }
            finally {
                this.view.setCursor(null);
            }
        }, e -> {}, e -> {
            LOGGER.error("Error while previewing", (Throwable)e);
            JOptionPane.showMessageDialog(this.view, "Something when wrong when previewing: " + e.getMessage());
        }).execute();
    }

    private ExcelImportSettings createNewSettings() {
        ExcelImportSettings settings = new ExcelImportSettings();
        Config config = ConfigHandler.getConfig();
        settings.setDetectDataType(config.getBooleanConfigValue(IMPORT_EXCEL_DETECT_DATATYPES, true));
        return settings;
    }

    private void previewInternal(File f, ExcelImportSettings eis) throws InvalidImportFileException {
        int totalSheets;
        ExcelTypeDetector detector;
        ArrayList<String> columns;
        int maxCols;
        Vector headers;
        ImportTablePreview imp;
        block25: {
            imp = new ImportTablePreview();
            Vector data = imp.getData();
            headers = imp.getHeaders();
            maxCols = 0;
            int currentRow = 0;
            int currentCol = 0;
            int sheetNr = 0;
            columns = new ArrayList<String>();
            detector = new ExcelTypeDetector();
            totalSheets = 1;
            try {
                Throwable throwable = null;
                Object var14_17 = null;
                try (Workbook wb = ExcelHelper.readWorkbook(f);){
                    totalSheets = wb.getNumberOfSheets();
                    if (eis.getSheet() > totalSheets) {
                        SwingUtilities.invokeLater(() -> JOptionPane.showMessageDialog(this.view, String.format("Document only contains %d sheets but you specified %d", wb.getNumberOfSheets(), eis.getSheet())));
                        return;
                    }
                    for (Sheet sheet : wb) {
                        if (++sheetNr != eis.getSheet()) continue;
                        int headerRow = 1 + eis.getSkipBeforeHeader();
                        int firstRealRow = 1 + headerRow + eis.getSkipAfterHeader();
                        for (Row row : sheet) {
                            currentCol = 0;
                            ++currentRow;
                            Vector<Tuple<SimpleCellType, String>> d = new Vector<Tuple<SimpleCellType, String>>();
                            int xrow = 0;
                            while (xrow < Math.min(eis.getMaxColumns(), row.getLastCellNum())) {
                                Cell cell = row.getCell(xrow, Row.MissingCellPolicy.RETURN_NULL_AND_BLANK);
                                ++currentCol;
                                try {
                                    Tuple<SimpleCellType, String> e;
                                    Tuple<SimpleCellType, String> tuple = e = cell != null ? ExcelCellUtil.getCellTypeAndValue(cell) : null;
                                    if (currentRow == headerRow) {
                                        columns.add(e == null ? "" : (String)e.second());
                                    } else if (currentRow >= firstRealRow) {
                                        d.add((Tuple<SimpleCellType, String>)(e != null ? e.second() : e));
                                        if (e != null) {
                                            detector.addCol(xrow, (SimpleCellType)((Object)e.first()), (String)e.second());
                                        }
                                    }
                                }
                                catch (Exception e) {
                                    LOGGER.error("Error while previewing file", (Throwable)e);
                                    System.out.println(String.format("Exception occuring reading value at row %d and column %d", xrow, currentCol));
                                }
                                maxCols = Math.max(maxCols, currentCol);
                                ++xrow;
                            }
                            if (currentRow >= firstRealRow) {
                                data.add(d);
                            }
                            if (currentRow - firstRealRow + 1 < 200) continue;
                            break block25;
                        }
                        break;
                    }
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (IOException e1) {
                LOGGER.error("Error while previewing file", (Throwable)e1);
            }
        }
        int snapshot = columns.size();
        int c = 0;
        while (c < maxCols - snapshot) {
            columns.add("");
            ++c;
        }
        headers.clear();
        int i = 0;
        while (i < maxCols) {
            headers.add(columns.get(i));
            ++i;
        }
        ExcelPreviewView epv = new ExcelPreviewView();
        VTable gridTable = epv.getGridTable();
        epv.sheetCountLabel.setText(totalSheets > 1 ? " / " + totalSheets : "");
        epv.getSheetSpinner().setEnabled(totalSheets > 1);
        epv.getSheetSpinner().setValue(eis.getSheet());
        epv.skipRowsAfterHeader.setValue(eis.getSkipAfterHeader());
        epv.skipRowsBeforeHeader.setValue(eis.getSkipBeforeHeader());
        epv.includeRowNumberColumn.setSelected(eis.isIncludeRowNumberColumn());
        epv.getSheetSpinner().addChangeListener(l -> eis.setSheet((Integer)epv.getSheetSpinner().getValue()));
        epv.skipRowsBeforeHeader.addChangeListener(l -> eis.setSkipBeforeHeader((Integer)excelPreviewView.skipRowsBeforeHeader.getValue()));
        epv.skipRowsAfterHeader.addChangeListener(l -> eis.setSkipAfterHeader((Integer)excelPreviewView.skipRowsAfterHeader.getValue()));
        epv.includeRowNumberColumn.addActionListener(l -> eis.setIncludeRowNumberColumn(excelPreviewView.includeRowNumberColumn.isSelected()));
        epv.autoDetectTypesCheckBox.setSelected(eis.isDetectDataType());
        epv.autoDetectTypesCheckBox.addActionListener(al -> {
            if (!excelPreviewView.autoDetectTypesCheckBox.isSelected()) {
                return;
            }
            this.detectDataTypes(headers, detector, epv);
        });
        epv.resetTypes.addActionListener(arg_0 -> ExcelPreviewer.lambda$10(imp, (JTable)((Object)gridTable), arg_0));
        epv.maxColumnsSpinner.setValue(eis.getMaxColumns());
        epv.maxColumnsSpinner.addChangeListener(l -> eis.setMaxColumns((Integer)excelPreviewView.maxColumnsSpinner.getValue()));
        imp.setModelData((JTable)((Object)gridTable), eis, 8);
        epv.editColumnButton.addActionListener(arg_0 -> ExcelPreviewer.lambda$12(imp, eis, (JTable)((Object)gridTable), arg_0));
        this.detectDataTypes(headers, detector, epv);
        this.saveSettings(eis);
        SwingUtilities.invokeLater(() -> {
            this.view.addPreviewPane(epv);
            this.view.setSize(Math.max(700, this.view.getWidth()), 550);
            this.view.setPreferredSize(new Dimension(Math.max(700, this.view.getWidth()), 550));
            this.view.revalidate();
            this.view.pack();
            this.view.getFrame().setLocationRelativeTo(new JFrame(null));
        });
    }

    private void saveSettings(ExcelImportSettings eis) {
        Config config = ConfigHandler.getConfig();
        config.setConfigValue(IMPORT_EXCEL_DETECT_DATATYPES, eis.isDetectDataType());
    }

    private void detectDataTypes(Vector headers, ExcelTypeDetector detector, ExcelPreviewView epv) {
        TableModel m = epv.getGridTable().getModel();
        if (m instanceof PreviewTableModel) {
            PreviewTableModel pv = (PreviewTableModel)m;
            int i = 0;
            while (i < pv.getColumnCount()) {
                epv.getGridTable().setValueAt(new Column("" + headers.get(i), this.getTypeFromCell(detector.getCellType(i))), 0, i);
                ++i;
            }
            pv.fireTableRowsUpdated(0, 0);
        }
    }

    private ColumnType getTypeFromCell(SimpleCellType cc) {
        switch (cc) {
            case BOOL: {
                return ColumnType.INT;
            }
            case DATE: {
                return ColumnType.DATETIME;
            }
            case FLOAT: {
                return ColumnType.FLOAT;
            }
            case INT: {
                return ColumnType.INT;
            }
        }
        return ColumnType.TEXT;
    }

    @Override
    public boolean accepts(File file) {
        return ExcelHelper.isExcelFile(file);
    }

    private static /* synthetic */ void lambda$10(ImportTablePreview importTablePreview, JTable jTable, ActionEvent al) {
        importTablePreview.resetDataTypes(jTable);
    }

    private static /* synthetic */ void lambda$12(ImportTablePreview importTablePreview, ExcelImportSettings excelImportSettings, JTable jTable, ActionEvent al) {
        importTablePreview.editColumns(excelImportSettings, jTable);
    }
}

