/*
 * Decompiled with CFR 0.152.
 */
package com.sigge.filerunner.imports.excel;

import com.monitorjbl.xlsx.impl.StreamingCell;
import com.sigge.dbrunner.IDatabaseOperator;
import com.sigge.dbrunner.table.Column;
import com.sigge.dbrunner.table.ColumnMapping;
import com.sigge.dbrunner.table.ColumnType;
import com.sigge.dbrunner.table.DataType;
import com.sigge.dbrunner.table.IBulk;
import com.sigge.dbrunner.table.ITable;
import com.sigge.dbrunner.table.ITableOperator;
import com.sigge.dbrunner.table.TableException;
import com.sigge.filerunner.core.DateUtils;
import com.sigge.filerunner.imports.core.AFileImporter;
import com.sigge.filerunner.imports.core.ColumnSelected;
import com.sigge.filerunner.imports.core.ExecutionContext;
import com.sigge.filerunner.imports.core.FileImporterModel;
import com.sigge.filerunner.imports.core.IImporter;
import com.sigge.filerunner.imports.core.ImportResult;
import com.sigge.filerunner.imports.core.TableUtils;
import com.sigge.filerunner.imports.excel.ExcelCellUtil;
import com.sigge.filerunner.imports.excel.ExcelHelper;
import com.sigge.filerunner.imports.excel.ExcelImportSettings;
import com.sigge.filerunner.sql.ServerDatabase;
import com.siggemannen.view.IStatusProgress;
import java.io.File;
import java.sql.SQLException;
import java.text.DateFormat;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.SimpleDateFormat;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.DateUtil;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;

public class ExcelImporter
extends AFileImporter
implements IImporter {
    private static final String EMPTY = "";
    private static final int MAX_DECIMALS_IN_A_FLOAT = 8;
    private static final int MAXCOLS = 200;
    private static final DateFormat DATE_FORMAT = new SimpleDateFormat("yyyy-MM-dd");
    private final FileImporterModel model;
    private final List<ServerDatabase> databases;

    public ExcelImporter(FileImporterModel model, ServerDatabase database) {
        this(model, Arrays.asList(database));
    }

    public ExcelImporter(FileImporterModel model, List<ServerDatabase> databases) {
        this.model = model;
        this.databases = databases;
    }

    @Override
    public void importFile(File file, ExecutionContext<ImportResult> exec) {
        this.runImport(exec, status -> this.execute((IStatusProgress)status, file));
    }

    ImportResult execute(IStatusProgress status, File file) {
        ImportResult ir;
        ExcelImportSettings eis = this.model.getSettings() instanceof ExcelImportSettings ? (ExcelImportSettings)this.model.getSettings() : new ExcelImportSettings();
        LocalDateTime start = DateUtils.getTimeAtUTC();
        AtomicInteger rowcount = new AtomicInteger(0);
        status.status("Reading file");
        try {
            Throwable throwable = null;
            Object var7_9 = null;
            try (Workbook wb = ExcelHelper.readWorkbook(file);){
                status.status("Finished reading");
                this.importSheet(wb, eis, this.model, status, rowcount);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            status.status("Error after reading: " + rowcount.get() + " rows: " + e, Optional.of(e));
            return new ImportResult("Error after reading: " + rowcount.get() + " rows: " + e);
        }
        LocalDateTime finish = DateUtils.getTimeAtUTC();
        if (status.isCancelled()) {
            ir = ImportResult.CANCELLED;
        } else {
            ir = new ImportResult(Arrays.asList(file), rowcount.get());
            ir.setDurationMs(DateUtils.getDuration(start, finish));
        }
        return ir;
    }

    private int importSheet(Workbook wb, final ExcelImportSettings settings, FileImporterModel model, final IStatusProgress status, final AtomicInteger aix) throws SQLException, TableException {
        String tableName = model.getTableName();
        Sheet sheet = wb.getSheetAt(settings.getSheet() - 1);
        ColumnSelected selectedColumns = settings.getColumnSelected();
        final ArrayList<String> columns = new ArrayList<String>(settings.getDbColumns() == null ? 0 : settings.getDbColumns().size());
        if (selectedColumns == null) {
            int min = Math.max(0, Math.min(model.getMaxColumns() == 0 ? 200 : model.getMaxColumns(), 200));
            selectedColumns = new ColumnSelected(min);
            if (columns.size() == 0) {
                int i = 0;
                while (i < min) {
                    columns.add("data" + i);
                    ++i;
                }
            }
        } else {
            settings.getDbColumns().forEach(e -> {
                boolean bl = columns.add(e.getName());
            });
        }
        if (settings.isIncludeRowNumberColumn()) {
            columns.add(0, "row_id");
        }
        int i = columns.size() - 1;
        while (i >= 0) {
            TableUtils.generateUniqueNames(columns, i);
            --i;
        }
        for (ServerDatabase database : this.databases) {
            IDatabaseOperator operator = database.getDb().getDatabaseOperator();
            ITableOperator tableOperator = operator.getTableOperator();
            ArrayList<Column> tableColumns = new ArrayList<Column>();
            ArrayList<ColumnMapping> cm = new ArrayList<ColumnMapping>();
            final List ordinals = selectedColumns.getSelectedColumns().stream().sorted().collect(Collectors.toList());
            int index = 0;
            if (settings.isIncludeRowNumberColumn()) {
                Column row_id = new Column((String)columns.get(0), new ColumnType(DataType.INT));
                tableColumns.add(row_id);
                cm.add(new ColumnMapping(row_id, index++));
            }
            Iterator iterator = ordinals.iterator();
            while (iterator.hasNext()) {
                int col = (Integer)iterator.next();
                Column column = new Column((String)columns.get(col + (settings.isIncludeRowNumberColumn() ? 0 : -1)), new ColumnType(DataType.TEXT));
                if (settings.getDbColumns() != null && settings.getDbColumns().size() >= col) {
                    column = new Column(column.getName(), settings.getDbColumns().get(col - 1));
                }
                tableColumns.add(column);
                cm.add(new ColumnMapping(column, index++));
            }
            ITable t = tableOperator.openOrCreate(database.getDatabase(), tableName, EMPTY, tableColumns);
            status.status("Ready for import of data");
            final DecimalFormat floatFormatter = this.getFloatFormatter();
            final Iterator ir = sheet.iterator();
            if (!ir.hasNext()) {
                status.status("Finished");
                continue;
            }
            if (!this.skipXRows(ir, settings.getSkipBeforeHeader() + 1)) {
                status.status("No rows");
                continue;
            }
            if (!this.skipXRows(ir, settings.getSkipAfterHeader())) {
                status.status("No rows after header");
                continue;
            }
            final ColumnSelected sec = selectedColumns;
            tableOperator.insert(t, cm, new IBulk(){
                Row row;

                @Override
                public boolean next() {
                    while (ir.hasNext()) {
                        if (status.isCancelled()) {
                            return false;
                        }
                        this.row = (Row)ir.next();
                        if (this.row == null) continue;
                        return true;
                    }
                    return false;
                }

                @Override
                public Object[] getData() {
                    int counter = aix.incrementAndGet();
                    if (counter % 100 == 0) {
                        status.status("Imported " + aix.get() + " rows");
                    }
                    Object[] ox = new Object[columns.size()];
                    if (settings.isIncludeRowNumberColumn()) {
                        ox[0] = counter;
                    }
                    int ord = 0;
                    while (ord < Math.min(settings.getMaxColumns(), this.row.getLastCellNum())) {
                        if (sec.isSelected(ord + 1) && ord < ordinals.size()) {
                            Cell cell = this.row.getCell(ord, Row.MissingCellPolicy.RETURN_NULL_AND_BLANK);
                            int index2 = ordinals.indexOf(ord + 1) + (settings.isIncludeRowNumberColumn() ? 1 : 0);
                            switch (ExcelImporter.this.getCellType(cell)) {
                                case STRING: {
                                    ox[index2] = cell.getStringCellValue();
                                    break;
                                }
                                case NUMERIC: {
                                    if (DateUtil.isCellDateFormatted((Cell)cell)) {
                                        ox[index2] = DATE_FORMAT.format(cell.getDateCellValue());
                                        break;
                                    }
                                    if (!(cell instanceof StreamingCell)) {
                                        ox[index2] = ExcelCellUtil.getCellValue(cell);
                                        break;
                                    }
                                    String q = floatFormatter.format(cell.getNumericCellValue());
                                    if (cell.getStringCellValue().matches("\\d+")) {
                                        q = cell.getStringCellValue();
                                    } else if (!q.equals(cell.getStringCellValue()) && cell instanceof StreamingCell && cell.getStringCellValue().contains("]")) {
                                        q = ExcelImporter.substringAfterLast(cell.getStringCellValue(), "]");
                                    }
                                    ox[index2] = q;
                                    break;
                                }
                                case BOOLEAN: {
                                    ox[index2] = cell.getBooleanCellValue() ? "1" : "0";
                                    break;
                                }
                            }
                        }
                        ++ord;
                    }
                    return ox;
                }
            });
            status.status("Finished database: " + database.getDatabase() + ", row inserted:" + aix.get());
        }
        return aix.get();
    }

    private boolean skipXRows(Iterator<Row> it, int rowsToSkip) {
        boolean hasNext = it.hasNext();
        int i = 0;
        while (i < rowsToSkip) {
            if (!hasNext) break;
            it.next();
            hasNext = it.hasNext();
            ++i;
        }
        return hasNext;
    }

    private int guessMaxColumns(Sheet sheet, int howManyRowsToProbe) {
        int maxCol = 0;
        int currentRow = 0;
        for (Row row : sheet) {
            ++currentRow;
            if (row != null) {
                maxCol = Math.max(row.getLastCellNum(), maxCol);
            }
            if (currentRow > howManyRowsToProbe) break;
        }
        if (maxCol == 0) {
            throw new RuntimeException("Couldn't guess number of columns after: " + howManyRowsToProbe + " probes");
        }
        return maxCol;
    }

    private DecimalFormat getFloatFormatter() {
        DecimalFormat floatFormatter = new DecimalFormat("#");
        floatFormatter.setDecimalFormatSymbols(new DecimalFormatSymbols(Locale.US));
        floatFormatter.setMaximumFractionDigits(8);
        return floatFormatter;
    }

    private CellType getCellType(Cell cell) {
        return cell == null ? CellType._NONE : (cell.getCellTypeEnum() == CellType.FORMULA ? cell.getCachedFormulaResultTypeEnum() : cell.getCellTypeEnum());
    }

    private static String substringAfterLast(String str, String separator) {
        if (str == null || str.isEmpty()) {
            return str;
        }
        int pos = str.lastIndexOf(separator);
        if (pos == -1 || pos == str.length() - separator.length()) {
            return EMPTY;
        }
        return str.substring(pos + separator.length());
    }

    @Override
    public boolean canImport(File file) {
        return ExcelHelper.isExcelFile(file);
    }
}

