/*
 * Decompiled with CFR 0.152.
 */
package com.sigge.filerunner.imports.excel;

import com.monitorjbl.xlsx.StreamingReader;
import com.sigge.filerunner.core.FileUtils;
import com.sigge.filerunner.imports.core.InvalidImportFileException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.poifs.filesystem.OfficeXmlFileException;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;

public class ExcelHelper {
    public static Workbook readWorkbook(File file) throws InvalidImportFileException {
        Workbook wb;
        try {
            wb = new HSSFWorkbook((InputStream)new FileInputStream(file));
        }
        catch (IOException e) {
            throw new InvalidImportFileException(InvalidImportFileException.Reason.UNKNOWN, "Failed to read from file: " + file, e);
        }
        catch (OfficeXmlFileException ee) {
            try {
                wb = ExcelHelper.openStreamed(file);
            }
            catch (Exception e) {
                try {
                    wb = new XSSFWorkbook((InputStream)new FileInputStream(file));
                }
                catch (IOException z) {
                    throw new InvalidImportFileException(InvalidImportFileException.Reason.UNKNOWN, "Failed to read from file: " + file, z);
                }
                catch (OfficeXmlFileException ex) {
                    throw new InvalidImportFileException(InvalidImportFileException.Reason.UNKNOWN, "Couldn't read the file, perhaps it's not an excel file?", ex);
                }
            }
        }
        try {
            wb.setMissingCellPolicy(Row.MissingCellPolicy.RETURN_NULL_AND_BLANK);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return wb;
    }

    private static Workbook openStreamed(File file) throws InvalidImportFileException {
        FileInputStream is;
        try {
            is = new FileInputStream(file);
        }
        catch (FileNotFoundException e1) {
            throw new InvalidImportFileException(InvalidImportFileException.Reason.FILE_NOT_FOUND, "Error while opening lib", e1);
        }
        Workbook wb = StreamingReader.builder().rowCacheSize(5000).bufferSize(1024).open((InputStream)is);
        return wb;
    }

    public static boolean isExcelFile(File file) {
        return file != null && file.exists() && file.isFile() && FileUtils.hasExtension(file, "xls", "xlsx");
    }
}

