/*
 * Decompiled with CFR 0.152.
 */
package com.sigge.filerunner.imports.csv;

import com.sigge.dbrunner.IDatabaseOperator;
import com.sigge.dbrunner.table.Column;
import com.sigge.dbrunner.table.ColumnMapping;
import com.sigge.dbrunner.table.ColumnType;
import com.sigge.dbrunner.table.DataType;
import com.sigge.dbrunner.table.IBulk;
import com.sigge.dbrunner.table.ITable;
import com.sigge.dbrunner.table.ITableOperator;
import com.sigge.filerunner.core.DateUtils;
import com.sigge.filerunner.imports.core.AFileImporter;
import com.sigge.filerunner.imports.core.ColumnSelected;
import com.sigge.filerunner.imports.core.ExecutionContext;
import com.sigge.filerunner.imports.core.FileImporterModel;
import com.sigge.filerunner.imports.core.IImporter;
import com.sigge.filerunner.imports.core.ImportResult;
import com.sigge.filerunner.imports.core.MainFrame;
import com.sigge.filerunner.imports.core.TableUtils;
import com.sigge.filerunner.imports.csv.CSVImportSettings;
import com.sigge.filerunner.imports.csv.CSVPreferenceHandler;
import com.sigge.filerunner.imports.csv.CSVUtils;
import com.sigge.filerunner.sql.ServerDatabase;
import com.sigge.fileutils.EncodingDetector;
import com.sigge.fileutils.SkipBOMReader;
import com.siggemannen.view.IStatusProgress;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import org.supercsv.io.CsvListReader;
import org.supercsv.prefs.CsvPreference;

public class CSVImporter
extends AFileImporter
implements IImporter {
    private final FileImporterModel model;
    private final MainFrame view;
    private final EncodingDetector encodingDetector;
    private final List<ServerDatabase> databases;

    public CSVImporter(FileImporterModel model, MainFrame view, ServerDatabase dataSupplier) {
        this(model, view, Arrays.asList(dataSupplier));
    }

    public CSVImporter(FileImporterModel model, MainFrame view, List<ServerDatabase> dataSupplier) {
        this.model = model;
        this.view = view;
        this.databases = dataSupplier;
        this.encodingDetector = new EncodingDetector();
    }

    @Override
    public boolean canImport(File file) {
        return CSVUtils.isCSV(file);
    }

    @Override
    public void importFile(File file, ExecutionContext<ImportResult> context) {
        CSVImportSettings csv = this.getSettings();
        if (csv == null) {
            context.getResultCallback().accept(ImportResult.CANCELLED);
            return;
        }
        this.runImport(context, status -> this.execute((IStatusProgress)status, csv, file));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    ImportResult execute(final IStatusProgress status, final CSVImportSettings csv, File file) {
        AtomicInteger aix;
        LocalDateTime start;
        block32: {
            CsvPreference z = this.getPrefs(csv);
            start = DateUtils.getTimeAtUTC();
            String tableName = this.model.getTableName();
            ColumnSelected selectedColumns = csv.getColumnSelected();
            final List<Integer> ordinals = selectedColumns.getSelectedColumns().stream().sorted().collect(Collectors.toList());
            final ArrayList<String> columns = new ArrayList<String>(ordinals.size());
            ordinals.forEach(s -> {
                boolean bl = columns.add(null);
            });
            if (csv.isIncludeRowNumberColumn()) {
                columns.add(0, "row_id");
            }
            status.status("Reading file");
            String encodingReal = this.encodingDetector.detectFileEncodingFast(file);
            aix = new AtomicInteger(0);
            try {
                Throwable throwable = null;
                Object var13_15 = null;
                try {
                    SkipBOMReader r = new SkipBOMReader((InputStream)new FileInputStream(file), encodingReal);
                    try {
                        try (final CsvListReader reader = new CsvListReader((Reader)r, z){

                            public List<String> read() throws IOException {
                                if (this.readRow()) {
                                    return this.getColumns();
                                }
                                return null;
                            }
                        };){
                            Iterator<ServerDatabase> iterator;
                            block30: {
                                String[] headers;
                                int i = 0;
                                while (true) {
                                    if (i >= csv.getSkipRowsBeforeHeader()) {
                                        if (csv.isFirstRowHeaders()) {
                                            headers = reader.getHeader(false);
                                        }
                                        break block30;
                                    }
                                    reader.read();
                                    ++i;
                                }
                                int counter = csv.isIncludeRowNumberColumn() ? 0 : -1;
                                int header = 0;
                                while (header < headers.length) {
                                    String h = headers[header];
                                    if (h != null) {
                                        h = h.trim();
                                    }
                                    if (ordinals.contains(header + 1)) {
                                        columns.set(++counter, h);
                                    }
                                    ++header;
                                }
                            }
                            int i = 0;
                            while (true) {
                                if (i >= csv.getSkipRowsAfterHeader()) break;
                                reader.read();
                                ++i;
                            }
                            i = columns.size() - 1;
                            while (true) {
                                if (i < 0) {
                                    iterator = this.databases.iterator();
                                    break;
                                }
                                TableUtils.generateUniqueNames(columns, i);
                                --i;
                            }
                            block13: while (iterator.hasNext()) {
                                ServerDatabase database = iterator.next();
                                IDatabaseOperator operator = database.getDb().getDatabaseOperator();
                                ITableOperator tableOperator = operator.getTableOperator();
                                ArrayList<Column> tableColumns = new ArrayList<Column>();
                                ArrayList<ColumnMapping> cm = new ArrayList<ColumnMapping>();
                                int index = 0;
                                if (csv.isIncludeRowNumberColumn()) {
                                    Column row_id = new Column((String)columns.get(0), new ColumnType(DataType.INT));
                                    tableColumns.add(row_id);
                                    cm.add(new ColumnMapping(row_id, index++));
                                }
                                int i2 = 0;
                                while (true) {
                                    if (i2 >= ordinals.size()) {
                                        ITable t = tableOperator.openOrCreate(database.getDatabase(), tableName, "", tableColumns);
                                        status.status("Ready for import of data");
                                        tableOperator.insert(t, cm, new IBulk(){
                                            List<String> read;

                                            @Override
                                            public boolean next() {
                                                if (status.isCancelled()) {
                                                    return false;
                                                }
                                                if (csv.getMaxRows() > 0 && aix.get() == csv.getMaxRows()) {
                                                    return false;
                                                }
                                                try {
                                                    this.read = reader.read();
                                                }
                                                catch (IOException e) {
                                                    status.cancel();
                                                    status.status("Error while reading", Optional.of(e));
                                                    return false;
                                                }
                                                return this.read != null;
                                            }

                                            @Override
                                            public Object[] getData() {
                                                int counter = aix.incrementAndGet();
                                                if (counter % 1000 == 0) {
                                                    status.status("Imported " + aix.get() + " rows");
                                                }
                                                Object[] ox = new Object[columns.size()];
                                                if (csv.isIncludeRowNumberColumn()) {
                                                    ox[0] = counter;
                                                }
                                                int ord = 0;
                                                while (ord < ordinals.size()) {
                                                    int index2 = (Integer)ordinals.get(ord);
                                                    if (index2 <= this.read.size()) {
                                                        ox[ord + (csv.isIncludeRowNumberColumn() ? 1 : 0)] = this.read.get(index2 - 1);
                                                    }
                                                    ++ord;
                                                }
                                                return ox;
                                            }
                                        });
                                        if (!status.isCancelled()) break;
                                        status.status("Import cancelled, rows read: " + aix.get());
                                        continue block13;
                                    }
                                    Column c = new Column((String)columns.get(index), new ColumnType(DataType.TEXT));
                                    if (csv.getDbColumns() != null && csv.getDbColumns().size() >= (Integer)ordinals.get(i2)) {
                                        c = new Column(c.getName(), csv.getDbColumns().get((Integer)ordinals.get(i2) - 1));
                                    }
                                    tableColumns.add(c);
                                    cm.add(new ColumnMapping(c, index++));
                                    ++i2;
                                }
                                status.status("Finished, row inserted:" + aix.get());
                            }
                        }
                        if (r == null) break block32;
                    }
                    catch (Throwable throwable2) {
                        if (throwable == null) {
                            throwable = throwable2;
                        } else if (throwable != throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        if (r == null) throw throwable;
                        r.close();
                        throw throwable;
                    }
                    r.close();
                }
                catch (Throwable throwable3) {
                    if (throwable == null) {
                        throwable = throwable3;
                        throw throwable;
                    }
                    if (throwable == throwable3) throw throwable;
                    throwable.addSuppressed(throwable3);
                    throw throwable;
                }
            }
            catch (Exception e) {
                status.status("Error after reading: " + aix.get() + " rows: " + e.getMessage(), Optional.of(e));
                return new ImportResult("Error after reading: " + aix.get() + " rows: " + e.getMessage());
            }
        }
        LocalDateTime finish = DateUtils.getTimeAtUTC();
        if (status.isCancelled()) {
            return ImportResult.CANCELLED;
        }
        ImportResult ir = new ImportResult(Arrays.asList(file), aix.get());
        ir.setDurationMs(DateUtils.getDuration(start, finish));
        return ir;
    }

    private CSVImportSettings getSettings() {
        CSVImportSettings csv = null;
        csv = !(this.model.getSettings() instanceof CSVImportSettings) ? new CSVImportSettings() : (CSVImportSettings)this.model.getSettings();
        if (csv.getCharSeparator().length() == 0) {
            CSVPreferenceHandler cv = new CSVPreferenceHandler(this.model, this.view);
            csv = cv.getPreferences();
        }
        if (csv != null) {
            CSVPreferenceHandler.saveSettingsToConfig(csv);
        }
        return csv;
    }

    private CsvPreference getPrefs(CSVImportSettings settings) {
        return new CsvPreference.Builder(this.getQuoteChar(settings), settings.getCharSeparator().codePointAt(0), "").build();
    }

    private char getQuoteChar(CSVImportSettings settings) {
        if (settings.getQuotedChar().length() == 0) {
            return '\u0000';
        }
        return settings.getQuotedChar().charAt(0);
    }
}

