/*
 * Decompiled with CFR 0.152.
 */
package com.sigge.filerunner.imports.core;

import com.sigge.dbrunner.table.Column;
import com.sigge.dbrunner.table.ColumnType;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import javax.swing.table.AbstractTableModel;

public class PreviewTableModel
extends AbstractTableModel {
    private final Vector columns;
    private final Vector rows;
    private final List<Column> dbColumns;

    public PreviewTableModel(Vector columns, Vector rows) {
        this(columns, rows, PreviewTableModel.createDefaultColumns(columns));
    }

    public Vector getColumns() {
        return this.columns;
    }

    private static List<Column> createDefaultColumns(Vector columns) {
        ArrayList<Column> sc = new ArrayList<Column>();
        for (Object o : columns) {
            sc.add(new Column(o != null ? o.toString() : "", ColumnType.TEXT));
        }
        return sc;
    }

    public PreviewTableModel(Vector columns, Vector rows, List<Column> dbColumns) {
        this.columns = columns;
        this.rows = rows;
        this.dbColumns = dbColumns;
    }

    @Override
    public String getColumnName(int column) {
        Object object = this.columns.get(column);
        return object == null ? "" : object.toString();
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return rowIndex == 0;
    }

    @Override
    public int getRowCount() {
        return this.rows.size() + 1;
    }

    @Override
    public int getColumnCount() {
        return this.columns.size();
    }

    public List<Column> getDbColumns() {
        return this.dbColumns;
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        if (rowIndex == 0) {
            if (this.dbColumns.size() > 0) {
                return this.dbColumns.get(columnIndex);
            }
            return null;
        }
        if (this.rows.size() - 1 < --rowIndex || ((Vector)this.rows.get(rowIndex)).size() - 1 < columnIndex) {
            return "";
        }
        return ((Vector)this.rows.get(rowIndex)).get(columnIndex);
    }

    @Override
    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
        Column c = this.dbColumns.get(columnIndex);
        Column c2 = null;
        if (aValue instanceof String) {
            c2 = new Column(c.getName(), (String)aValue);
        } else if (aValue instanceof ColumnType) {
            c2 = new Column(c.getName(), (ColumnType)aValue);
        } else if (aValue instanceof Column) {
            c2 = (Column)aValue;
        }
        this.dbColumns.set(columnIndex, c2);
    }
}

