/*
 * Decompiled with CFR 0.152.
 */
package com.sigge.filerunner.imports.core;

import com.sigge.dbrunner.table.Column;
import com.sigge.dbrunner.table.ColumnType;
import com.sigge.filerunner.imports.core.AColumnSettings;
import com.sigge.filerunner.imports.core.ColumnEditor;
import com.sigge.filerunner.imports.core.ColumnSelected;
import com.sigge.filerunner.imports.core.HeaderRenderer;
import com.sigge.filerunner.imports.core.PreviewTableModel;
import com.sigge.filerunner.imports.core.PreviewTableRenderer;
import com.sigge.filerunner.imports.core.StringDataTypeDetector;
import com.sigge.filerunner.view.JMemoryDialog;
import com.sigge.filerunner.view.core.VTable;
import com.siggemannen.view.ListTableElementModel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Vector;
import java.util.stream.Collectors;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.event.TableModelEvent;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import org.jdesktop.swingx.table.TableColumnExt;

public class ImportTablePreview {
    private final Vector data = new Vector();
    private final Vector headers = new Vector();
    private PreviewTableModel dataModel;

    public Vector getData() {
        return this.data;
    }

    public Vector getHeaders() {
        return this.headers;
    }

    public void editColumns(AColumnSettings ass, JTable gridTable) {
        JMemoryDialog fj = new JMemoryDialog(null, "Edit columns", true, "edit-columns");
        JPanel jep = new JPanel();
        VTable vt = new VTable();
        JScrollPane js = new JScrollPane((Component)((Object)vt));
        jep.setLayout(new BorderLayout());
        jep.add((Component)js, "Center");
        fj.setContent(jep, true);
        ListTableElementModel<ColumnEdit, String> lem = new ListTableElementModel<ColumnEdit, String>(){

            public Object getValueAt(int row, int column) {
                ColumnEdit ce = (ColumnEdit)this.getValueAt(row);
                switch (column) {
                    case 0: {
                        return ce.selected;
                    }
                    case 1: {
                        return ce.name;
                    }
                    case 2: {
                        return ce.col;
                    }
                }
                throw new RuntimeException("Unknown column: " + column);
            }

            public void setValueAt(Object aValue, int row, int column) {
                ColumnEdit ce = (ColumnEdit)this.getValueAt(row);
                switch (column) {
                    case 0: {
                        ce.selected = (Boolean)aValue;
                        break;
                    }
                    case 1: {
                        ce.name = (String)aValue;
                        break;
                    }
                    case 2: {
                        Column c = ce.col;
                        Column c2 = null;
                        if (aValue instanceof String) {
                            c2 = new Column(c.getName(), (String)aValue);
                        } else if (aValue instanceof ColumnType) {
                            c2 = new Column(c.getName(), (ColumnType)aValue);
                        } else if (aValue instanceof Column) {
                            c2 = (Column)aValue;
                        }
                        ce.col = c2;
                        break;
                    }
                    default: {
                        throw new RuntimeException("Invalid column");
                    }
                }
            }

            public Class<?> getColumnClass(int columnIndex) {
                switch (columnIndex) {
                    case 0: {
                        return Boolean.class;
                    }
                    case 1: {
                        return String.class;
                    }
                    case 2: {
                        return Column.class;
                    }
                }
                throw new RuntimeException("Unknown column: " + columnIndex);
            }

            public boolean isCellEditable(int row, int column) {
                return true;
            }
        };
        int i = 0;
        while (i < ass.dbColumns.size()) {
            Column c;
            ColumnEdit ced = new ColumnEdit();
            ced.selected = ass.columnSelected.isSelected(i + 1);
            ced.name = ass.dbColumns.get(i).getName();
            ced.col = c = new Column(ass.dbColumns.get(i).getName(), ass.dbColumns.get(i));
            lem.addRow((Object)ced);
            ++i;
        }
        ColumnEditor cellEditor = new ColumnEditor();
        lem.setColumns(Arrays.asList("Selected", "Name", "Data type"));
        vt.setModel((TableModel)lem);
        TableColumnExt tc = (TableColumnExt)vt.getColumnModel().getColumn(2);
        tc.setCellRenderer((TableCellRenderer)new PreviewTableRenderer(false));
        tc.setCellEditor((TableCellEditor)cellEditor);
        if (!fj.isSizeSetFromSettings()) {
            fj.setSize(640, 480);
        }
        fj.setLocationRelativeTo(null);
        fj.setVisible(true);
        if (fj.getReturnStatus() == 1) {
            TableColumnModel tem = gridTable.getColumnModel();
            int i2 = 0;
            while (i2 < lem.getRowCount()) {
                ColumnEdit ce = (ColumnEdit)lem.getValueAt(i2);
                ass.columnSelected.setSelected(i2 + 1, ce.selected);
                ass.dbColumns.set(i2, new Column(ce.name, ce.col));
                TableColumn column = tem.getColumn(i2);
                String originalName = column.getHeaderValue().toString();
                column.setHeaderValue(ce.name);
                if (column instanceof TableColumnExt) {
                    ((TableColumnExt)column).setToolTipText(String.valueOf(ce.name) + ", original: " + originalName);
                }
                ++i2;
            }
            TableModel tm = gridTable.getModel();
            if (tm instanceof PreviewTableModel) {
                PreviewTableModel tm2 = (PreviewTableModel)tm;
                tm2.getColumns().clear();
                tm2.getColumns().addAll(lem.getDataVector().stream().map(m -> m.name).collect(Collectors.toList()));
                tm2.getDbColumns().clear();
                tm2.getDbColumns().addAll(lem.getDataVector().stream().map(m -> m.col).collect(Collectors.toList()));
            }
            gridTable.repaint();
            gridTable.getTableHeader().repaint();
        }
    }

    public void setModelData(final JTable gridTable, AColumnSettings settings, int headersWithResize) {
        if (this.headers.size() > headersWithResize) {
            gridTable.setAutoResizeMode(0);
        } else {
            gridTable.setAutoResizeMode(4);
        }
        final ColumnSelected cs = new ColumnSelected(this.headers.size());
        settings.setColumnSelected(cs);
        ArrayList<Column> sc = new ArrayList<Column>();
        settings.setDbColumns(sc);
        this.dataModel = new PreviewTableModel(this.headers, this.data, sc);
        gridTable.setModel(this.dataModel);
        ColumnEditor cellEditor = new ColumnEditor();
        PreviewTableRenderer pv = new PreviewTableRenderer(true);
        int i = 0;
        while (i < this.headers.size()) {
            TableColumnExt tc = (TableColumnExt)gridTable.getColumnModel().getColumn(i);
            tc.setHeaderRenderer((TableCellRenderer)new HeaderRenderer(cs));
            tc.setToolTipText("" + this.headers.get(i));
            tc.setCellRenderer((TableCellRenderer)pv);
            tc.setCellEditor((TableCellEditor)cellEditor);
            sc.add(new Column("" + this.headers.get(i), ColumnType.TEXT));
            ++i;
        }
        gridTable.getTableHeader().addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent me) {
                TableColumnModel columnModel = gridTable.getColumnModel();
                int viewColumn = columnModel.getColumnIndexAtX(me.getX());
                int modelColumn = gridTable.convertColumnIndexToModel(viewColumn);
                cs.toggle(modelColumn + 1);
                ((JTableHeader)me.getSource()).repaint();
            }
        });
    }

    public void resetDataTypes(JTable previewTable) {
        TableModel m = previewTable.getModel();
        if (m instanceof PreviewTableModel) {
            PreviewTableModel pv = (PreviewTableModel)m;
            int answer = JOptionPane.showOptionDialog(null, "Do you want to reset all datatypes?", "Reset datatypes", 1, 1, null, new String[]{"Reset all", "Only reset autodetected", "Cancel"}, "Reset all");
            if (answer == 2) {
                return;
            }
            int i = 0;
            while (i < pv.getColumnCount()) {
                if (answer == 0) {
                    previewTable.setValueAt(ColumnType.TEXT, 0, i);
                } else if (answer == 1) {
                    previewTable.setValueAt(ColumnType.TEXT, 0, i);
                }
                ++i;
            }
        }
    }

    public void detectTypes(JTable previewTable) {
        TableModel m = previewTable.getModel();
        if (!(m instanceof PreviewTableModel)) {
            return;
        }
        PreviewTableModel pv = (PreviewTableModel)m;
        ArrayList<StringDataTypeDetector> detectors = new ArrayList<StringDataTypeDetector>();
        int i = 0;
        while (i < pv.getColumnCount()) {
            StringDataTypeDetector sd = new StringDataTypeDetector();
            detectors.add(sd);
            int j = 1;
            while (j < pv.getRowCount()) {
                Object valueAt = pv.getValueAt(j, i);
                if (valueAt != null && !sd.addValue(valueAt.toString())) break;
                ++j;
            }
            ColumnType preftype = sd.getPreferredType();
            previewTable.setValueAt(preftype, 0, i);
            ++i;
        }
        previewTable.tableChanged(new TableModelEvent(previewTable.getModel(), 0));
    }

    public PreviewTableModel getDataModel() {
        return this.dataModel;
    }

    class ColumnEdit {
        public static final int SELECTED = 0;
        public static final int NAME = 1;
        public static final int DATATYPE = 2;
        boolean selected;
        String name;
        Column col;

        ColumnEdit() {
        }
    }
}

