/*
 * Decompiled with CFR 0.152.
 */
package com.sigge.filerunner.imports.core;

import com.sigge.filerunner.core.DateUtils;
import com.sigge.filerunner.imports.core.ExecutionContext;
import com.sigge.filerunner.imports.core.FileImporterModel;
import com.sigge.filerunner.imports.core.IImporter;
import com.sigge.filerunner.imports.core.ImportResult;
import com.sigge.filerunner.imports.core.MainFrame;
import com.sigge.filerunner.imports.csv.CSVImporter;
import com.sigge.filerunner.imports.excel.ExcelImporter;
import com.sigge.filerunner.sql.ServerDatabase;
import com.siggemannen.binding.ValueHolder;
import com.siggemannen.view.Feedback;
import com.siggemannen.view.IBackgroundExecutorHandler;
import com.siggemannen.view.IStatusProgress;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Consumer;
import javax.swing.AbstractAction;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ImportAction
extends AbstractAction {
    private final FileImporterModel model;
    private final MainFrame view;
    private final List<IImporter> importers = new ArrayList<IImporter>();
    private static Logger LOGGER = LoggerFactory.getLogger(ImportAction.class);
    private boolean importMode = false;
    private ValueHolder<IStatusProgress> statusProgress;

    public ImportAction(FileImporterModel model, MainFrame view, List<ServerDatabase> dataSupplier) {
        this.model = model;
        this.view = view;
        this.importers.add(new ExcelImporter(model, dataSupplier));
        this.importers.add(new CSVImporter(model, view, dataSupplier));
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (this.importMode && this.statusProgress != null && this.statusProgress.getValue() != null) {
            ((IStatusProgress)this.statusProgress.getValue()).cancel();
            this.importMode = true;
            return;
        }
        File f = new File(this.model.getFileName());
        IImporter imp = null;
        for (IImporter importer : this.importers) {
            if (!importer.canImport(f)) continue;
            imp = importer;
            break;
        }
        if (imp == null) {
            SwingUtilities.invokeLater(() -> JOptionPane.showMessageDialog(this.view, "No handlers could handle file: " + this.model.getFileName()));
            return;
        }
        this.view.importButton.setText("Cancel...");
        this.view.previewButton.setEnabled(false);
        this.view.browseButton.setEnabled(false);
        this.view.getCloseButton().setEnabled(false);
        this.view.txtFileName.setEnabled(false);
        this.view.txtTableName.setEnabled(false);
        this.statusProgress = new ValueHolder<IStatusProgress>(){

            public void setValue(IStatusProgress value) {
                super.setValue((Object)value);
                if (!((ImportAction)ImportAction.this).view.importProgressBar.isVisible()) {
                    ((ImportAction)ImportAction.this).view.importProgressBar.setVisible(true);
                }
                if (!ImportAction.this.importMode) {
                    ((ImportAction)ImportAction.this).view.progressButton.setVisible(true);
                    ImportAction.this.importMode = true;
                }
                ((ImportAction)ImportAction.this).view.importProgressBar.setIndeterminate(true);
                ((ImportAction)ImportAction.this).view.importProgressBar.setStringPainted(true);
                value.addListener((message, ex) -> {
                    ((ImportAction)ImportAction.this).view.importProgressBar.setString(message);
                    if (ex.isPresent()) {
                        ((ImportAction)ImportAction.this).view.importProgressBar.setToolTipText(((Exception)ex.get()).toString());
                    }
                });
            }
        };
        ValueHolder bg = new ValueHolder();
        this.view.progressButton.addActionListener(al -> {
            if (bg.getValue() != null) {
                ((IBackgroundExecutorHandler)bg.getValue()).toForeground();
            }
        });
        imp.importFile(f, new ExecutionContext<ImportResult>(this::finishImport, (Consumer<IStatusProgress>)this.statusProgress, (Consumer<IBackgroundExecutorHandler>)bg).container(this.view.getFrame()));
    }

    private void finishImport(ImportResult result) {
        this.view.importProgressBar.setIndeterminate(false);
        this.view.importProgressBar.setValue(100);
        this.importMode = false;
        this.statusProgress = null;
        SwingUtilities.invokeLater(() -> {
            if (!result.isCancelled()) {
                if (!result.isSuccessful() && result.getFailureReason() != null) {
                    new Feedback().showError((Component)this.view, "Error occured when importing file", result.getFailureReason(), result.getException());
                } else {
                    JOptionPane.showMessageDialog(this.view, result.getFilesProcessed().size() + " file" + (result.getFilesProcessed().size() > 1 ? "s were" : " was") + " imported." + " Rows imported: " + result.getRowsImported() + "." + (result.getDurationMs() > 1000L ? " Took: " + DateUtils.getDuration(result.getDurationMs()) : ""), "Import results", 1);
                }
            }
            this.view.importButton.setText("Import");
            this.view.previewButton.setEnabled(true);
            this.view.browseButton.setEnabled(true);
            this.view.progressButton.setEnabled(false);
            this.view.getCloseButton().setEnabled(true);
            this.view.txtFileName.setEnabled(true);
            this.view.txtTableName.setEnabled(true);
            this.view.importProgressBar.setIndeterminate(false);
            for (ActionListener l : Arrays.asList(this.view.progressButton.getActionListeners())) {
                this.view.progressButton.removeActionListener(l);
            }
        });
    }
}

