/*
 * Decompiled with CFR 0.152.
 */
package com.sigge.filerunner.imports.core;

import com.sigge.dbrunner.Database;
import com.sigge.filerunner.imports.core.BrowseForFileAction;
import com.sigge.filerunner.imports.core.FileImporterListener;
import com.sigge.filerunner.imports.core.FileImporterModel;
import com.sigge.filerunner.imports.core.ImportAction;
import com.sigge.filerunner.imports.core.MainFrame;
import com.sigge.filerunner.imports.core.PreviewAction;
import com.sigge.filerunner.sql.ServerDatabase;
import com.sigge.filerunner.view.IconUtils;
import com.siggemannen.binding.ADocumentAdapter;
import java.awt.Dimension;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Consumer;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class FileImporter {
    private static final ImageIcon import_icon = IconUtils.getSmallIcon("document_down.png");
    private BrowseForFileAction browseFileAction;
    private PreviewAction previewAction;
    private ImportAction importAction;
    private MainFrame view;
    private final FileImporterModel model;
    private final List<FileImporterListener> listeners = new ArrayList<FileImporterListener>();
    private final List<ServerDatabase> servers;

    public FileImporter(Database server, String database) {
        this(Arrays.asList(new ServerDatabase(server, database)));
    }

    public FileImporter(List<ServerDatabase> databases) {
        this.servers = databases;
        this.model = new FileImporterModel();
    }

    public void doImport(JFrame mainFrame) {
        this.view = new MainFrame();
        this.previewAction = new PreviewAction(this.model, this.view);
        this.browseFileAction = new BrowseForFileAction(this.model, this.view, this.previewAction);
        this.importAction = new ImportAction(this.model, this.view, this.servers);
        this.view.getFrame().setTitle("Import data - " + this.servers.get(0).getLabel());
        this.initBindings();
        this.view.setSize(this.view.getWidth(), 120);
        this.view.setPreferredSize(new Dimension(this.view.getWidth(), 120));
        this.view.previewPane.setVisible(false);
        this.view.progressButton.setVisible(false);
        this.view.importButton.setIcon(import_icon);
        this.view.getSplitPane().setDividerLocation(-1);
        this.view.getFrame().pack();
        this.view.getFrame().setLocationRelativeTo(mainFrame == null ? new JFrame() : new JFrame(mainFrame.getGraphicsConfiguration()));
        this.view.getFrame().setVisible(true);
    }

    private void initBindings() {
        this.bind(this.view.txtFileName, this.model::setFileName, "fileName");
        this.bind(this.view.txtTableName, this.model::setTableName, "tableName");
        this.view.browseButton.addActionListener(this.browseFileAction);
        this.view.previewButton.addActionListener(this.previewAction);
        this.view.importButton.addActionListener(this.importAction);
        this.view.getCloseButton().addActionListener(e -> {
            this.view.setVisible(false);
            this.view.getFrame().dispose();
        });
        this.view.getFrame().setDefaultCloseOperation(2);
        this.view.getFrame().addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosed(WindowEvent e) {
                for (FileImporterListener listener : FileImporter.this.listeners) {
                    listener.onExit();
                }
            }
        });
        this.enableControls();
    }

    public void addFileImportListener(FileImporterListener listener) {
        this.listeners.add(listener);
    }

    public void removeFileImportListener(FileImporterListener listener) {
        this.listeners.remove(listener);
    }

    private void enableControls() {
        boolean valid = this.model.getFileName().length() > 0;
        this.view.importButton.setEnabled(valid && this.model.getTableName().length() > 0);
        this.view.previewButton.setEnabled(valid);
        this.view.txtTableName.setEnabled(valid);
    }

    private void bind(final JTextField je, final Consumer<String> value, String modelProperty) {
        je.getDocument().addDocumentListener((DocumentListener)new ADocumentAdapter(){

            protected void setValueFromDocument(DocumentEvent e) {
                value.accept(je.getText());
                FileImporter.this.enableControls();
            }
        });
        this.model.addModelListener(modelProperty, (name, v) -> {
            if (!je.getText().equals(v)) {
                je.setText((String)v);
            }
        });
    }
}

