/*
 * Decompiled with CFR 0.152.
 */
package com.sigge.filerunner.export;

import java.io.File;
import java.util.Collections;
import java.util.List;

public class ExportResult {
    private final boolean successful;
    private final List<File> files;
    private final String failureReason;
    private final Exception exception;

    ExportResult(String failureReason) {
        this.successful = false;
        this.failureReason = failureReason;
        this.files = Collections.EMPTY_LIST;
        this.exception = null;
    }

    ExportResult(Exception failureReason) {
        this.successful = false;
        this.failureReason = failureReason.getMessage();
        this.files = Collections.EMPTY_LIST;
        this.exception = failureReason;
    }

    ExportResult(List<File> files) {
        this.successful = true;
        this.failureReason = "";
        this.files = files;
        this.exception = null;
    }

    public boolean isSuccessful() {
        return this.successful;
    }

    public String getFailureReason() {
        return this.failureReason;
    }

    public List<File> filesExported() {
        return this.files;
    }

    public Exception getException() {
        return this.exception;
    }
}

