/*
 * Decompiled with CFR 0.152.
 */
package com.sigge.filerunner.core;

import java.time.LocalDateTime;

public class StoreItem<E> {
    private E item;
    private final LocalDateTime time;
    private int id;

    public StoreItem(E item) {
        this(item, LocalDateTime.now(), 0);
    }

    public StoreItem(E item, int id) {
        this(item, LocalDateTime.now(), id);
    }

    public StoreItem(E item, LocalDateTime time) {
        this(item, time, 0);
    }

    public StoreItem(E item, LocalDateTime time, int id) {
        this.item = item;
        this.time = time;
        this.id = id;
    }

    public StoreItem<E> updateItem(E newItem) {
        this.item = newItem;
        return this;
    }

    public E getItem() {
        return this.item;
    }

    public LocalDateTime getTime() {
        return this.time;
    }

    public int getId() {
        return this.id;
    }

    public void setId(int id) {
        this.id = id;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.item == null ? 0 : this.item.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StoreItem)) {
            return false;
        }
        StoreItem other = (StoreItem)obj;
        return !(this.item == null ? other.item != null : !this.item.equals(other.item));
    }

    public String toString() {
        return "[" + this.time + " @ " + this.item + ", id=" + this.id + "]";
    }
}

