/*
 * Decompiled with CFR 0.152.
 */
package com.sigge.filerunner.core;

import com.sigge.filerunner.core.ResurrectionDecorator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.IntStream;

public class CardHolder<E> {
    protected List<E> holder;
    protected int cursorPosition = -1;
    protected List<E> HIStory;
    protected List<E> resurrection;
    protected int numberOfDeletedElementsToKeep;
    private final List<CardHolderListener<E>> listeners = new ArrayList<CardHolderListener<E>>();
    private ResurrectionDecorator<E> decorator;

    public CardHolder() {
        this(new ArrayList(), 0);
    }

    public CardHolder(int numberOfDeletedElementsToKeep) {
        this(new ArrayList(), numberOfDeletedElementsToKeep, null);
    }

    public CardHolder(List<E> elements, int numberOfDeletedElementsToKeep) {
        this(elements, numberOfDeletedElementsToKeep, null);
    }

    public CardHolder(int numberOfDeletedElementsToKeep, ResurrectionDecorator<E> decorator) {
        this(new ArrayList(), numberOfDeletedElementsToKeep, decorator);
    }

    public CardHolder(List<E> elements, int numberOfDeletedElementsToKeep, ResurrectionDecorator<E> decorator) {
        this.holder = new ArrayList<E>(elements);
        if (this.holder.size() > 0) {
            this.cursorPosition = 0;
        }
        this.decorator = decorator == null ? new ResurrectionDecorator<E>(){} : decorator;
        this.numberOfDeletedElementsToKeep = numberOfDeletedElementsToKeep;
        this.HIStory = new ArrayList();
        this.resurrection = new ArrayList();
    }

    public final void addListener(CardHolderListener<E> listener) {
        this.listeners.add(listener);
    }

    public final void removeListener(CardHolderListener<E> listener) {
        this.listeners.remove(listener);
    }

    public synchronized E add(E element) {
        int size = this.holder.size();
        this.holder.add(element);
        if (this.cursorPosition >= 0) {
            this.HIStory.add(this.current());
        }
        this.cursorPosition = size;
        if (this.numberOfDeletedElementsToKeep > 0) {
            this.resurrection.remove(element);
            this.decorator.clear(element);
        }
        for (int x = 0; x < this.listeners.size(); ++x) {
            try {
                this.listeners.get(x).added(element, this.cursorPosition);
                continue;
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        return this.getCurrentAndRaiseEvent();
    }

    public E justAdd(E element) {
        this.holder.add(element);
        if (this.numberOfDeletedElementsToKeep > 0) {
            this.resurrection.remove(element);
            this.decorator.clear(element);
        }
        for (int x = 0; x < this.listeners.size(); ++x) {
            this.listeners.get(x).added(element, this.holder.size() - 1);
        }
        return element;
    }

    public E cyclePrevious() {
        if (this.holder.size() == 0) {
            throw new IllegalStateException("Cannot cycle empty holder");
        }
        if (this.HIStory.size() == 0) {
            return this.current();
        }
        E prev = this.HIStory.get(this.HIStory.size() - 1);
        return this.current(prev);
    }

    public E move(int fromIndex, int toIndex) {
        if (fromIndex == toIndex) {
            return this.current();
        }
        boolean end = toIndex >= this.holder.size();
        E el = this.holder.get(fromIndex);
        if (end) {
            this.holder.add(el);
            this.holder.remove(fromIndex);
        } else {
            this.holder.add(toIndex > fromIndex ? toIndex : toIndex, el);
            this.holder.remove(toIndex > fromIndex ? fromIndex : fromIndex + 1);
        }
        this.cursorPosition = end ? this.holder.size() - 1 : (toIndex > fromIndex ? toIndex - 1 : toIndex);
        return this.getCurrentAndRaiseEvent();
    }

    public E getNextInCycle() {
        if (this.holder.size() == 0) {
            throw new IllegalStateException("Cannot cycle empty holder");
        }
        if (this.HIStory.size() == 0) {
            return this.current();
        }
        return this.HIStory.get(this.HIStory.size() - 1);
    }

    public E next() {
        if (this.holder.size() == 0) {
            throw new IllegalStateException("Cannot next when no elements");
        }
        int oldPosition = this.cursorPosition;
        this.cursorPosition = (this.cursorPosition == this.holder.size() - 1 ? -1 : this.cursorPosition) + 1;
        if (oldPosition != this.cursorPosition) {
            this.HIStory.add(this.holder.get(oldPosition));
        }
        return this.getCurrentAndRaiseEvent();
    }

    public E restore() {
        if (this.numberOfDeletedElementsToKeep == 0) {
            throw new IllegalStateException("Restoring isn't supported");
        }
        if (this.resurrection.size() == 0) {
            return null;
        }
        this.HIStory.add(this.current());
        return this.add(this.decorator.decorateFromRestore(this.resurrection.remove(this.resurrection.size() - 1)));
    }

    public E restore(E tc) {
        if (this.numberOfDeletedElementsToKeep == 0) {
            throw new IllegalStateException("Restoring isn't supported");
        }
        if (this.resurrection.size() == 0) {
            return null;
        }
        if (!this.resurrection.remove(tc)) {
            return null;
        }
        this.HIStory.add(this.current());
        return this.add(this.decorator.decorateFromRestore(tc));
    }

    public E previous() {
        if (this.holder.size() == 0) {
            throw new IllegalStateException("Cannot previous when no elements");
        }
        int oldPosition = this.cursorPosition;
        this.cursorPosition = (this.cursorPosition == 0 ? this.holder.size() : this.cursorPosition) - 1;
        if (oldPosition != this.cursorPosition) {
            this.HIStory.add(this.holder.get(oldPosition));
        }
        return this.getCurrentAndRaiseEvent();
    }

    public E remove() {
        return this.removeIndices(this.asSet(this.cursorPosition));
    }

    public E removeAndChangeToPrevious() {
        return this.removeIndices(this.asSet(this.cursorPosition), true);
    }

    public E removeAndChangeToPrevious(int index) {
        return this.removeIndices(this.asSet(index), true);
    }

    public E removeLeft() {
        return this.removeIndices(IntStream.range(0, this.holder.size()).filter(i -> i < this.cursorPosition).mapToObj(i -> i).collect(Collectors.toSet()));
    }

    public E removeAll() {
        return this.removeIndices(IntStream.range(0, this.holder.size()).mapToObj(i -> i).collect(Collectors.toSet()));
    }

    public E removeRight() {
        return this.removeIndices(IntStream.range(0, this.holder.size()).filter(i -> i > this.cursorPosition).mapToObj(i -> i).collect(Collectors.toSet()));
    }

    public E removeOthers() {
        return this.removeIndices(IntStream.range(0, this.holder.size()).filter(i -> i != this.cursorPosition).mapToObj(i -> i).collect(Collectors.toSet()));
    }

    private E removeIndices(Set<Integer> indices) {
        return this.removeIndices(indices, false);
    }

    private E removeIndices(Set<Integer> indices, boolean previousAsCurrent) {
        Object i2;
        if (this.cursorPosition < 0) {
            throw new IllegalArgumentException("No elements so no current");
        }
        if (indices.size() == 0) {
            return this.current();
        }
        LinkedHashMap<Object, E> itemsToRemove = new LinkedHashMap<Object, E>();
        int cursorShift = 0;
        for (Object i2 : indices.stream().sorted((a, b) -> b.compareTo((Integer)a)).collect(Collectors.toList())) {
            if ((Integer)i2 < 0 || (Integer)i2 >= this.holder.size()) {
                throw new ArrayIndexOutOfBoundsException("Indice " + i2 + " is outside of bounds");
            }
            itemsToRemove.put(i2, this.holder.get((Integer)i2));
            if ((Integer)i2 > this.cursorPosition) continue;
            --cursorShift;
        }
        int oldCursorPosition = this.cursorPosition;
        i2 = itemsToRemove.keySet().iterator();
        while (i2.hasNext()) {
            int item = (Integer)i2.next();
            for (int i3 = 0; i3 < this.listeners.size(); ++i3) {
                CardHolderListener<E> l = this.listeners.get(i3);
                if (l.previewDeleted(this.holder.get(item), item)) continue;
                this.cursorPosition = item;
                return this.getCurrentAndRaiseEvent();
            }
            this.holder.remove(item);
            Object element = itemsToRemove.get(item);
            this.removeRelated(element);
            for (int i4 = 0; i4 < this.listeners.size(); ++i4) {
                try {
                    this.listeners.get(i4).deleted(element, item);
                    continue;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        if (previousAsCurrent && this.HIStory.size() > 0) {
            E element = this.HIStory.remove(this.HIStory.size() - 1);
            int prevCurrent = oldCursorPosition + cursorShift;
            this.cursorPosition = this.holder.indexOf(element);
            if (this.cursorPosition != prevCurrent && prevCurrent > -1) {
                this.HIStory.add(this.holder.get(prevCurrent));
            }
            return this.getCurrentAndRaiseEvent();
        }
        this.cursorPosition = oldCursorPosition + cursorShift;
        if (this.cursorPosition < 0 && this.holder.size() > 0) {
            this.cursorPosition = 0;
        }
        if (this.cursorPosition < 0) {
            return null;
        }
        while (this.HIStory.size() > 0 && this.HIStory.get(this.HIStory.size() - 1).equals(this.holder.get(this.cursorPosition))) {
            this.HIStory.remove(this.HIStory.size() - 1);
        }
        return this.getCurrentAndRaiseEvent();
    }

    public int size() {
        return this.holder.size();
    }

    public E remove(int index) {
        return this.removeIndices(this.asSet(index));
    }

    private void checkIndexParam(int index) {
        if (index < 0 || index >= this.holder.size()) {
            throw new IllegalArgumentException("Index " + index + " out of bounds");
        }
    }

    @SafeVarargs
    private final <T> Set<T> asSet(T ... elements) {
        return new HashSet<T>(Arrays.asList(elements));
    }

    public E remove(E el) {
        if (el == null) {
            throw new IllegalArgumentException("Index out of bounds");
        }
        int i = this.holder.indexOf(el);
        if (i == -1) {
            throw new IllegalArgumentException(String.format("Element %s not found", el));
        }
        return this.remove((E)i);
    }

    public E replaceCurrent(E newElement) {
        if (this.cursorPosition < 0) {
            return this.add(newElement);
        }
        Object oldCurrent = this.current();
        this.HIStory.replaceAll(l -> {
            if (l.equals(oldCurrent)) {
                return newElement;
            }
            return l;
        });
        this.holder.set(this.cursorPosition, newElement);
        for (int x = 0; x < this.listeners.size(); ++x) {
            this.listeners.get(x).replaced(newElement, oldCurrent, this.cursorPosition);
        }
        return this.getCurrentAndRaiseEvent();
    }

    public E replaceWith(E oldEl, E newEl) {
        int index;
        this.cursorPosition = index = this.holder.indexOf(oldEl);
        return this.replaceCurrent(newEl);
    }

    public E current() {
        if (this.cursorPosition < 0) {
            throw new IllegalArgumentException("No elements so no current");
        }
        return this.holder.get(this.cursorPosition);
    }

    public E current(E element) {
        if (element == null) {
            throw new IllegalArgumentException("cannot set current to null");
        }
        int index = this.holder.indexOf(element);
        if (index == -1) {
            throw new IllegalArgumentException("Element " + element + " not found");
        }
        if (this.cursorPosition >= 0 && index != this.cursorPosition) {
            this.HIStory.add(this.current());
        }
        this.cursorPosition = index;
        return this.getCurrentAndRaiseEvent();
    }

    public E current(int index) {
        this.checkIndexParam(index);
        if (this.cursorPosition >= 0 && index != this.cursorPosition) {
            this.HIStory.add(this.current());
        }
        this.cursorPosition = index;
        return this.getCurrentAndRaiseEvent();
    }

    public List<E> view() {
        return Collections.unmodifiableList(this.holder);
    }

    public List<E> historyView() {
        LinkedHashSet<E> items = new LinkedHashSet<E>(this.view());
        LinkedHashSet finalItems = new LinkedHashSet();
        if (this.size() > 0) {
            finalItems.add(this.current());
        }
        for (int i = this.HIStory.size() - 1; i >= 0; --i) {
            if (finalItems.size() == items.size()) {
                return new ArrayList(finalItems);
            }
            finalItems.add(this.HIStory.get(i));
        }
        for (Object item : items) {
            if (finalItems.size() == items.size()) break;
            finalItems.add(item);
        }
        return new ArrayList(finalItems);
    }

    public int currentIndex() {
        return this.cursorPosition;
    }

    public E getValueAt(int index) {
        this.checkIndexParam(index);
        return this.holder.get(index);
    }

    public int getIndex(E element) {
        return this.holder.indexOf(element);
    }

    private E getCurrentAndRaiseEvent() {
        E current = this.holder.get(this.cursorPosition);
        for (int x = 0; x < this.listeners.size(); ++x) {
            this.listeners.get(x).newCurrent(current, this.cursorPosition);
        }
        return current;
    }

    private void removeRelated(E element) {
        if (this.numberOfDeletedElementsToKeep > 0) {
            this.resurrection.remove(element);
            this.decorator.clear(element);
            if (this.resurrection.size() == this.numberOfDeletedElementsToKeep) {
                E removed = this.resurrection.remove(0);
                this.decorator.clear(removed);
                for (int x2 = 0; x2 < this.listeners.size(); ++x2) {
                    this.listeners.get(x2).removedFromResurrection(removed);
                }
            }
            for (int x3 = 0; x3 < this.listeners.size(); ++x3) {
                this.listeners.get(x3).resyncElementBeforeDelete(element);
            }
            this.resurrection.add(this.decorator.decorateToRestore(element));
        }
        this.HIStory = this.HIStory.stream().filter(f -> !f.equals(element)).collect(() -> new ArrayList(), (l, x) -> {
            if (l.size() == 0 || !l.get(l.size() - 1).equals(x)) {
                l.add(x);
            }
        }, (l, x) -> l.addAll(x));
    }

    public void removeCompletely(E tc) {
        this.resurrection.remove(tc);
        this.decorator.clear(tc);
        for (int x = 0; x < this.listeners.size(); ++x) {
            this.listeners.get(x).removedFromResurrection(tc);
        }
    }

    public static interface CardHolderListener<E> {
        default public boolean previewDeleted(E element, int index) {
            return true;
        }

        public void deleted(E var1, int var2);

        public void replaced(E var1, E var2, int var3);

        public void added(E var1, int var2);

        public void newCurrent(E var1, int var2);

        default public void removedFromResurrection(E element) {
        }

        default public E resyncElementBeforeDelete(E element) {
            return element;
        }
    }
}

