/*
 * Decompiled with CFR 0.152.
 */
package com.sigge.filerunner.completion.domain;

import com.sigge.filerunner.completion.domain.ParamReplacement;
import java.util.ArrayList;
import java.util.List;
import org.fife.ui.autocomplete.ParameterizedCompletion;

public class SQLParam
extends ParameterizedCompletion.Parameter {
    private String def;
    private boolean output;
    private boolean optional;
    private boolean variadic;
    private ParamReplacement extra;

    private SQLParam(Object type, String name) {
        super(type, name);
    }

    public SQLParam(Object type, String name, String def, boolean isOutput) {
        super(type, name);
        this.def = def;
        this.output = isOutput;
        this.extra = null;
    }

    public SQLParam(Object type, String name, ParamReplacement extraReplacements) {
        super(type, name);
        this.output = false;
        this.extra = extraReplacements;
        this.def = null;
    }

    public String getDefault() {
        return this.def;
    }

    public boolean isVariadic() {
        return this.variadic;
    }

    public boolean isOutput() {
        return this.output;
    }

    public boolean isOptional() {
        return this.optional;
    }

    public String getExtraText() {
        String txt = "";
        if (this.def != null) {
            txt = String.valueOf(txt) + " = " + this.def;
        }
        if (this.output && txt.length() == 0) {
            txt = String.valueOf(txt) + " OUTPUT";
        }
        return this.extra != null ? this.extra.getText() : txt;
    }

    public List<ParamReplacement> getParameterExtraReplacement() {
        ArrayList<ParamReplacement> repl = new ArrayList<ParamReplacement>();
        if (this.extra != null) {
            repl.add(this.extra);
        } else {
            if (this.def != null) {
                String text = " = " + this.def;
                repl.add(new ParamReplacement(text, 3, 3 + this.def.length() - 1, true));
            }
            if (this.output) {
                repl.add(new ParamReplacement(" OUTPUT", 0, 6));
            }
        }
        return repl;
    }

    public String getOutputString() {
        if (this.output) {
            return " OUTPUT";
        }
        return "";
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getName());
        if (this.getType() != null) {
            sb.append(" ").append(this.getType());
        }
        sb.append(this.getExtraText());
        return sb.toString();
    }

    /* synthetic */ SQLParam(Object object, String string, SQLParam sQLParam) {
        this(object, string);
    }

    public static class SQLParamBuilder {
        private final SQLParam sp;

        public SQLParamBuilder(Object type, String name) {
            this.sp = new SQLParam(type, name, null);
        }

        public SQLParamBuilder defaultValue(String defaultValue) {
            this.sp.def = defaultValue;
            return this;
        }

        public SQLParamBuilder output(boolean output) {
            this.sp.output = output;
            return this;
        }

        public SQLParamBuilder optional(boolean optional) {
            this.sp.optional = optional;
            return this;
        }

        public SQLParamBuilder variadic(boolean variadic) {
            this.sp.variadic = variadic;
            return this;
        }

        public SQLParamBuilder description(String description) {
            this.sp.setDescription(description);
            return this;
        }

        public SQLParamBuilder extra(ParamReplacement extra) {
            this.sp.extra = extra;
            return this;
        }

        public SQLParam build() {
            return this.sp;
        }
    }
}

