/*
 * Decompiled with CFR 0.152.
 */
package com.sigge.filerunner.commands;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import com.google.inject.name.Named;
import com.sigge.filerunner.action.FileRunnerAction;
import com.sigge.filerunner.recent.RecentExplorer;
import com.sigge.filerunner.recent.RecentPresenter;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import javax.swing.KeyStroke;

public class FileCommands {

    @Singleton
    public static class BrowseFileHistoryAction
    implements FileRunnerAction {
        @Inject
        RecentExplorer recentPresenter;

        @Override
        public void actionPerformed(ActionEvent e) {
            this.recentPresenter.present();
        }

        @Override
        public KeyStroke getDefaultKeyStroke() {
            return KeyStroke.getKeyStroke(82, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask() | 0x200);
        }

        @Override
        public String id() {
            return "browse_recent_files";
        }
    }

    @Singleton
    public static class ExitAction
    implements FileRunnerAction {
        @Inject
        @Named(value="EXIT")
        Runnable exitRunnable;

        @Override
        public void actionPerformed(ActionEvent e) {
            this.exitRunnable.run();
        }

        @Override
        public String id() {
            return "exit";
        }
    }

    @Singleton
    public static class OpenHistoryAction
    implements FileRunnerAction {
        @Inject
        RecentPresenter recentPresenter;

        @Override
        public void actionPerformed(ActionEvent e) {
            this.recentPresenter.present();
        }

        @Override
        public KeyStroke getDefaultKeyStroke() {
            return KeyStroke.getKeyStroke(90, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask() | 0x200);
        }

        @Override
        public String id() {
            return "open_history";
        }
    }
}

