/*
 * Decompiled with CFR 0.152.
 */
package com.sigge.filerunner.commands;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import com.sigge.filerunner.action.ABaseAction;
import com.sigge.filerunner.action.FileRunnerAction;
import com.sigge.filerunner.view.EditorManager;
import com.sigge.filerunner.view.IEditorManager;
import com.sigge.filerunner.view.changedb.ChangeDatabasePresenter;
import com.sigge.filerunner.view.rsyntaxtextarea.csv.TextTransformer;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import javax.inject.Named;
import javax.swing.KeyStroke;
import org.fife.ui.rtextarea.RTextArea;

public class EditorCommands {

    @Singleton
    public static class ChangeDatabaseAction
    extends ABaseAction {
        private final ChangeDatabasePresenter presenter;

        @Inject
        public ChangeDatabaseAction(ChangeDatabasePresenter presenter) {
            this.presenter = presenter;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.presenter.present();
        }

        @Override
        public String id() {
            return "change_database";
        }

        @Override
        public KeyStroke getDefaultKeyStroke() {
            return KeyStroke.getKeyStroke(71, 512);
        }
    }

    @Singleton
    public static class CopyAction
    implements FileRunnerAction {
        @Inject
        private EditorManager manager;

        @Override
        public void actionPerformed(ActionEvent e) {
            RTextArea.getAction((int)0).actionPerformed(new ActionEvent(this.manager.getCurrentTab(), 0, "copy"));
        }

        @Override
        public KeyStroke getDefaultKeyStroke() {
            return KeyStroke.getKeyStroke(67, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask());
        }

        @Override
        public String id() {
            return "copy";
        }
    }

    @Singleton
    public static class CutAction
    implements FileRunnerAction {
        @Inject
        private EditorManager manager;

        @Override
        public void actionPerformed(ActionEvent e) {
            RTextArea.getAction((int)1).actionPerformed(new ActionEvent(this.manager.getCurrentTab(), 0, "cut"));
        }

        @Override
        public KeyStroke getDefaultKeyStroke() {
            return KeyStroke.getKeyStroke(88, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask());
        }

        @Override
        public String id() {
            return "cut";
        }
    }

    @Singleton
    @Named(value="PASTE")
    public static class PasteAction
    implements FileRunnerAction {
        @Inject
        private TextTransformer transformer;
        @Inject
        private IEditorManager manager;

        @Override
        public void actionPerformed(ActionEvent e) {
            try {
                this.transformer.activateViaPaste(true);
                RTextArea.getAction((int)3).actionPerformed(new ActionEvent(this.manager.getCurrentTab(), 0, "paste"));
            }
            finally {
                this.transformer.activateViaPaste(false);
            }
        }

        @Override
        public KeyStroke getDefaultKeyStroke() {
            return KeyStroke.getKeyStroke(86, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask());
        }

        @Override
        public String id() {
            return "paste";
        }
    }

    @Singleton
    public static class PasteHistoryAction
    implements FileRunnerAction {
        @Inject
        private EditorManager manager;

        @Override
        public void actionPerformed(ActionEvent e) {
            this.manager.getCurrentTab().getActionMap().get("RTA.PasteHistoryAction").actionPerformed(new ActionEvent(this.manager.getCurrentTab(), 0, "RTA.PasteHistoryAction"));
        }

        @Override
        public KeyStroke getDefaultKeyStroke() {
            return KeyStroke.getKeyStroke(72, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask() | 0x40);
        }

        @Override
        public String id() {
            return "pasteHistory";
        }
    }

    @Singleton
    public static class RedoAction
    implements FileRunnerAction {
        @Inject
        private EditorManager manager;

        @Override
        public void actionPerformed(ActionEvent e) {
            RTextArea.getAction((int)4).actionPerformed(new ActionEvent(this.manager.getCurrentTab(), 0, "redo"));
        }

        @Override
        public KeyStroke getDefaultKeyStroke() {
            return KeyStroke.getKeyStroke(90, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask() | 0x40);
        }

        @Override
        public String id() {
            return "redo";
        }
    }

    @Singleton
    public static class SpecialPasteAction
    implements FileRunnerAction {
        @Inject
        private TextTransformer transformer;
        @Inject
        private EditorManager manager;

        @Override
        public void actionPerformed(ActionEvent e) {
            try {
                this.transformer.activateViaSpecialPaste(true);
                RTextArea.getAction((int)3).actionPerformed(new ActionEvent(this.manager.getCurrentTab(), 0, "paste"));
            }
            finally {
                this.transformer.activateViaSpecialPaste(false);
            }
        }

        @Override
        public KeyStroke getDefaultKeyStroke() {
            return KeyStroke.getKeyStroke(86, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask() | 0x40);
        }

        @Override
        public String id() {
            return "special_paste";
        }
    }

    @Singleton
    public static class UndoAction
    implements FileRunnerAction {
        @Inject
        private EditorManager manager;

        @Override
        public void actionPerformed(ActionEvent e) {
            RTextArea.getAction((int)6).actionPerformed(new ActionEvent(this.manager.getCurrentTab(), 0, "undo"));
        }

        @Override
        public KeyStroke getDefaultKeyStroke() {
            return KeyStroke.getKeyStroke(90, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask());
        }

        @Override
        public String id() {
            return "undo";
        }
    }
}

