/*
 * Decompiled with CFR 0.152.
 */
package com.codepoetics.protonpack.stateful;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import java.util.stream.IntStream;
import java.util.stream.Stream;

final class Window<T> {
    private final int size;
    private final int count;
    private final int index;
    private final List<T> contents;

    static <T> Window<T> initialise(int size) {
        ArrayList initialContents = new ArrayList(size);
        IntStream.range(0, size).forEach(i -> initialContents.add(null));
        return new Window(size, 0, 0, initialContents);
    }

    private Window(int size, int count, int index, List<T> contents) {
        this.size = size;
        this.count = count;
        this.index = index;
        this.contents = contents;
    }

    Window<T> add(T item) {
        int newCount;
        ArrayList<T> newContents = new ArrayList<T>(this.contents);
        newContents.set(this.index, item);
        int newIndex = this.index + 1;
        if (newIndex == this.size) {
            newIndex = 0;
        }
        if ((newCount = this.count + 1) > this.size) {
            newCount = this.size;
        }
        return new Window<T>(this.size, newCount, newIndex, newContents);
    }

    <R> Stream<R> reduce(Function<Stream<T>, R> reducer) {
        if (this.count < this.size) {
            return Stream.empty();
        }
        try (Stream<Object> windowStream = Stream.concat(IntStream.range(this.index, this.size).mapToObj(this.contents::get), IntStream.range(0, this.index).mapToObj(this.contents::get));){
            Stream<R> stream = Stream.of(reducer.apply(windowStream));
            return stream;
        }
    }
}

