/*
 * Decompiled with CFR 0.152.
 */
package com.siggemannen.thinlogger;

import com.siggemannen.thinlogger.Appender;
import com.siggemannen.thinlogger.ConsoleAppender;
import com.siggemannen.thinlogger.FileAppender;
import java.io.InputStream;
import java.security.AccessController;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.slf4j.Marker;
import org.slf4j.event.Level;
import org.slf4j.event.LoggingEvent;
import org.slf4j.helpers.LegacyAbstractLogger;
import org.slf4j.helpers.MessageFormatter;
import org.slf4j.helpers.NormalizedParameters;

public class ThinLogger
extends LegacyAbstractLogger {
    private static final long serialVersionUID = -632788891211436180L;
    protected static final int LOG_LEVEL_TRACE = 0;
    protected static final int LOG_LEVEL_DEBUG = 10;
    protected static final int LOG_LEVEL_INFO = 20;
    protected static final int LOG_LEVEL_WARN = 30;
    protected static final int LOG_LEVEL_ERROR = 40;
    static char SP = (char)32;
    static final String TID_PREFIX = "tid=";
    protected static final int LOG_LEVEL_OFF = 50;
    private static boolean INITIALIZED = false;
    private static final String CONFIGURATION_FILE = "logger.properties";
    private static final Properties properties = new Properties();
    private transient String shortLogName = null;
    public static final String SYSTEM_PREFIX = "org.slf4j.simpleLogger.";
    public static final String LOG_KEY_PREFIX = "org.slf4j.simpleLogger.log.";
    public static final String CACHE_OUTPUT_STREAM_STRING_KEY = "org.slf4j.simpleLogger.cacheOutputStream";
    public static final String WARN_LEVEL_STRING_KEY = "org.slf4j.simpleLogger.warnLevelString";
    public static final String LEVEL_IN_BRACKETS_KEY = "org.slf4j.simpleLogger.levelInBrackets";
    public static final String LOG_FILE_KEY = "org.slf4j.simpleLogger.logFile";
    public static final String SHOW_SHORT_LOG_NAME_KEY = "org.slf4j.simpleLogger.showShortLogName";
    public static final String SHOW_LOG_NAME_KEY = "org.slf4j.simpleLogger.showLogName";
    public static final String SHOW_THREAD_NAME_KEY = "org.slf4j.simpleLogger.showThreadName";
    public static final String SHOW_THREAD_ID_KEY = "org.slf4j.simpleLogger.showThreadId";
    public static final String DATE_TIME_FORMAT_KEY = "org.slf4j.simpleLogger.dateTimeFormat";
    public static final String SHOW_DATE_TIME_KEY = "org.slf4j.simpleLogger.showDateTime";
    public static final String DEFAULT_LOG_LEVEL_KEY = "org.slf4j.simpleLogger.defaultLogLevel";
    private static final List<Appender> appenders = new ArrayList<Appender>();
    private static ConsoleAppender consoleAppender;
    private static FileAppender fileAppender;
    private static Level consoleLevel;
    private static Level fileLevel;

    static {
        consoleLevel = null;
        fileLevel = null;
    }

    static void lazyInit() {
        if (INITIALIZED) {
            return;
        }
        ThinLogger.init();
        INITIALIZED = true;
    }

    ThinLogger(String name) {
        this.name = name;
    }

    static void init() {
        ThinLogger.loadProperties();
        consoleAppender = new ConsoleAppender();
        appenders.add(consoleAppender);
        String filename = properties.getProperty("filepattern");
        if (filename != null) {
            fileAppender = new FileAppender(filename);
            appenders.add(fileAppender);
        }
    }

    private static void loadProperties() {
        try {
            Throwable throwable = null;
            Object var1_3 = null;
            try (InputStream in = AccessController.doPrivileged(() -> {
                ClassLoader threadCL = Thread.currentThread().getContextClassLoader();
                if (threadCL != null) {
                    return threadCL.getResourceAsStream(CONFIGURATION_FILE);
                }
                return ClassLoader.getSystemResourceAsStream(CONFIGURATION_FILE);
            });){
                if (in != null) {
                    properties.load(in);
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    void write(Level level, StringBuilder buf, Throwable t) {
        String lazyString = null;
        int i = 0;
        while (i < appenders.size()) {
            Appender app = appenders.get(i);
            if (app.applicable(level) && !(app != consoleAppender ? app == fileAppender && fileLevel != null && fileLevel.compareTo((Enum)level) > 0 : consoleLevel != null && consoleLevel.compareTo((Enum)level) > 0)) {
                if (lazyString == null) {
                    lazyString = buf.toString();
                }
                app.append(level, t, lazyString);
            }
            ++i;
        }
    }

    private String getFormattedDate() {
        LocalDateTime now = LocalDateTime.now();
        String ms = "" + now.getNano() / 1000000;
        return now.getYear() + "-" + (now.getMonthValue() < 10 ? "0" : "") + now.getMonthValue() + "-" + (now.getDayOfMonth() < 10 ? "0" : "") + now.getDayOfMonth() + " " + (now.getHour() < 10 ? "0" : "") + now.getHour() + ":" + (now.getMinute() < 10 ? "0" : "") + now.getMinute() + ":" + (now.getSecond() < 10 ? "0" : "") + now.getSecond() + "." + ("00" + ms).substring(ms.length() - 1);
    }

    private String computeShortName() {
        return this.name.substring(this.name.lastIndexOf(".") + 1);
    }

    protected boolean isLevelEnabled(int logLevel) {
        return true;
    }

    public boolean isTraceEnabled() {
        return this.isLevelEnabled(0);
    }

    public boolean isDebugEnabled() {
        return this.isLevelEnabled(10);
    }

    public boolean isInfoEnabled() {
        return this.isLevelEnabled(20);
    }

    public boolean isWarnEnabled() {
        return this.isLevelEnabled(30);
    }

    public boolean isErrorEnabled() {
        return this.isLevelEnabled(40);
    }

    protected void handleNormalizedLoggingCall(Level level, Marker marker, String messagePattern, Object[] arguments, Throwable t) {
        ArrayList<Marker> markers = null;
        if (marker != null) {
            markers = new ArrayList<Marker>();
            markers.add(marker);
        }
        this.innerHandleNormalizedLoggingCall(level, markers, messagePattern, arguments, t);
    }

    private void innerHandleNormalizedLoggingCall(Level level, List<Marker> markers, String messagePattern, Object[] arguments, Throwable t) {
        StringBuilder buf = new StringBuilder(32);
        buf.append(this.getFormattedDate());
        buf.append(SP);
        buf.append('[');
        buf.append(Thread.currentThread().getName());
        buf.append("] ");
        buf.append(TID_PREFIX);
        buf.append(Thread.currentThread().getId());
        buf.append(SP);
        buf.append('[');
        String levelStr = level.name();
        buf.append(levelStr);
        buf.append(']');
        buf.append(SP);
        if (this.shortLogName == null) {
            this.shortLogName = this.computeShortName();
        }
        buf.append(String.valueOf(this.shortLogName)).append(" - ");
        if (markers != null) {
            buf.append(SP);
            for (Marker marker : markers) {
                buf.append(marker.getName()).append(SP);
            }
        }
        String formattedMessage = MessageFormatter.basicArrayFormat((String)messagePattern, (Object[])arguments);
        buf.append(formattedMessage);
        this.write(level, buf, t);
    }

    public void log(LoggingEvent event) {
        int levelInt = event.getLevel().toInt();
        if (!this.isLevelEnabled(levelInt)) {
            return;
        }
        NormalizedParameters np = NormalizedParameters.normalize((LoggingEvent)event);
        this.innerHandleNormalizedLoggingCall(event.getLevel(), event.getMarkers(), np.getMessage(), np.getArguments(), event.getThrowable());
    }

    protected String getFullyQualifiedCallerName() {
        return null;
    }

    public static void setConsoleLevel(Level level) {
        consoleLevel = level;
    }

    public static void setFileLevel(Level level) {
        fileLevel = level;
    }
}

