/*
 * Decompiled with CFR 0.152.
 */
package org.oxbow.swingbits.table.filter;

import java.awt.Component;
import java.awt.ComponentOrientation;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JTable;
import org.oxbow.swingbits.table.TableHeaderRenderer;
import org.oxbow.swingbits.table.filter.ITableFilter;
import org.oxbow.swingbits.util.swing.CompoundIcon;

class FilterTableHeaderRenderer
extends TableHeaderRenderer {
    private static final long serialVersionUID = 1L;
    private ImageIcon icon;
    private final int filterIconPlacement;
    private final ITableFilter<?> tableFilter;

    public FilterTableHeaderRenderer(ITableFilter<?> tableFilter, int filterIconPlacement) {
        this.tableFilter = tableFilter;
        this.filterIconPlacement = filterIconPlacement;
        if (this.filterIconPlacement != 10 && this.filterIconPlacement != 11) {
            throw new UnsupportedOperationException("The filter icon placement can only take the values of SwingConstants.LEADING or SwingConstants.TRAILING");
        }
    }

    private Icon getFilterIcon() {
        if (this.icon == null) {
            this.icon = new ImageIcon(this.getClass().getResource("funnel.png"));
            this.icon = new ImageIcon(this.icon.getImage().getScaledInstance(12, 12, 4));
        }
        return this.icon;
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        JLabel label = (JLabel)super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
        int modelColumn = table.convertColumnIndexToModel(column);
        if (this.tableFilter.isFiltered(modelColumn)) {
            ComponentOrientation orientation;
            Icon oldIcon = label.getIcon();
            Icon newIcon = null;
            newIcon = oldIcon == null ? this.getFilterIcon() : (ComponentOrientation.RIGHT_TO_LEFT.equals(orientation = label.getComponentOrientation()) ? (this.filterIconPlacement == 10 ? new CompoundIcon(oldIcon, this.getFilterIcon()) : new CompoundIcon(this.getFilterIcon(), oldIcon)) : (this.filterIconPlacement == 10 ? new CompoundIcon(this.getFilterIcon(), oldIcon) : new CompoundIcon(oldIcon, this.getFilterIcon())));
            label.setIcon(newIcon);
        }
        return label;
    }
}

