/*
 * Decompiled with CFR 0.152.
 */
package com.sigge.dbrunner.table;

import com.sigge.dbrunner.table.Column;
import com.sigge.dbrunner.table.ColumnMapping;
import com.sigge.dbrunner.table.CopyOptions;
import com.sigge.dbrunner.table.IBinder;
import com.sigge.dbrunner.table.IBulk;
import com.sigge.dbrunner.table.IOperator;
import com.sigge.dbrunner.table.ITable;
import com.sigge.dbrunner.table.ScriptOptions;
import com.sigge.dbrunner.table.TableException;
import com.sigge.dbrunner.table.TableNotExistsException;
import java.io.Closeable;
import java.io.OutputStream;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;

public interface ITableOperator
extends Closeable,
IOperator {
    public ITable create(String var1, String var2, String var3, List<Column> var4) throws TableException, SQLException;

    public ITable open(String var1, String var2, String var3) throws TableException, SQLException;

    default public ITable openOrCreate(String database, String name, String schema, List<Column> columns) throws TableException, SQLException {
        try {
            return this.open(database, name, schema);
        }
        catch (TableNotExistsException tex) {
            return this.create(database, name, schema, columns);
        }
    }

    public void insert(ITable var1, List<ColumnMapping> var2, IBulk var3) throws TableException, SQLException;

    public void insert(ITable var1, List<Column> var2, IBinder var3) throws TableException, SQLException;

    default public void insert(ITable table, List<Column> columns, ResultSet resultSet) throws TableException, SQLException {
        throw new UnsupportedOperationException("insert");
    }

    default public void delete(ITable table) throws TableException, SQLException {
        throw new UnsupportedOperationException("delete");
    }

    default public void truncate(ITable table) throws TableException, SQLException {
        throw new UnsupportedOperationException("truncate");
    }

    default public void drop(ITable table) throws TableException, SQLException {
        throw new UnsupportedOperationException("drop");
    }

    default public void copy(ITableOperator source, ITable sourceTable, List<Column> sourceColumns, ITable target, List<Column> columns, CopyOptions options) throws TableException, SQLException {
        Throwable throwable = null;
        Object var8_9 = null;
        try (ResultSet rs = source.openTable(sourceTable, sourceColumns);){
            this.insert(target, columns, rs);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    default public ResultSet openTable(ITable table, List<Column> columns) throws TableException, SQLException {
        throw new UnsupportedOperationException("openTable");
    }

    default public long script(ResultSet rs, OutputStream os, ScriptOptions options) throws SQLException {
        throw new UnsupportedOperationException("script");
    }

    default public void script(ITable rs, OutputStream os, ScriptOptions options) throws TableException, SQLException {
        throw new UnsupportedOperationException("script");
    }
}

