/*
 * Decompiled with CFR 0.152.
 */
package com.sigge.dbrunner.postgres;

import com.sigge.dbrunner.ADatabase;
import com.sigge.dbrunner.DatabaseServerConfig;
import com.sigge.dbrunner.IDatabaseOperator;
import com.sigge.dbrunner.jdbc.JDBCDatabaseOperator;
import com.sigge.dbrunner.postgres.PostgresRunner;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;

public class PostgresDatabase
extends ADatabase<PostgresRunner> {
    public static final String PROVIDER_NAME = "POSTGRES";
    private final DatabaseServerConfig config;
    private final String label;

    public PostgresDatabase(DatabaseServerConfig config) {
        this.config = config;
        this.label = config.getServerLabel();
    }

    @Override
    public String getDatabaseProvider() {
        return PROVIDER_NAME;
    }

    @Override
    public String getServer() {
        return this.config.getServer();
    }

    @Override
    public String getUser() {
        return this.config.getUser();
    }

    @Override
    public String getPassword() {
        return this.config.getPassword();
    }

    @Override
    public boolean isUseAD() {
        return false;
    }

    @Override
    public String getUniqueProviderName() {
        return String.valueOf(this.config.getUrl()) + "/" + (this.label != null ? this.label : "");
    }

    public String toString() {
        return this.config.getUrl();
    }

    @Override
    public Connection createConnection(String database, Object options) throws SQLException {
        String url = this.config.getUrl();
        Properties props = new Properties();
        if (database != null && database.length() > 0 && url.length() > 15) {
            String dburl = url;
            int qPos = url.indexOf(63);
            if (qPos != -1) {
                dburl = dburl.substring(0, qPos);
            }
            props.put("PGDBNAME", database);
            dburl = dburl.substring("jdbc:postgresql:".length());
            if (dburl.startsWith("//") && (dburl = dburl.substring(2)).contains("/")) {
                String toReplace = dburl.substring(dburl.indexOf("/"));
                url = url.replace(toReplace, "/");
            }
        }
        Connection c = DriverManager.getConnection(url, props);
        if (database != null && database.length() > 0) {
            c.setCatalog(database);
        }
        return c;
    }

    @Override
    public List<String> getDatabases() throws SQLException {
        ArrayList<String> database = new ArrayList<String>();
        PostgresRunner sr = this.createScriptRunner("");
        ResultSet rs = sr.executeQuery("select datname from pg_database where not datistemplate");
        while (rs.next()) {
            database.add(rs.getString(1));
        }
        sr.closeConnection();
        return database;
    }

    @Override
    protected PostgresRunner createScriptRunner(String databaseName) throws SQLException {
        return new PostgresRunner(this.createConnection(databaseName, null), this);
    }

    @Override
    public String getServerLabel() {
        return this.label;
    }

    @Override
    public String getUrl() {
        return this.config.getUrl();
    }

    @Override
    public IDatabaseOperator getDatabaseOperator() {
        return new JDBCDatabaseOperator(this);
    }

    @Override
    public String getConnectionUrl() {
        return this.getUrl();
    }
}

